/*
 * Decompiled with CFR 0.152.
 */
package javax.time.calendar.format;

import java.io.IOException;
import javax.time.calendar.Calendrical;
import javax.time.calendar.format.DateTimeFormatSymbols;
import javax.time.calendar.format.DateTimeParseContext;
import javax.time.calendar.format.DateTimeParser;
import javax.time.calendar.format.DateTimePrinter;

final class StringLiteralPrinterParser
implements DateTimePrinter,
DateTimeParser {
    private final String literal;

    StringLiteralPrinterParser(String literal) {
        this.literal = literal;
    }

    @Override
    public void print(Calendrical calendrical, Appendable appendable, DateTimeFormatSymbols symbols) throws IOException {
        appendable.append(this.literal);
    }

    @Override
    public boolean isPrintDataAvailable(Calendrical calendrical) {
        return true;
    }

    @Override
    public int parse(DateTimeParseContext context, String parseText, int position) {
        boolean ignoreCase;
        int length = parseText.length();
        if (position > length || position < 0) {
            throw new IndexOutOfBoundsException();
        }
        boolean bl = ignoreCase = !context.isCaseSensitive();
        if (!parseText.regionMatches(ignoreCase, position, this.literal, 0, this.literal.length())) {
            return ~position;
        }
        return position + this.literal.length();
    }

    public String toString() {
        String converted = this.literal.replace("'", "''");
        return "'" + converted + "'";
    }
}

