/*
 * Decompiled with CFR 0.152.
 */
package javax.time.calendar.zone;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import javax.time.Instant;
import javax.time.InstantProvider;
import javax.time.calendar.LocalDateTime;
import javax.time.calendar.OffsetDateTime;
import javax.time.calendar.Year;
import javax.time.calendar.ZoneOffset;
import javax.time.calendar.zone.ZoneOffsetTransition;
import javax.time.calendar.zone.ZoneOffsetTransitionRule;
import javax.time.calendar.zone.ZoneRules;

final class StandardZoneRules
extends ZoneRules
implements Serializable {
    private static final long serialVersionUID = 224698619L;
    private static final Year LAST_CACHED_YEAR = Year.of(2100);
    private final long[] standardTransitions;
    private final ZoneOffset[] standardOffsets;
    private final long[] savingsInstantTransitions;
    private final LocalDateTime[] savingsLocalTransitions;
    private final ZoneOffset[] wallOffsets;
    private final ZoneOffsetTransitionRule[] lastRules;
    private volatile transient ConcurrentMap<Year, ZoneOffsetTransition[]> lastRulesCache = new ConcurrentHashMap<Year, ZoneOffsetTransition[]>();

    StandardZoneRules(ZoneOffset baseStandardOffset, ZoneOffset baseWallOffset, List<OffsetDateTime> standardOffsetTransitionList, List<ZoneOffsetTransition> transitionList, List<ZoneOffsetTransitionRule> lastRules) {
        this.standardTransitions = new long[standardOffsetTransitionList.size()];
        this.standardOffsets = new ZoneOffset[standardOffsetTransitionList.size() + 1];
        this.standardOffsets[0] = baseStandardOffset;
        for (int i = 0; i < standardOffsetTransitionList.size(); ++i) {
            this.standardTransitions[i] = standardOffsetTransitionList.get(i).toEpochSeconds();
            this.standardOffsets[i + 1] = standardOffsetTransitionList.get(i).getOffset();
        }
        ArrayList<LocalDateTime> localTransitionList = new ArrayList<LocalDateTime>();
        ArrayList<ZoneOffset> localTransitionOffsetList = new ArrayList<ZoneOffset>();
        localTransitionOffsetList.add(baseWallOffset);
        for (ZoneOffsetTransition trans : transitionList) {
            if (trans.isGap()) {
                localTransitionList.add(trans.getDateTime().toLocalDateTime());
                localTransitionList.add(trans.getDateTimeAfter().toLocalDateTime());
            } else {
                localTransitionList.add(trans.getDateTimeAfter().toLocalDateTime());
                localTransitionList.add(trans.getDateTime().toLocalDateTime());
            }
            localTransitionOffsetList.add(trans.getOffsetAfter());
        }
        this.savingsLocalTransitions = localTransitionList.toArray(new LocalDateTime[localTransitionList.size()]);
        this.wallOffsets = localTransitionOffsetList.toArray(new ZoneOffset[localTransitionOffsetList.size()]);
        this.savingsInstantTransitions = new long[transitionList.size()];
        for (int i = 0; i < transitionList.size(); ++i) {
            this.savingsInstantTransitions[i] = transitionList.get(i).getInstant().getEpochSeconds();
        }
        this.lastRules = lastRules.toArray(new ZoneOffsetTransitionRule[lastRules.size()]);
    }

    private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
        in.defaultReadObject();
        this.lastRulesCache = new ConcurrentHashMap<Year, ZoneOffsetTransition[]>();
    }

    @Override
    public ZoneOffset getOffset(InstantProvider instantProvider) {
        Instant instant = Instant.from(instantProvider);
        long epochSecs = instant.getEpochSeconds();
        if (this.lastRules.length > 0 && epochSecs > this.savingsInstantTransitions[this.savingsInstantTransitions.length - 1]) {
            OffsetDateTime dt = OffsetDateTime.fromInstant(instant, this.wallOffsets[this.wallOffsets.length - 1]);
            ZoneOffsetTransition[] transArray = this.findTransitionArray(dt.toYear());
            ZoneOffsetTransition trans = null;
            for (int i = 0; i < transArray.length; ++i) {
                trans = transArray[i];
                if (!instant.isBefore(trans.getInstant())) continue;
                return trans.getOffsetBefore();
            }
            return trans.getOffsetAfter();
        }
        int index = Arrays.binarySearch(this.savingsInstantTransitions, epochSecs);
        if (index < 0) {
            index = -index - 2;
        }
        return this.wallOffsets[index + 1];
    }

    @Override
    public ZoneRules.OffsetInfo getOffsetInfo(LocalDateTime dt) {
        if (this.lastRules.length > 0 && dt.isAfter(this.savingsLocalTransitions[this.savingsLocalTransitions.length - 1])) {
            ZoneOffsetTransition[] transArray = this.findTransitionArray(dt.toYear());
            ZoneRules.OffsetInfo info = null;
            for (ZoneOffsetTransition trans : transArray) {
                info = this.findOffsetInfo(dt, trans);
                if (!info.isTransition() && !info.getOffset().equals(trans.getOffsetBefore())) continue;
                return info;
            }
            return info;
        }
        int index = Arrays.binarySearch(this.savingsLocalTransitions, dt);
        if (index == -1) {
            return this.createOffsetInfo(dt, this.wallOffsets[0]);
        }
        if (index < 0) {
            index = -index - 2;
        } else if (index < this.savingsLocalTransitions.length - 1 && this.savingsLocalTransitions[index].equals(this.savingsLocalTransitions[index + 1])) {
            ++index;
        }
        if ((index & 1) == 0) {
            LocalDateTime dtBefore = this.savingsLocalTransitions[index];
            LocalDateTime dtAfter = this.savingsLocalTransitions[index + 1];
            ZoneOffset offsetBefore = this.wallOffsets[index / 2];
            ZoneOffset offsetAfter = this.wallOffsets[index / 2 + 1];
            if (offsetAfter.getAmountSeconds() > offsetBefore.getAmountSeconds()) {
                return this.createOffsetInfo(dt, OffsetDateTime.from(dtBefore, offsetBefore), offsetAfter);
            }
            return this.createOffsetInfo(dt, OffsetDateTime.from(dtAfter, offsetBefore), offsetAfter);
        }
        return this.createOffsetInfo(dt, this.wallOffsets[index / 2 + 1]);
    }

    private ZoneRules.OffsetInfo findOffsetInfo(LocalDateTime dt, ZoneOffsetTransition trans) {
        if (trans.isGap()) {
            if (dt.isBefore(trans.getLocal())) {
                return this.createOffsetInfo(dt, trans.getOffsetBefore());
            }
            if (dt.isBefore(trans.getDateTimeAfter().toLocalDateTime())) {
                return this.createOffsetInfo(dt, trans.getDateTime(), trans.getOffsetAfter());
            }
            return this.createOffsetInfo(dt, trans.getOffsetAfter());
        }
        if (!dt.isBefore(trans.getLocal())) {
            return this.createOffsetInfo(dt, trans.getOffsetAfter());
        }
        if (dt.isBefore(trans.getDateTimeAfter().toLocalDateTime())) {
            return this.createOffsetInfo(dt, trans.getOffsetBefore());
        }
        return this.createOffsetInfo(dt, trans.getDateTime(), trans.getOffsetAfter());
    }

    private ZoneOffsetTransition[] findTransitionArray(Year year) {
        ZoneOffsetTransition[] transArray = (ZoneOffsetTransition[])this.lastRulesCache.get(year);
        if (transArray != null) {
            return transArray;
        }
        ZoneOffsetTransitionRule[] ruleArray = this.lastRules;
        transArray = new ZoneOffsetTransition[ruleArray.length];
        for (int i = 0; i < ruleArray.length; ++i) {
            transArray[i] = ruleArray[i].createTransition(year.getValue());
        }
        if (year.isBefore(LAST_CACHED_YEAR)) {
            this.lastRulesCache.putIfAbsent(year, transArray);
        }
        return transArray;
    }

    @Override
    public ZoneOffset getStandardOffset(InstantProvider instantProvider) {
        Instant instant = Instant.from(instantProvider);
        long epochSecs = instant.getEpochSeconds();
        int index = Arrays.binarySearch(this.standardTransitions, epochSecs);
        if (index < 0) {
            index = -index - 2;
        }
        return this.standardOffsets[index + 1];
    }

    @Override
    public ZoneOffsetTransition nextTransition(InstantProvider instantProvider) {
        Instant instant = Instant.from(instantProvider);
        long epochSecs = instant.getEpochSeconds();
        if (epochSecs >= this.savingsInstantTransitions[this.savingsInstantTransitions.length - 1]) {
            if (this.lastRules.length == 0) {
                return null;
            }
            OffsetDateTime dt = OffsetDateTime.fromInstant(instant, this.wallOffsets[this.wallOffsets.length - 1]);
            Year year = dt.toYear();
            while (true) {
                ZoneOffsetTransition[] transArray;
                for (ZoneOffsetTransition trans : transArray = this.findTransitionArray(year)) {
                    if (!instant.isBefore(trans.getInstant())) continue;
                    return trans;
                }
                if (year.getValue() == Integer.MAX_VALUE) {
                    return null;
                }
                year = year.next();
            }
        }
        int index = Arrays.binarySearch(this.savingsInstantTransitions, epochSecs);
        index = index < 0 ? -index - 1 : ++index;
        Instant transitionInstant = Instant.seconds(this.savingsInstantTransitions[index]);
        OffsetDateTime trans = OffsetDateTime.fromInstant(transitionInstant, this.wallOffsets[index]);
        return this.createTransition(trans, this.wallOffsets[index + 1]);
    }

    @Override
    public ZoneOffsetTransition previousTransition(InstantProvider instantProvider) {
        int index;
        Instant instant = Instant.from(instantProvider);
        long epochSecs = instant.getEpochSeconds();
        if (instant.getNanoOfSecond() > 0 && epochSecs < Long.MAX_VALUE) {
            ++epochSecs;
        }
        long lastHistoric = this.savingsInstantTransitions[this.savingsInstantTransitions.length - 1];
        if (this.lastRules.length > 0 && epochSecs > lastHistoric) {
            ZoneOffset lastHistoricOffset = this.wallOffsets[this.wallOffsets.length - 1];
            OffsetDateTime dt = OffsetDateTime.fromInstant(instant, lastHistoricOffset);
            OffsetDateTime lastHistoricDT = OffsetDateTime.fromInstant(Instant.seconds(lastHistoric), lastHistoricOffset);
            Year year = dt.toYear();
            while (year.getValue() > lastHistoricDT.getYear()) {
                ZoneOffsetTransition[] transArray = this.findTransitionArray(year);
                for (int i = transArray.length - 1; i >= 0; --i) {
                    if (!instant.isAfter(transArray[i].getInstant())) continue;
                    return transArray[i];
                }
                year = year.previous();
            }
        }
        if ((index = Arrays.binarySearch(this.savingsInstantTransitions, epochSecs)) < 0) {
            index = -index - 1;
        }
        if (index <= 0) {
            return null;
        }
        Instant transitionInstant = Instant.seconds(this.savingsInstantTransitions[index - 1]);
        OffsetDateTime trans = OffsetDateTime.fromInstant(transitionInstant, this.wallOffsets[index - 1]);
        return this.createTransition(trans, this.wallOffsets[index]);
    }

    @Override
    public List<ZoneOffsetTransition> getTransitions() {
        ArrayList<ZoneOffsetTransition> list = new ArrayList<ZoneOffsetTransition>();
        for (int i = 0; i < this.savingsInstantTransitions.length; ++i) {
            Instant instant = Instant.seconds(this.savingsInstantTransitions[i]);
            OffsetDateTime trans = OffsetDateTime.fromInstant(instant, this.wallOffsets[i]);
            list.add(this.createTransition(trans, this.wallOffsets[i + 1]));
        }
        return list;
    }

    @Override
    public List<ZoneOffsetTransitionRule> getTransitionRules() {
        return new ArrayList<ZoneOffsetTransitionRule>(Arrays.asList(this.lastRules));
    }

    @Override
    public boolean equals(Object otherRules) {
        if (this == otherRules) {
            return true;
        }
        if (otherRules instanceof StandardZoneRules) {
            StandardZoneRules other = (StandardZoneRules)otherRules;
            return Arrays.equals(this.standardTransitions, other.standardTransitions) && Arrays.equals(this.standardOffsets, other.standardOffsets) && Arrays.equals(this.savingsInstantTransitions, other.savingsInstantTransitions) && Arrays.equals(this.wallOffsets, other.wallOffsets) && Arrays.equals(this.lastRules, other.lastRules);
        }
        return false;
    }

    @Override
    public int hashCode() {
        return Arrays.hashCode(this.standardTransitions) ^ Arrays.hashCode(this.standardOffsets) ^ Arrays.hashCode(this.savingsInstantTransitions) ^ Arrays.hashCode(this.wallOffsets) ^ Arrays.hashCode(this.lastRules);
    }
}

