/*
 * Decompiled with CFR 0.152.
 */
package javax.time.calendar.zone;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.ObjectOutputStream;
import java.text.ParsePosition;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.StringTokenizer;
import java.util.jar.JarOutputStream;
import java.util.zip.ZipEntry;
import javax.time.calendar.DateAdjusters;
import javax.time.calendar.DayOfWeek;
import javax.time.calendar.ISOChronology;
import javax.time.calendar.LocalDate;
import javax.time.calendar.LocalDateTime;
import javax.time.calendar.LocalTime;
import javax.time.calendar.MonthOfYear;
import javax.time.calendar.Year;
import javax.time.calendar.ZoneOffset;
import javax.time.calendar.format.DateTimeFormatter;
import javax.time.calendar.format.DateTimeFormatterBuilder;
import javax.time.calendar.format.DateTimeParseContext;
import javax.time.calendar.zone.ZoneRules;
import javax.time.calendar.zone.ZoneRulesBuilder;
import javax.time.period.Period;

public final class TZDBZoneRulesCompiler {
    private final Map<Object, Object> deduplicateMap = new HashMap<Object, Object>();
    private final Map<String, List<TZDBRule>> rules = new HashMap<String, List<TZDBRule>>();
    private final Map<String, List<TZDBZone>> zones = new HashMap<String, List<TZDBZone>>();
    private final Map<String, String> links = new HashMap<String, String>();
    private final Map<String, ZoneRules> builtZones = new HashMap<String, ZoneRules>();
    private final String version;
    private final List<File> sourceFiles;
    private final File destinationDir;
    private final boolean verbose;

    public static void main(String[] args) {
        String arg;
        int i;
        if (args.length < 2) {
            TZDBZoneRulesCompiler.outputHelp();
            return;
        }
        String version = null;
        File srcDir = null;
        File dstDir = null;
        boolean verbose = false;
        File baseDir = new File(System.getProperty("user.dir"));
        for (i = 0; i < args.length && (arg = args[i]).startsWith("-"); ++i) {
            if ("-srcdir".equals(arg)) {
                if (srcDir == null && ++i < args.length) {
                    srcDir = new File(baseDir, args[i]);
                    continue;
                }
            } else if ("-dstdir".equals(arg)) {
                if (dstDir == null && ++i < args.length) {
                    dstDir = new File(baseDir, args[i]);
                    continue;
                }
            } else if ("-version".equals(arg)) {
                if (version == null && ++i < args.length) {
                    version = args[i];
                    continue;
                }
            } else if ("-verbose".equals(arg)) {
                if (!verbose) {
                    verbose = true;
                    continue;
                }
            } else if (!"-help".equals(arg)) {
                System.out.println("Unrecognised option: " + arg);
            }
            TZDBZoneRulesCompiler.outputHelp();
            return;
        }
        if (version == null) {
            System.out.println("Missing -version");
            return;
        }
        srcDir = srcDir != null ? srcDir : baseDir;
        File file = dstDir = dstDir != null ? dstDir : baseDir;
        if (i >= args.length) {
            System.out.println("Missing source files");
            TZDBZoneRulesCompiler.outputHelp();
            return;
        }
        ArrayList<File> sourceFiles = new ArrayList<File>();
        while (i < args.length) {
            File file2 = new File(srcDir, args[i]);
            if (!file2.exists()) {
                System.out.println("Source file does not exist: " + file2);
                return;
            }
            sourceFiles.add(file2);
            ++i;
        }
        if (!dstDir.exists() && !dstDir.mkdirs()) {
            System.out.println("Destination directory could not be created: " + dstDir);
            return;
        }
        if (!dstDir.isDirectory()) {
            System.out.println("Destination is not a directory: " + dstDir);
            return;
        }
        TZDBZoneRulesCompiler compiler = new TZDBZoneRulesCompiler(version, sourceFiles, dstDir, verbose);
        try {
            compiler.compile();
            System.exit(0);
        }
        catch (Exception ex) {
            System.out.println("Failed: " + ex.toString());
            ex.printStackTrace();
            System.exit(1);
        }
    }

    private static void outputHelp() {
        System.out.println("Usage: TZDBZoneRulesCompiler <options> <source files>");
        System.out.println("where options include:");
        System.out.println("   -version <version>      Specify the version name, such as 2009a (required)");
        System.out.println("   -srcdir <directory>     Specify where to find TZDB source files");
        System.out.println("   -dstdir <directory>     Specify where to output the generated file");
        System.out.println("   -help                   Print this usage message");
        System.out.println("   -verbose                Output verbose information during compilation");
    }

    public TZDBZoneRulesCompiler(String version, List<File> sourceFiles, File destinationDir, boolean verbose) {
        this.version = version;
        this.sourceFiles = sourceFiles;
        this.destinationDir = destinationDir;
        this.verbose = verbose;
    }

    public void compile() throws Exception {
        this.printVerbose("Compiling TZDB version " + this.version + " to directory " + this.destinationDir);
        this.parseFiles();
        this.buildZoneRules();
        this.outputFile();
        this.printVerbose("Compiled TZDB version " + this.version + " to directory " + this.destinationDir);
    }

    private void parseFiles() throws Exception {
        for (File file : this.sourceFiles) {
            this.printVerbose("Parsing file: " + file);
            this.parseFile(file);
        }
    }

    private void parseFile(File file) throws Exception {
        String line;
        BufferedReader in = new BufferedReader(new FileReader(file));
        ArrayList<TZDBZone> openZone = null;
        while ((line = in.readLine()) != null) {
            int index = line.indexOf(35);
            if (index >= 0) {
                line = line.substring(0, index);
            }
            if (line.trim().length() == 0) continue;
            StringTokenizer st = new StringTokenizer(line, " \t");
            if (openZone != null && Character.isWhitespace(line.charAt(0)) && st.hasMoreTokens()) {
                if (!this.parseZoneLine(st, openZone)) continue;
                openZone = null;
                continue;
            }
            if (!st.hasMoreTokens()) continue;
            String first = st.nextToken();
            if (first.equals("Zone")) {
                if (st.countTokens() < 3) {
                    this.printVerbose("Invalid Zone line in file: " + file + ", line: " + line);
                    throw new IllegalArgumentException("Invalid Zone line in file: " + file);
                }
                openZone = new ArrayList<TZDBZone>();
                this.zones.put(st.nextToken(), openZone);
                if (!this.parseZoneLine(st, openZone)) continue;
                openZone = null;
                continue;
            }
            openZone = null;
            if (first.equals("Rule")) {
                if (st.countTokens() < 9) {
                    this.printVerbose("Invalid Rule line in file: " + file + ", line: " + line);
                    throw new IllegalArgumentException("Invalid Rule line in file: " + file);
                }
                this.parseRuleLine(st);
                continue;
            }
            if (first.equals("Link")) {
                if (st.countTokens() < 2) {
                    this.printVerbose("Invalid Link line in file: " + file + ", line: " + line);
                    throw new IllegalArgumentException("Invalid Link line in file: " + file);
                }
                this.links.put(st.nextToken(), st.nextToken());
                continue;
            }
            System.out.println("Unknown line: " + line);
        }
        in.close();
    }

    private void parseRuleLine(StringTokenizer st) {
        TZDBRule rule = new TZDBRule();
        String name = st.nextToken();
        if (!this.rules.containsKey(name)) {
            this.rules.put(name, new ArrayList());
        }
        this.rules.get(name).add(rule);
        rule.startYear = this.parseYear(st.nextToken(), 0);
        rule.endYear = this.parseYear(st.nextToken(), rule.startYear);
        if (rule.startYear > rule.endYear) {
            throw new IllegalArgumentException("Year order invalid: " + rule.startYear + " > " + rule.endYear);
        }
        this.parseOptional(st.nextToken());
        this.parseMonthDayTime(st, rule);
        rule.savingsAmount = this.parsePeriod(st.nextToken());
        rule.text = this.parseOptional(st.nextToken());
    }

    private boolean parseZoneLine(StringTokenizer st, List<TZDBZone> zoneList) {
        TZDBZone zone = new TZDBZone();
        zoneList.add(zone);
        zone.standardOffset = this.parseOffset(st.nextToken());
        String savingsRule = this.parseOptional(st.nextToken());
        if (savingsRule == null) {
            zone.fixedSavings = Period.ZERO;
            zone.savingsRule = null;
        } else {
            try {
                zone.fixedSavings = this.parsePeriod(savingsRule);
                zone.savingsRule = null;
            }
            catch (Exception ex) {
                zone.fixedSavings = null;
                zone.savingsRule = savingsRule;
            }
        }
        zone.text = st.nextToken();
        if (st.hasMoreTokens()) {
            zone.year = Year.of(Integer.parseInt(st.nextToken()));
            if (st.hasMoreTokens()) {
                this.parseMonthDayTime(st, zone);
            }
            return false;
        }
        return true;
    }

    private void parseMonthDayTime(StringTokenizer st, TZDBMonthDayTime mdt) {
        mdt.month = this.parseMonth(st.nextToken());
        if (st.hasMoreTokens()) {
            String dayRule = st.nextToken();
            if (dayRule.startsWith("last")) {
                mdt.dayOfMonth = -1;
                mdt.dayOfWeek = this.parseDayOfWeek(dayRule.substring(4));
                mdt.adjustForwards = false;
            } else {
                int index = dayRule.indexOf(">=");
                if (index > 0) {
                    mdt.dayOfWeek = this.parseDayOfWeek(dayRule.substring(0, index));
                    dayRule = dayRule.substring(index + 2);
                } else {
                    index = dayRule.indexOf("<=");
                    if (index > 0) {
                        mdt.dayOfWeek = this.parseDayOfWeek(dayRule.substring(0, index));
                        mdt.adjustForwards = false;
                        dayRule = dayRule.substring(index + 2);
                    }
                }
                mdt.dayOfMonth = Integer.parseInt(dayRule);
            }
            if (st.hasMoreTokens()) {
                String time = st.nextToken();
                mdt.time = this.parseTime(time);
                mdt.timeDefinition = this.parseTimeDefinition(time.charAt(time.length() - 1));
            }
        }
    }

    private int parseYear(String str, int defaultYear) {
        if ((str = str.toLowerCase()).equals("minimum") || str.equals("min")) {
            return -2147483646;
        }
        if (str.equals("maximum") || str.equals("max")) {
            return Integer.MAX_VALUE;
        }
        if (str.equals("only")) {
            return defaultYear;
        }
        return Integer.parseInt(str);
    }

    private MonthOfYear parseMonth(String str) {
        int index = "JanFebMarAprMayJunJulAugSepOctNovDec".indexOf(str);
        if (index == -1) {
            throw new IllegalArgumentException("Unknown month: " + str);
        }
        int month = index / 3 + 1;
        return MonthOfYear.of(month);
    }

    private DayOfWeek parseDayOfWeek(String str) {
        int index = "MonTueWedThuFriSatSun".indexOf(str);
        if (index == -1) {
            throw new IllegalArgumentException("Unknown day-of-week: " + str);
        }
        int dow = index / 3 + 1;
        return DayOfWeek.of(dow);
    }

    private String parseOptional(String str) {
        return str.equals("-") ? null : str;
    }

    private LocalTime parseTime(String str) {
        DateTimeFormatter f = new DateTimeFormatterBuilder().appendValue(ISOChronology.hourOfDayRule()).optionalStart().appendLiteral(':').appendValue(ISOChronology.minuteOfHourRule(), 2).optionalStart().appendLiteral(':').appendValue(ISOChronology.secondOfMinuteRule(), 2).toFormatter();
        ParsePosition pp = new ParsePosition(0);
        DateTimeParseContext cal = f.parse(str, pp);
        if (pp.getErrorIndex() >= 0) {
            throw new IllegalArgumentException(str);
        }
        return this.deduplicate(cal.toCalendricalMerger().merge().get(LocalTime.rule()));
    }

    private int parseSecs(String str) {
        DateTimeFormatter f = new DateTimeFormatterBuilder().appendValue(ISOChronology.hourOfDayRule()).optionalStart().appendLiteral(':').appendValue(ISOChronology.minuteOfHourRule(), 2).optionalStart().appendLiteral(':').appendValue(ISOChronology.secondOfMinuteRule(), 2).toFormatter();
        int pos = 0;
        if (str.startsWith("-")) {
            pos = 1;
        }
        ParsePosition pp = new ParsePosition(pos);
        DateTimeParseContext cal = f.parse(str, pp);
        if (pp.getErrorIndex() >= 0) {
            throw new IllegalArgumentException(str);
        }
        LocalTime time = cal.toCalendricalMerger().merge().get(LocalTime.rule());
        int secs = time.getHourOfDay() * 60 * 60 + time.getMinuteOfHour() * 60 + time.getSecondOfMinute();
        if (pos == 1) {
            secs = -secs;
        }
        return secs;
    }

    private ZoneOffset parseOffset(String str) {
        int secs = this.parseSecs(str);
        return ZoneOffset.fromTotalSeconds(secs);
    }

    private Period parsePeriod(String str) {
        int secs = this.parseSecs(str);
        return this.deduplicate(Period.seconds(secs).normalized());
    }

    private ZoneRulesBuilder.TimeDefinition parseTimeDefinition(char c) {
        switch (c) {
            case 'S': 
            case 's': {
                return ZoneRulesBuilder.TimeDefinition.STANDARD;
            }
            case 'G': 
            case 'U': 
            case 'Z': 
            case 'g': 
            case 'u': 
            case 'z': {
                return ZoneRulesBuilder.TimeDefinition.UTC;
            }
        }
        return ZoneRulesBuilder.TimeDefinition.WALL;
    }

    private void buildZoneRules() throws Exception {
        for (String zoneId : this.zones.keySet()) {
            this.printVerbose("Building zone " + zoneId);
            List<TZDBZone> tzdbZones = this.zones.get(zoneId);
            ZoneRulesBuilder bld = new ZoneRulesBuilder();
            for (TZDBZone tzdbZone : tzdbZones) {
                bld = tzdbZone.addToBuilder(bld, this.rules);
            }
            this.builtZones.put(zoneId, bld.toRules(zoneId, this.deduplicateMap));
        }
    }

    private void outputFile() throws Exception {
        File outputJar = new File(this.destinationDir, "ZoneRuleInfo-TZDB-" + this.version + ".jar");
        this.printVerbose("Outputting file: " + outputJar);
        JarOutputStream jos = new JarOutputStream(new FileOutputStream(outputJar));
        jos.putNextEntry(new ZipEntry("javax/time/calendar/zone/ZoneRuleInfo.dat"));
        ObjectOutputStream out = new ObjectOutputStream(jos);
        out.writeInt(1);
        out.writeUTF("TZDB");
        out.writeUTF(this.version);
        out.writeObject(this.builtZones);
        jos.closeEntry();
        out.close();
    }

    <T> T deduplicate(T object) {
        if (!this.deduplicateMap.containsKey(object)) {
            this.deduplicateMap.put(object, object);
        }
        return (T)this.deduplicateMap.get(object);
    }

    private void printVerbose(String message) {
        if (this.verbose) {
            System.out.println(message);
        }
    }

    private final class TZDBZone
    extends TZDBMonthDayTime {
        ZoneOffset standardOffset;
        Period fixedSavings;
        String savingsRule;
        String text;
        Year year;

        private TZDBZone() {
        }

        ZoneRulesBuilder addToBuilder(ZoneRulesBuilder bld, Map<String, List<TZDBRule>> rules) {
            if (this.year != null) {
                bld.addWindow(this.standardOffset, this.toDateTime(this.year.getValue()), this.timeDefinition);
            } else {
                bld.addWindowForever(this.standardOffset);
            }
            if (this.fixedSavings != null) {
                bld.setFixedSavingsToWindow(this.fixedSavings);
            } else {
                List<TZDBRule> tzdbRules = rules.get(this.savingsRule);
                if (tzdbRules == null) {
                    throw new IllegalArgumentException("Rule not found: " + this.savingsRule);
                }
                for (TZDBRule tzdbRule : tzdbRules) {
                    tzdbRule.addToBuilder(bld);
                }
            }
            return bld;
        }
    }

    private final class TZDBRule
    extends TZDBMonthDayTime {
        int startYear;
        int endYear;
        Period savingsAmount;
        String text;

        private TZDBRule() {
        }

        void addToBuilder(ZoneRulesBuilder bld) {
            this.adjustToFowards(2001);
            bld.addRuleToWindow(this.startYear, this.endYear, this.month, this.dayOfMonth, this.dayOfWeek, this.time, this.timeDefinition, this.savingsAmount);
        }
    }

    private abstract class TZDBMonthDayTime {
        MonthOfYear month = MonthOfYear.JANUARY;
        int dayOfMonth = 1;
        boolean adjustForwards = true;
        DayOfWeek dayOfWeek;
        LocalTime time = LocalTime.MIDNIGHT;
        ZoneRulesBuilder.TimeDefinition timeDefinition = ZoneRulesBuilder.TimeDefinition.WALL;

        private TZDBMonthDayTime() {
        }

        LocalDateTime toDateTime(int year) {
            LocalDate date;
            this.adjustToFowards(year);
            if (this.dayOfMonth == -1) {
                this.dayOfMonth = this.month.getLastDayOfMonth(ISOChronology.isLeapYear(year));
                date = LocalDate.of(year, this.month, this.dayOfMonth);
                if (this.dayOfWeek != null) {
                    date = date.with(DateAdjusters.previousOrCurrent(this.dayOfWeek));
                }
            } else {
                date = LocalDate.of(year, this.month, this.dayOfMonth);
                if (this.dayOfWeek != null) {
                    date = date.with(DateAdjusters.nextOrCurrent(this.dayOfWeek));
                }
            }
            date = TZDBZoneRulesCompiler.this.deduplicate(date);
            return LocalDateTime.from(date, this.time);
        }

        void adjustToFowards(int year) {
            if (!this.adjustForwards && this.dayOfMonth > 0) {
                LocalDate adjustedDate = LocalDate.of(year, this.month, this.dayOfMonth).minusDays(6L);
                this.dayOfMonth = adjustedDate.getDayOfMonth();
                this.month = adjustedDate.getMonthOfYear();
                this.adjustForwards = true;
            }
        }
    }
}

