/*
 * Decompiled with CFR 0.152.
 */
package javax.time.i18n;

import java.io.Serializable;
import javax.time.Duration;
import javax.time.calendar.Calendrical;
import javax.time.calendar.CalendricalMerger;
import javax.time.calendar.Chronology;
import javax.time.calendar.DateTimeFieldRule;
import javax.time.calendar.DayOfWeek;
import javax.time.calendar.ISOChronology;
import javax.time.calendar.LocalDate;
import javax.time.calendar.PeriodUnit;
import javax.time.i18n.CopticDate;

public final class CopticChronology
extends Chronology
implements Serializable {
    public static final CopticChronology INSTANCE = new CopticChronology();
    private static final long serialVersionUID = 24275872L;
    private static final PeriodUnit YEARS = new Years();
    private static final PeriodUnit MONTHS = new Months();

    private CopticChronology() {
    }

    private Object readResolve() {
        return INSTANCE;
    }

    public static boolean isLeapYear(int year) {
        return year % 4 == 3;
    }

    @Override
    public String getName() {
        return "Coptic";
    }

    public static DateTimeFieldRule<Integer> yearRule() {
        return YearRule.INSTANCE;
    }

    public static DateTimeFieldRule<Integer> monthOfYearRule() {
        return MonthOfYearRule.INSTANCE;
    }

    public static DateTimeFieldRule<Integer> dayOfMonthRule() {
        return DayOfMonthRule.INSTANCE;
    }

    public static DateTimeFieldRule<Integer> dayOfYearRule() {
        return DayOfYearRule.INSTANCE;
    }

    public static DateTimeFieldRule<DayOfWeek> dayOfWeekRule() {
        return DayOfWeekRule.INSTANCE;
    }

    public static PeriodUnit periodYears() {
        return YEARS;
    }

    public static PeriodUnit periodMonths() {
        return MONTHS;
    }

    public static PeriodUnit periodWeeks() {
        return ISOChronology.periodWeeks();
    }

    public static PeriodUnit periodDays() {
        return ISOChronology.periodDays();
    }

    private static final class Months
    extends PeriodUnit {
        private static final long serialVersionUID = 1L;

        private Months() {
            super("CopticMonths", Duration.standardHours(708L));
        }

        private Object readResolve() {
            return MONTHS;
        }
    }

    private static final class Years
    extends PeriodUnit {
        private static final long serialVersionUID = 1L;

        private Years() {
            super("CopticYears", Duration.seconds(31557600L));
        }

        private Object readResolve() {
            return YEARS;
        }
    }

    private static final class DayOfWeekRule
    extends DateTimeFieldRule<DayOfWeek>
    implements Serializable {
        private static final DateTimeFieldRule<DayOfWeek> INSTANCE = new DayOfWeekRule();
        private static final long serialVersionUID = 1L;

        private DayOfWeekRule() {
            super(DayOfWeek.class, INSTANCE, "DayOfWeek", CopticChronology.periodDays(), CopticChronology.periodWeeks(), 1, 7);
        }

        private Object readResolve() {
            return INSTANCE;
        }

        @Override
        protected DayOfWeek derive(Calendrical calendrical) {
            CopticDate cd = calendrical.get(CopticDate.rule());
            return cd != null ? cd.getDayOfWeek() : null;
        }
    }

    private static final class DayOfYearRule
    extends DateTimeFieldRule<Integer>
    implements Serializable {
        private static final DateTimeFieldRule<Integer> INSTANCE = new DayOfYearRule();
        private static final long serialVersionUID = 1L;

        private DayOfYearRule() {
            super(Integer.class, INSTANCE, "DayOfYear", CopticChronology.periodDays(), YEARS, 1, 366);
        }

        private Object readResolve() {
            return INSTANCE;
        }

        @Override
        public int getSmallestMaximumValue() {
            return 365;
        }

        @Override
        public int getMaximumValue(Calendrical calendrical) {
            Integer year = calendrical.get(CopticChronology.yearRule());
            if (year != null) {
                return CopticChronology.isLeapYear(year) ? 366 : 365;
            }
            return this.getMaximumValue();
        }

        @Override
        protected Integer derive(Calendrical calendrical) {
            CopticDate cd = calendrical.get(CopticDate.rule());
            return cd != null ? Integer.valueOf(cd.getDayOfYear()) : null;
        }

        @Override
        protected void merge(CalendricalMerger merger) {
            Integer yearVal = merger.getValue(CopticChronology.yearRule());
            if (yearVal != null) {
                int doy = merger.getValue(this);
                CopticDate date = merger.getContext().isStrict() ? CopticDate.of(yearVal, 1, 1).withDayOfYear(doy) : CopticDate.of(yearVal, 1, 1).plusDays(doy).plusDays(-1);
                merger.storeMerged(LocalDate.rule(), date.toLocalDate());
                merger.removeProcessed(this);
                merger.removeProcessed(CopticChronology.yearRule());
            }
        }
    }

    private static final class DayOfMonthRule
    extends DateTimeFieldRule<Integer>
    implements Serializable {
        private static final DateTimeFieldRule<Integer> INSTANCE = new DayOfMonthRule();
        private static final long serialVersionUID = 1L;

        private DayOfMonthRule() {
            super(Integer.class, INSTANCE, "DayOfMonth", CopticChronology.periodDays(), MONTHS, 1, 30);
        }

        private Object readResolve() {
            return INSTANCE;
        }

        @Override
        public int getSmallestMaximumValue() {
            return 5;
        }

        @Override
        public int getMaximumValue(Calendrical calendrical) {
            Integer year = calendrical.get(CopticChronology.yearRule());
            Integer moy = calendrical.get(CopticChronology.monthOfYearRule());
            if (year != null && moy != null) {
                if (moy == 13) {
                    return CopticChronology.isLeapYear(year) ? 6 : 5;
                }
                return 30;
            }
            return this.getMaximumValue();
        }

        @Override
        protected Integer derive(Calendrical calendrical) {
            CopticDate cd = calendrical.get(CopticDate.rule());
            return cd != null ? Integer.valueOf(cd.getDayOfMonth()) : null;
        }
    }

    private static final class MonthOfYearRule
    extends DateTimeFieldRule<Integer>
    implements Serializable {
        private static final DateTimeFieldRule<Integer> INSTANCE = new MonthOfYearRule();
        private static final long serialVersionUID = 1L;

        private MonthOfYearRule() {
            super(Integer.class, INSTANCE, "MonthOfYear", MONTHS, YEARS, 1, 13);
        }

        private Object readResolve() {
            return INSTANCE;
        }

        @Override
        protected Integer derive(Calendrical calendrical) {
            CopticDate cd = calendrical.get(CopticDate.rule());
            return cd != null ? Integer.valueOf(cd.getMonthOfYear()) : null;
        }
    }

    private static final class YearRule
    extends DateTimeFieldRule<Integer>
    implements Serializable {
        private static final DateTimeFieldRule<Integer> INSTANCE = new YearRule();
        private static final long serialVersionUID = 1L;

        private YearRule() {
            super(Integer.class, INSTANCE, "Year", YEARS, null, 1, 9999);
        }

        private Object readResolve() {
            return INSTANCE;
        }

        @Override
        protected Integer derive(Calendrical calendrical) {
            CopticDate cd = calendrical.get(CopticDate.rule());
            return cd != null ? Integer.valueOf(cd.getYear()) : null;
        }

        @Override
        protected void merge(CalendricalMerger merger) {
            Integer moyVal = merger.getValue(CopticChronology.monthOfYearRule());
            Integer domVal = merger.getValue(CopticChronology.dayOfMonthRule());
            if (moyVal != null && domVal != null) {
                int year = merger.getValue(this);
                CopticDate date = merger.getContext().isStrict() ? CopticDate.of(year, moyVal, domVal) : CopticDate.of(year, 1, 1).plusMonths(moyVal).plusMonths(-1).plusDays(domVal).plusDays(-1);
                merger.storeMerged(LocalDate.rule(), date.toLocalDate());
                merger.removeProcessed(this);
                merger.removeProcessed(CopticChronology.monthOfYearRule());
                merger.removeProcessed(CopticChronology.dayOfMonthRule());
            }
        }
    }
}

