/*
 * Decompiled with CFR 0.152.
 */
package javax.time.i18n;

import java.io.Serializable;
import javax.time.Duration;
import javax.time.calendar.Calendrical;
import javax.time.calendar.CalendricalMerger;
import javax.time.calendar.Chronology;
import javax.time.calendar.DateTimeFieldRule;
import javax.time.calendar.DayOfWeek;
import javax.time.calendar.ISOChronology;
import javax.time.calendar.InvalidCalendarFieldException;
import javax.time.calendar.LocalDate;
import javax.time.calendar.MonthOfYear;
import javax.time.calendar.PeriodUnit;
import javax.time.i18n.HistoricDate;
import javax.time.i18n.HistoricEra;
import javax.time.i18n.JulianChronology;

public final class HistoricChronology
extends Chronology
implements Serializable {
    private static final long serialVersionUID = 24275872L;
    private static final int[] STANDARD_MONTH_START = new int[]{0, 31, 59, 90, 120, 151, 181, 212, 243, 273, 304, 334};
    private static final int[] LEAP_MONTH_START = new int[]{0, 31, 60, 91, 121, 152, 182, 213, 244, 274, 305, 335};
    private final LocalDate cutover;
    private static final PeriodUnit YEARS = new Years();
    private static final PeriodUnit MONTHS = new Months();

    public static HistoricChronology cutoverAt(LocalDate cutover) {
        HistoricChronology.checkNotNull(cutover, "Cutover date must not be null");
        return new HistoricChronology(cutover);
    }

    public static HistoricChronology standardCutover() {
        return new HistoricChronology(HistoricDate.STANDARD_CUTOVER);
    }

    private HistoricChronology(LocalDate cutover) {
        this.cutover = cutover;
    }

    static void checkNotNull(Object object, String errorMessage) {
        if (object == null) {
            throw new NullPointerException(errorMessage);
        }
    }

    int getDayOfYear(HistoricDate date) {
        int moy0 = date.getMonthOfYear().ordinal();
        int dom = date.getDayOfMonth();
        if (this.isLeapYear(date.getYear())) {
            return LEAP_MONTH_START[moy0] + dom;
        }
        return STANDARD_MONTH_START[moy0] + dom;
    }

    HistoricDate getDateFromDayOfYear(int year, int dayOfYear) {
        int month;
        boolean leap = this.isLeapYear(year);
        if (dayOfYear == 366 && !leap) {
            throw new InvalidCalendarFieldException("DayOfYear 366 is invalid for year " + year, this.dayOfYearRule());
        }
        int doy0 = dayOfYear - 1;
        int[] array = leap ? LEAP_MONTH_START : STANDARD_MONTH_START;
        for (month = 1; month < 12 && doy0 >= array[month]; ++month) {
        }
        MonthOfYear moy = MonthOfYear.of(month);
        int dom = dayOfYear - array[month - 1];
        return new HistoricDate(this, year, moy, dom);
    }

    public boolean isLeapYear(int year) {
        if (year < this.cutover.getYear()) {
            return JulianChronology.isLeapYear(year);
        }
        if (year > this.cutover.getYear()) {
            return ISOChronology.isLeapYear(year);
        }
        if (this.cutover.getMonthOfYear().compareTo(MonthOfYear.FEBRUARY) < 0) {
            return false;
        }
        return false;
    }

    public LocalDate getCutover() {
        return this.cutover;
    }

    @Override
    public String getName() {
        return "Historic " + this.cutover;
    }

    public DateTimeFieldRule<HistoricEra> eraRule() {
        return new EraRule(this);
    }

    public DateTimeFieldRule<Integer> yearOfEraRule() {
        return new YearRule(this);
    }

    public DateTimeFieldRule<Integer> yearRule() {
        return new YearRule(this);
    }

    public DateTimeFieldRule<MonthOfYear> monthOfYearRule() {
        return new MonthOfYearRule(this);
    }

    public DateTimeFieldRule<Integer> dayOfMonthRule() {
        return new DayOfMonthRule(this);
    }

    public DateTimeFieldRule<Integer> dayOfYearRule() {
        return new DayOfYearRule(this);
    }

    public DateTimeFieldRule<DayOfWeek> dayOfWeekRule() {
        return new DayOfWeekRule(this);
    }

    public static PeriodUnit periodEras() {
        return ISOChronology.periodEras();
    }

    public static PeriodUnit periodYears() {
        return YEARS;
    }

    public static PeriodUnit periodMonths() {
        return MONTHS;
    }

    public static PeriodUnit periodWeeks() {
        return ISOChronology.periodWeeks();
    }

    public static PeriodUnit periodDays() {
        return ISOChronology.periodDays();
    }

    private static final class Months
    extends PeriodUnit {
        private static final long serialVersionUID = 1L;

        private Months() {
            super("JulianMonths", Duration.standardHours(2629800L));
        }

        private Object readResolve() {
            return MONTHS;
        }
    }

    private static final class Years
    extends PeriodUnit {
        private static final long serialVersionUID = 1L;

        private Years() {
            super("JulianYears", Duration.seconds(31557600L));
        }

        private Object readResolve() {
            return YEARS;
        }
    }

    private static final class DayOfWeekRule
    extends DateTimeFieldRule<DayOfWeek>
    implements Serializable {
        private final HistoricChronology chrono;
        private static final long serialVersionUID = 1L;

        private DayOfWeekRule(HistoricChronology chrono) {
            super(DayOfWeek.class, chrono, "DayOfWeek", HistoricChronology.periodDays(), HistoricChronology.periodWeeks(), 1, 7);
            this.chrono = chrono;
        }

        @Override
        protected DayOfWeek derive(Calendrical calendrical) {
            HistoricDate cd = calendrical.get(HistoricDate.rule());
            return cd != null ? cd.getDayOfWeek() : null;
        }
    }

    private static final class DayOfYearRule
    extends DateTimeFieldRule<Integer>
    implements Serializable {
        private final HistoricChronology chrono;
        private static final long serialVersionUID = 1L;

        private DayOfYearRule(HistoricChronology chrono) {
            super(Integer.class, chrono, "DayOfYear", HistoricChronology.periodDays(), YEARS, 1, 366);
            this.chrono = chrono;
        }

        @Override
        public int getSmallestMaximumValue() {
            return 365;
        }

        @Override
        public int getMaximumValue(Calendrical calendrical) {
            Integer year = calendrical.get(this.chrono.yearRule());
            if (year != null) {
                return this.chrono.isLeapYear(year) ? 366 : 365;
            }
            return this.getMaximumValue();
        }

        @Override
        protected Integer derive(Calendrical calendrical) {
            HistoricDate cd = calendrical.get(HistoricDate.rule());
            return cd != null ? Integer.valueOf(cd.getDayOfYear()) : null;
        }

        @Override
        protected void merge(CalendricalMerger merger) {
            Integer yearVal = merger.getValue(this.chrono.yearRule());
            if (yearVal != null) {
                int doy = merger.getValue(this);
                HistoricDate date = merger.getContext().isStrict() ? HistoricDate.of(yearVal, MonthOfYear.JANUARY, 1).withDayOfYear(doy) : HistoricDate.of(yearVal, MonthOfYear.JANUARY, 1).plusDays(doy).plusDays(-1);
                merger.storeMerged(LocalDate.rule(), date.toLocalDate());
                merger.removeProcessed(this);
                merger.removeProcessed(this.chrono.yearRule());
            }
        }
    }

    private static final class DayOfMonthRule
    extends DateTimeFieldRule<Integer>
    implements Serializable {
        private final HistoricChronology chrono;
        private static final long serialVersionUID = 1L;

        private DayOfMonthRule(HistoricChronology chrono) {
            super(Integer.class, chrono, "DayOfMonth", HistoricChronology.periodDays(), MONTHS, 1, 30);
            this.chrono = chrono;
        }

        @Override
        public int getSmallestMaximumValue() {
            return 28;
        }

        @Override
        public int getMaximumValue(Calendrical calendrical) {
            Integer year = calendrical.get(this.chrono.yearRule());
            MonthOfYear moy = calendrical.get(this.chrono.monthOfYearRule());
            if (moy != null) {
                if (year != null) {
                    return moy.lengthInDays(this.chrono.isLeapYear(year));
                }
                return moy.maxLengthInDays();
            }
            return this.getMaximumValue();
        }

        @Override
        protected Integer derive(Calendrical calendrical) {
            HistoricDate cd = calendrical.get(HistoricDate.rule());
            return cd != null ? Integer.valueOf(cd.getDayOfMonth()) : null;
        }
    }

    private static final class MonthOfYearRule
    extends DateTimeFieldRule<MonthOfYear>
    implements Serializable {
        private final HistoricChronology chrono;
        private static final long serialVersionUID = 1L;

        private MonthOfYearRule(HistoricChronology chrono) {
            super(MonthOfYear.class, chrono, "MonthOfYear", MONTHS, YEARS, 1, 13);
            this.chrono = chrono;
        }

        @Override
        protected MonthOfYear derive(Calendrical calendrical) {
            HistoricDate cd = calendrical.get(HistoricDate.rule());
            return cd != null ? cd.getMonthOfYear() : null;
        }
    }

    private static final class YearRule
    extends DateTimeFieldRule<Integer>
    implements Serializable {
        private final HistoricChronology chrono;
        private static final long serialVersionUID = 1L;

        private YearRule(HistoricChronology chrono) {
            super(Integer.class, chrono, "Year", YEARS, null, -999999998, 999999999);
            this.chrono = chrono;
        }

        @Override
        protected Integer derive(Calendrical calendrical) {
            HistoricDate cd = calendrical.get(HistoricDate.rule());
            return cd != null ? Integer.valueOf(cd.getYear()) : null;
        }

        @Override
        protected void merge(CalendricalMerger merger) {
            MonthOfYear moy = merger.getValue(this.chrono.monthOfYearRule());
            Integer domVal = merger.getValue(this.chrono.dayOfMonthRule());
            if (moy != null && domVal != null) {
                int year = merger.getValue(this);
                HistoricDate date = merger.getContext().isStrict() ? HistoricDate.of(year, moy, domVal) : HistoricDate.of(year, MonthOfYear.JANUARY, 1).plusMonths(moy.getValue() - 1).plusMonths(-1).plusDays(domVal).plusDays(-1);
                merger.storeMerged(LocalDate.rule(), date.toLocalDate());
                merger.removeProcessed(this);
                merger.removeProcessed(this.chrono.monthOfYearRule());
                merger.removeProcessed(this.chrono.dayOfMonthRule());
            }
        }
    }

    private static final class EraRule
    extends DateTimeFieldRule<HistoricEra>
    implements Serializable {
        private final HistoricChronology chrono;
        private static final long serialVersionUID = 1L;

        private EraRule(HistoricChronology chrono) {
            super(HistoricEra.class, chrono, "Era", HistoricChronology.periodEras(), null, 0, 1);
            this.chrono = chrono;
        }

        @Override
        protected HistoricEra derive(Calendrical calendrical) {
            HistoricDate cd = calendrical.get(HistoricDate.rule());
            return cd != null ? cd.getEra() : null;
        }
    }
}

