/*
 * Decompiled with CFR 0.152.
 */
package javax.time.i18n;

import java.io.Serializable;
import javax.time.calendar.Calendrical;
import javax.time.calendar.CalendricalMerger;
import javax.time.calendar.CalendricalRule;
import javax.time.calendar.DateProvider;
import javax.time.calendar.DayOfWeek;
import javax.time.calendar.LocalDate;
import javax.time.calendar.MonthOfYear;
import javax.time.i18n.HistoricChronology;
import javax.time.i18n.HistoricEra;

public final class HistoricDate
implements DateProvider,
Calendrical,
Comparable<HistoricDate>,
Serializable {
    public static final LocalDate STANDARD_CUTOVER = LocalDate.of(1582, 10, 15);
    public static final int MAX_YEAR = 999999999;
    private static final long serialVersionUID = 1L;
    private final HistoricChronology chrono;
    private final transient int year;
    private final transient MonthOfYear month;
    private final transient int day;

    public static HistoricDate of(int historicYear, MonthOfYear monthOfYear, int dayOfMonth) {
        return HistoricDate.of(STANDARD_CUTOVER, historicYear, monthOfYear, dayOfMonth);
    }

    public static HistoricDate of(LocalDate cutover, int historicYear, MonthOfYear monthOfYear, int dayOfMonth) {
        HistoricChronology.checkNotNull(cutover, "Cutover date must not be null");
        HistoricChronology chrono = HistoricChronology.cutoverAt(cutover);
        chrono.yearRule().checkValue(historicYear);
        HistoricChronology.checkNotNull((Object)monthOfYear, "MonthOfYear must not be null");
        chrono.dayOfMonthRule().checkValue(dayOfMonth);
        return new HistoricDate(chrono, historicYear, monthOfYear, dayOfMonth);
    }

    public static HistoricDate from(Calendrical calendrical) {
        return HistoricDate.rule().getValueChecked(calendrical);
    }

    HistoricDate(HistoricChronology chrono, int year, MonthOfYear month, int day) {
        this.chrono = chrono;
        this.year = year;
        this.month = month;
        this.day = day;
    }

    private HistoricDate previousValid(int historicYear, MonthOfYear monthOfYear, int dayOfMonth) {
        this.chrono.yearRule().checkValue(historicYear);
        HistoricChronology.checkNotNull((Object)monthOfYear, "MonthOfYear must not be null");
        this.chrono.dayOfMonthRule().checkValue(dayOfMonth);
        int lastDay = monthOfYear.getLastDayOfMonth(this.chrono.isLeapYear(this.year));
        if (dayOfMonth > lastDay) {
            dayOfMonth = lastDay;
        }
        return new HistoricDate(this.chrono, this.year, monthOfYear, dayOfMonth);
    }

    public HistoricChronology getChronology() {
        return this.chrono;
    }

    @Override
    public <T> T get(CalendricalRule<T> rule) {
        if (rule.equals(LocalDate.rule())) {
            return rule.reify(this.toLocalDate());
        }
        return HistoricDate.rule().deriveValueFor(rule, this, this);
    }

    public HistoricEra getEra() {
        return this.year < 1 ? HistoricEra.BCE : HistoricEra.CE;
    }

    public int getYearOfEra() {
        return this.year < 1 ? -(this.year - 1) : this.year;
    }

    public int getYear() {
        return this.year;
    }

    public MonthOfYear getMonthOfYear() {
        return this.month;
    }

    public int getDayOfMonth() {
        return this.day;
    }

    public int getDayOfYear() {
        return this.chrono.getDayOfYear(this);
    }

    public DayOfWeek getDayOfWeek() {
        return this.toLocalDate().getDayOfWeek();
    }

    public boolean isLeapYear() {
        return this.chrono.isLeapYear(this.getYear());
    }

    public boolean isLeapDay() {
        return this.getMonthOfYear().isFebruary() && this.getDayOfMonth() == 29;
    }

    public HistoricDate withYear(int historicYear) {
        return this.previousValid(historicYear, this.getMonthOfYear(), this.getDayOfMonth());
    }

    public HistoricDate withMonthOfYear(MonthOfYear monthOfYear) {
        return this.previousValid(this.getYear(), monthOfYear, this.getDayOfMonth());
    }

    public HistoricDate withDayOfMonth(int dayOfMonth) {
        return HistoricDate.of(this.getYear(), this.getMonthOfYear(), dayOfMonth);
    }

    public HistoricDate withDayOfYear(int dayOfYear) {
        this.chrono.dayOfYearRule().checkValue(dayOfYear);
        return this.chrono.getDateFromDayOfYear(this.year, dayOfYear);
    }

    public HistoricDate plusYears(int years) {
        int newYear = this.getYear() + years;
        return this.previousValid(newYear, this.month, this.day);
    }

    public HistoricDate plusMonths(int months) {
        int month0 = months % 12 + 12 + this.getMonthOfYear().ordinal();
        int years = months / 12 - 1 + month0 / 12;
        int newYear = this.getYear() + years;
        return this.previousValid(newYear, MonthOfYear.of((month0 %= 12) + 1), this.day);
    }

    public HistoricDate plusDays(int days) {
        return HistoricDate.from(this.toLocalDate().plusDays(days));
    }

    @Override
    public LocalDate toLocalDate() {
        LocalDate possible = LocalDate.of(this.year, this.month, this.day);
        if (possible.isBefore(this.chrono.getCutover())) {
            long julYear1Days = (this.year - 1) * 365 + this.year / 4 + this.chrono.getDayOfYear(this) - 1;
            return LocalDate.fromModifiedJulianDays(julYear1Days + 0L);
        }
        return possible;
    }

    @Override
    public int compareTo(HistoricDate otherDate) {
        int cmp = this.toLocalDate().compareTo(otherDate.toLocalDate());
        if (cmp == 0) {
            cmp = this.chrono.getCutover().compareTo(otherDate.chrono.getCutover());
        }
        return cmp;
    }

    public boolean isAfter(HistoricDate otherDate) {
        return this.compareTo(otherDate) > 0;
    }

    public boolean isBefore(HistoricDate otherDate) {
        return this.compareTo(otherDate) < 0;
    }

    public boolean equals(Object otherDate) {
        if (this == otherDate) {
            return true;
        }
        if (otherDate instanceof HistoricDate) {
            HistoricDate other = (HistoricDate)otherDate;
            return this.year == other.year && this.month == other.month && this.day == other.day && this.chrono.getCutover().equals(other.chrono.getCutover());
        }
        return false;
    }

    public int hashCode() {
        int yearValue = this.year;
        int monthValue = this.month.getValue();
        int dayValue = this.day;
        return yearValue & 0xFFFFF800 ^ (yearValue << 11) + (monthValue << 6) + dayValue + this.chrono.getCutover().hashCode();
    }

    public String toString() {
        int yearValue = this.getYear();
        int monthValue = this.getMonthOfYear().getValue();
        int dayValue = this.getDayOfMonth();
        int absYear = Math.abs(yearValue);
        StringBuilder buf = new StringBuilder(12);
        if (absYear < 1000) {
            buf.append(yearValue + 10000).deleteCharAt(0);
        } else {
            buf.append(yearValue);
        }
        return buf.append(monthValue < 10 ? "-0" : "-").append(monthValue).append(dayValue < 10 ? "-0" : "-").append(dayValue).append(" (" + this.chrono.getName() + ")").toString();
    }

    public static CalendricalRule<HistoricDate> rule() {
        return Rule.INSTANCE;
    }

    static final class Rule
    extends CalendricalRule<HistoricDate>
    implements Serializable {
        private static final CalendricalRule<HistoricDate> INSTANCE = new Rule();
        private static final long serialVersionUID = 1L;

        private Rule() {
            super(HistoricDate.class, HistoricChronology.standardCutover(), "HistoricDate", HistoricChronology.periodDays(), null);
        }

        private Object readResolve() {
            return INSTANCE;
        }

        @Override
        protected HistoricDate derive(Calendrical calendrical) {
            LocalDate ld = calendrical.get(LocalDate.rule());
            if (ld == null) {
                return null;
            }
            return null;
        }

        @Override
        protected void merge(CalendricalMerger merger) {
            HistoricDate cd = merger.getValue(this);
            merger.storeMerged(LocalDate.rule(), cd.toLocalDate());
            merger.removeProcessed(this);
        }
    }
}

