/*
 * Decompiled with CFR 0.152.
 */
package javax.time.i18n;

import java.io.Serializable;
import javax.time.Duration;
import javax.time.calendar.Chronology;
import javax.time.calendar.ISOChronology;
import javax.time.calendar.PeriodUnit;

public final class JulianChronology
extends Chronology
implements Serializable {
    public static final JulianChronology INSTANCE = new JulianChronology();
    private static final long serialVersionUID = 1L;
    private static final PeriodUnit YEARS = new Years();
    private static final PeriodUnit MONTHS = new Months();

    private JulianChronology() {
    }

    private Object readResolve() {
        return INSTANCE;
    }

    static void checkNotNull(Object object, String errorMessage) {
        if (object == null) {
            throw new NullPointerException(errorMessage);
        }
    }

    public static boolean isLeapYear(int year) {
        return (year & 3) == 0;
    }

    @Override
    public String getName() {
        return "Julian";
    }

    public static PeriodUnit periodYears() {
        return YEARS;
    }

    public static PeriodUnit periodMonths() {
        return MONTHS;
    }

    public static PeriodUnit periodWeeks() {
        return ISOChronology.periodWeeks();
    }

    public static PeriodUnit periodDays() {
        return ISOChronology.periodDays();
    }

    private static final class Months
    extends PeriodUnit {
        private static final long serialVersionUID = 1L;

        private Months() {
            super("JulianMonths", Duration.standardHours(2629800L));
        }

        private Object readResolve() {
            return MONTHS;
        }
    }

    private static final class Years
    extends PeriodUnit {
        private static final long serialVersionUID = 1L;

        private Years() {
            super("JulianYears", Duration.seconds(31557600L));
        }

        private Object readResolve() {
            return YEARS;
        }
    }
}

