/*
 * Decompiled with CFR 0.152.
 */
package javax.time.period;

import java.io.Serializable;
import java.util.Arrays;
import javax.time.CalendricalException;
import javax.time.Duration;
import javax.time.MathUtils;
import javax.time.calendar.ISOChronology;
import javax.time.calendar.PeriodUnit;
import javax.time.period.PeriodFields;
import javax.time.period.PeriodProvider;

public final class PeriodField
implements PeriodProvider,
Comparable<PeriodField>,
Serializable {
    private static final long serialVersionUID = 1L;
    private final long amount;
    private final PeriodUnit unit;

    public static PeriodField of(long amount, PeriodUnit unit) {
        PeriodFields.checkNotNull(unit, "PeriodUnit must not be null");
        return new PeriodField(amount, unit);
    }

    private PeriodField(long amount, PeriodUnit unit) {
        this.amount = amount;
        this.unit = unit;
    }

    public boolean isZero() {
        return this.amount == 0L;
    }

    public boolean isPositive() {
        return this.amount > 0L;
    }

    public boolean isNegative() {
        return this.amount < 0L;
    }

    public long getAmount() {
        return this.amount;
    }

    public int getAmountInt() {
        return MathUtils.safeToInt(this.amount);
    }

    public PeriodUnit getUnit() {
        return this.unit;
    }

    public PeriodField withAmount(long amount) {
        if (amount == this.amount) {
            return this;
        }
        return new PeriodField(amount, this.unit);
    }

    public PeriodField withRule(PeriodUnit unit) {
        PeriodFields.checkNotNull(unit, "PeriodUnit must not be null");
        if (unit.equals(this.unit)) {
            return this;
        }
        return new PeriodField(this.amount, unit);
    }

    public PeriodField plus(PeriodField period) {
        PeriodFields.checkNotNull(period, "PeriodField must not be null");
        if (!period.getUnit().equals(this.unit)) {
            throw new IllegalArgumentException("Cannot add '" + period + "' to '" + this + "' as the units differ");
        }
        return this.plus(period.getAmount());
    }

    public PeriodField plus(long amount) {
        return this.withAmount(MathUtils.safeAdd(this.amount, amount));
    }

    public PeriodField minus(PeriodField period) {
        PeriodFields.checkNotNull(period, "PeriodField must not be null");
        if (!period.getUnit().equals(this.unit)) {
            throw new IllegalArgumentException("Cannot subtract '" + period + "' from '" + this + "' as the units differ");
        }
        return this.minus(period.getAmount());
    }

    public PeriodField minus(long amount) {
        return this.withAmount(MathUtils.safeSubtract(this.amount, amount));
    }

    public PeriodField multipliedBy(long scalar) {
        return this.withAmount(MathUtils.safeMultiply(this.amount, scalar));
    }

    public PeriodField dividedBy(long divisor) {
        return this.withAmount(this.amount / divisor);
    }

    public PeriodField negated() {
        return this.withAmount(MathUtils.safeNegate(this.amount));
    }

    public PeriodField abs() {
        return this.isNegative() ? this.negated() : this;
    }

    public PeriodField toEquivalentPeriod(PeriodUnit requiredUnit) {
        PeriodField equivalent = this.unit.getEquivalentPeriod(requiredUnit);
        if (equivalent != null) {
            return equivalent.multipliedBy(this.amount);
        }
        throw new CalendricalException("Unable to convert " + this.getUnit() + " to " + requiredUnit);
    }

    public PeriodField toEquivalentPeriod(PeriodUnit ... requiredUnits) {
        for (PeriodUnit requiredUnit : requiredUnits) {
            PeriodField equivalent = this.unit.getEquivalentPeriod(requiredUnit);
            if (equivalent == null) continue;
            return equivalent.multipliedBy(this.amount);
        }
        throw new CalendricalException("Unable to convert " + this.getUnit() + " to any requested unit: " + Arrays.toString(requiredUnits));
    }

    public Duration toEstimatedDuration() {
        return this.unit.getEstimatedDuration().multipliedBy(this.amount);
    }

    public Duration toDuration() {
        PeriodField equivalent = this.unit.getEquivalentPeriod(ISOChronology.periodSeconds());
        if (equivalent != null) {
            return equivalent.multipliedBy(this.amount).toEstimatedDuration();
        }
        equivalent = this.unit.getEquivalentPeriod(ISOChronology.periodNanos());
        if (equivalent != null) {
            return equivalent.multipliedBy(this.amount).toEstimatedDuration();
        }
        throw new CalendricalException("Unable to convert " + this.getUnit() + " to a Duration");
    }

    @Override
    public PeriodFields toPeriodFields() {
        return PeriodFields.of(this);
    }

    @Override
    public int compareTo(PeriodField otherPeriod) {
        int cmp = this.unit.compareTo(otherPeriod.unit);
        if (cmp != 0) {
            return cmp;
        }
        return MathUtils.safeCompare(this.amount, otherPeriod.amount);
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj instanceof PeriodField) {
            PeriodField other = (PeriodField)obj;
            return this.amount == other.amount && this.unit.equals(other.unit);
        }
        return false;
    }

    public int hashCode() {
        return this.unit.hashCode() ^ (int)(this.amount ^ this.amount >>> 32);
    }

    public String toString() {
        return this.amount + " " + this.unit.getName();
    }
}

