/*
 * Decompiled with CFR 0.152.
 */
package javax.time.period;

import javax.time.calendar.format.CalendricalParseException;
import javax.time.period.Period;

class PeriodParser {
    private static final PeriodParser INSTANCE = new PeriodParser();
    private static final String TOKEN_SEQUENCE = "PYMDTHMS";
    private static final String ZERO = "PT0S";

    private PeriodParser() {
    }

    static PeriodParser getInstance() {
        return INSTANCE;
    }

    Period parse(String text) {
        String s = text.toUpperCase().replace(',', '.');
        if (ZERO.equals(s)) {
            return Period.ZERO;
        }
        if (s.length() < 3 || s.charAt(0) != 'P') {
            throw new CalendricalParseException("Period could not be parsed: " + text, text, 0);
        }
        this.validateCharactersAndOrdering(s, text);
        ParseValues values = new ParseValues(text);
        String[] datetime = s.substring(1).split("T");
        switch (datetime.length) {
            case 2: {
                this.parseDate(values, datetime[0], 1);
                this.parseTime(values, datetime[1], datetime[0].length() + 2);
                break;
            }
            case 1: {
                this.parseDate(values, datetime[0], 1);
            }
        }
        return values.toPeriod();
    }

    private void parseDate(ParseValues values, String s, int baseIndex) {
        values.index = 0;
        while (values.index < s.length()) {
            String value = this.parseNumber(values, s);
            if (values.index >= s.length()) continue;
            char c = s.charAt(values.index);
            switch (c) {
                case 'Y': {
                    values.years = this.parseInt(values, value, baseIndex);
                    break;
                }
                case 'M': {
                    values.months = this.parseInt(values, value, baseIndex);
                    break;
                }
                case 'D': {
                    values.days = this.parseInt(values, value, baseIndex);
                    break;
                }
                default: {
                    throw new CalendricalParseException("Period could not be parsed, unrecognized letter '" + c + ": " + values.text, values.text, baseIndex + values.index);
                }
            }
            values.index++;
        }
    }

    private void parseTime(ParseValues values, String s, int baseIndex) {
        values.index = 0;
        s = this.prepareTime(values, s, baseIndex);
        while (values.index < s.length()) {
            String value = this.parseNumber(values, s);
            if (values.index >= s.length()) continue;
            char c = s.charAt(values.index);
            switch (c) {
                case 'H': {
                    values.hours = this.parseInt(values, value, baseIndex);
                    break;
                }
                case 'M': {
                    values.minutes = this.parseInt(values, value, baseIndex);
                    break;
                }
                case 'S': {
                    values.seconds = this.parseInt(values, value, baseIndex);
                    break;
                }
                case 'N': {
                    values.nanos = this.parseNanos(values, value, baseIndex);
                    break;
                }
                default: {
                    throw new CalendricalParseException("Period could not be parsed, unrecognized letter '" + c + "': " + values.text, values.text, baseIndex + values.index);
                }
            }
            values.index++;
        }
    }

    private long parseNanos(ParseValues values, String s, int baseIndex) {
        if (s.length() > 9) {
            throw new CalendricalParseException("Period could not be parsed, nanosecond range exceeded: " + values.text, values.text, baseIndex + values.index - s.length());
        }
        return Long.parseLong((s + "000000000").substring(0, 9));
    }

    private String prepareTime(ParseValues values, String s, int baseIndex) {
        if (s.contains(".")) {
            int i = s.indexOf(".") + 1;
            if (Character.isDigit(s.charAt(i))) {
                ++i;
            } else {
                throw new CalendricalParseException("Period could not be parsed, invalid decimal number: " + values.text, values.text, baseIndex + values.index);
            }
            while (i < s.length()) {
                char c = s.charAt(i);
                if (Character.isDigit(c) || c == 'S') {
                    ++i;
                    continue;
                }
                throw new CalendricalParseException("Period could not be parsed, invalid decimal number: " + values.text, values.text, baseIndex + values.index);
            }
            if ((s = s.replace('S', 'N').replace('.', 'S')).contains("-0S")) {
                values.negativeSecs = true;
                s = s.replace("-0S", "0S");
            }
        }
        return s;
    }

    private int parseInt(ParseValues values, String s, int baseIndex) {
        try {
            int value = Integer.parseInt(s);
            if (s.charAt(0) == '-' && value == 0) {
                throw new CalendricalParseException("Period could not be parsed, invalid number '" + s + "': " + values.text, values.text, baseIndex + values.index - s.length());
            }
            return value;
        }
        catch (NumberFormatException ex) {
            throw new CalendricalParseException("Period could not be parsed, invalid number '" + s + "': " + values.text, values.text, baseIndex + values.index - s.length());
        }
    }

    private String parseNumber(ParseValues values, String s) {
        char c;
        int start = values.index;
        while (values.index < s.length() && ((c = s.charAt(values.index)) >= '0' && c <= '9' || c == '-')) {
            values.index++;
        }
        return s.substring(start, values.index);
    }

    private void validateCharactersAndOrdering(String s, String text) {
        char[] chars = s.toCharArray();
        int tokenPos = 0;
        boolean lastLetter = false;
        for (int i = 0; i < chars.length; ++i) {
            if (tokenPos >= TOKEN_SEQUENCE.length()) {
                throw new CalendricalParseException("Period could not be parsed, characters after last 'S': " + text, text, i);
            }
            char c = chars[i];
            if ((c < '0' || c > '9') && c != '-' && c != '.') {
                if ((tokenPos = TOKEN_SEQUENCE.indexOf(c, tokenPos)) < 0) {
                    throw new CalendricalParseException("Period could not be parsed, invalid character '" + c + "': " + text, text, i);
                }
                ++tokenPos;
                lastLetter = true;
                continue;
            }
            lastLetter = false;
        }
        if (!lastLetter) {
            throw new CalendricalParseException("Period could not be parsed, invalid last character: " + text, text, s.length() - 1);
        }
    }

    private class ParseValues {
        private int years;
        private int months;
        private int days;
        private int hours;
        private int minutes;
        private int seconds;
        private long nanos;
        private boolean negativeSecs;
        private int index;
        private String text;

        ParseValues(String text) {
            this.text = text;
        }

        Period toPeriod() {
            return Period.of(this.years, this.months, this.days, this.hours, this.minutes, this.seconds, this.negativeSecs || this.seconds < 0 ? -this.nanos : this.nanos);
        }
    }
}

