/*
 * Decompiled with CFR 0.152.
 */
package javax.time.scales;

import java.io.Serializable;
import javax.time.Duration;
import javax.time.Instant;
import javax.time.InstantProvider;
import javax.time.MathUtils;
import javax.time.scales.EarlyUTC_TAI;
import javax.time.scales.LeapSeconds;
import javax.time.scales.ScaleUtil;
import javax.time.scales.TimeScale;
import javax.time.scales.TimeScaleInstant;

class TAI
implements TimeScale,
Serializable {
    static final TAI INSTANCE = new TAI();
    static final String NAME = "TAI";
    static final TimeScaleInstant START_TAI = TimeScaleInstant.seconds(INSTANCE, ScaleUtil.START_TAI, 0);
    static final TimeScaleInstant START_LEAP_SECONDS = TimeScaleInstant.seconds(INSTANCE, ScaleUtil.START_LEAP_SECONDS + 10L, 0);
    private static final long serialVersionUID = 1L;

    private TAI() {
    }

    private Object readResolve() {
        return INSTANCE;
    }

    @Override
    public String getName() {
        return NAME;
    }

    @Override
    public boolean supportsLeapSecond() {
        return false;
    }

    @Override
    public Instant toInstant(TimeScaleInstant tsi) {
        if (tsi.getTimeScale() != this) {
            return tsi.getTimeScale().toInstant(tsi);
        }
        if (tsi.compareTo(START_LEAP_SECONDS) >= 0) {
            return this.toModernInstant(tsi);
        }
        if (tsi.compareTo(START_TAI) > 0) {
            return this.toEarlyInstant(tsi);
        }
        return Instant.seconds(tsi.getEpochSeconds(), tsi.getNanoOfSecond());
    }

    private Instant toModernInstant(TimeScaleInstant tsi) {
        LeapSeconds.Entry e = LeapSeconds.list().entryFromTAI(tsi);
        long s = MathUtils.safeSubtract(tsi.getEpochSeconds(), (long)e.getDeltaSeconds());
        if (e.getNext() != null && s == e.getNext().getStartEpochSeconds()) {
            --s;
        }
        return Instant.seconds(s, tsi.getNanoOfSecond());
    }

    private Instant toEarlyInstant(TimeScaleInstant tsi) {
        EarlyUTC_TAI.Entry e = EarlyUTC_TAI.list().entryFromTAI(tsi);
        long nanos = (long)tsi.getNanoOfSecond() - e.getTAIDeltaNanoseconds(tsi.getEpochSeconds(), tsi.getNanoOfSecond());
        long s = MathUtils.safeAdd(tsi.getEpochSeconds(), nanos / 1000000000L);
        if ((nanos %= 1000000000L) < 0L) {
            --s;
            nanos += 1000000000L;
        }
        if (s == e.getEndEpochSeconds() && (nanos -= (long)e.getUTCGapNanoseconds()) < 0L) {
            --s;
            nanos += 1000000000L;
        }
        return Instant.seconds(s, (int)nanos);
    }

    @Override
    public TimeScaleInstant toTAI(TimeScaleInstant tsi) {
        if (tsi.getTimeScale() != this) {
            return tsi.getTimeScale().toTAI(tsi);
        }
        return tsi;
    }

    @Override
    public TimeScaleInstant toTimeScaleInstant(InstantProvider provider) {
        Instant t = Instant.from(provider);
        return ScaleUtil.tai(t.getEpochSeconds(), t.getNanoOfSecond());
    }

    @Override
    public TimeScaleInstant toTimeScaleInstant(TimeScaleInstant tsi) {
        if (tsi.getTimeScale() != this) {
            return tsi.getTimeScale().toTAI(tsi);
        }
        return tsi;
    }

    @Override
    public TimeScaleInstant.Validity getValidity(TimeScaleInstant tsi) {
        if (tsi.getTimeScale() != this) {
            return tsi.getTimeScale().getValidity(tsi);
        }
        return TimeScaleInstant.Validity.VALID;
    }

    @Override
    public TimeScaleInstant add(TimeScaleInstant tsi, Duration dur) {
        if (tsi.getTimeScale() != this) {
            return tsi.getTimeScale().add(tsi, dur);
        }
        return ScaleUtil.simpleAdd(tsi, dur);
    }

    @Override
    public TimeScaleInstant subtract(TimeScaleInstant tsi, Duration dur) {
        if (tsi.getTimeScale() != this) {
            return tsi.getTimeScale().subtract(tsi, dur);
        }
        return ScaleUtil.simpleSubtract(tsi, dur);
    }

    @Override
    public Duration durationBetween(TimeScaleInstant start, TimeScaleInstant end) {
        if (start.getTimeScale() != this) {
            start = start.getTimeScale().toTAI(start);
        }
        if (end.getTimeScale() != this) {
            end = end.getTimeScale().toTAI(end);
        }
        return ScaleUtil.durationBetween(start, end);
    }
}

