/*
 * Decompiled with CFR 0.152.
 */
package javax.time.scales;

import javax.time.scales.ScaleUtil;
import javax.time.scales.TAI;
import javax.time.scales.TimeScaleInstant;

public abstract class UTCPeriod {
    private static final int NANOS_PER_SECOND = 1000000000;
    private UTCPeriod next;
    private UTCPeriod previous;
    private TimeScaleInstant startTAI;
    private final long startEpochSeconds;

    UTCPeriod(int year, int month, int day) {
        this.startEpochSeconds = ScaleUtil.epochSeconds(year, month, day);
    }

    public UTCPeriod getNext() {
        return this.next;
    }

    public UTCPeriod getPrevious() {
        return this.previous;
    }

    public long getStartEpochSeconds() {
        return this.startEpochSeconds;
    }

    public TimeScaleInstant getStartTAI() {
        return this.startTAI;
    }

    void initialise(UTCPeriod previous) {
        if (previous != null) {
            this.previous = previous;
            previous.next = this;
        }
        long delta = this.getUTCDeltaNanoseconds(this.startEpochSeconds, 0);
        this.startTAI = TimeScaleInstant.seconds(TAI.INSTANCE, this.startEpochSeconds + delta / 1000000000L, (int)(delta % 1000000000L));
    }

    public abstract long getUTCDeltaNanoseconds(long var1, int var3);

    public abstract long getTAIDeltaNanoseconds(long var1, int var3);
}

