/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.cache.util;

import java.io.ByteArrayOutputStream;

public class ExposedByteArrayOutputStream
extends ByteArrayOutputStream {
    public static final int DEFAULT_DOUBLING_SIZE = 0x400000;
    private int maxDoublingSize = 0x400000;

    public ExposedByteArrayOutputStream() {
    }

    public ExposedByteArrayOutputStream(int size) {
        super(size);
    }

    public ExposedByteArrayOutputStream(int size, int maxDoublingSize) {
        super(size);
        this.maxDoublingSize = maxDoublingSize;
    }

    public byte[] getRawBuffer() {
        return this.buf;
    }

    public synchronized void write(byte[] b, int off, int len) {
        if (off < 0 || off > b.length || len < 0 || off + len > b.length || off + len < 0) {
            throw new IndexOutOfBoundsException();
        }
        if (len == 0) {
            return;
        }
        int newcount = this.count + len;
        if (newcount > this.buf.length) {
            byte[] newbuf = new byte[this.getNewBufferSize(this.buf.length, newcount)];
            System.arraycopy(this.buf, 0, newbuf, 0, this.count);
            this.buf = newbuf;
        }
        System.arraycopy(b, off, this.buf, this.count, len);
        this.count = newcount;
    }

    public synchronized void write(int b) {
        int newcount = this.count + 1;
        if (newcount > this.buf.length) {
            byte[] newbuf = new byte[this.getNewBufferSize(this.buf.length, newcount)];
            System.arraycopy(this.buf, 0, newbuf, 0, this.count);
            this.buf = newbuf;
        }
        this.buf[this.count] = (byte)b;
        this.count = newcount;
    }

    public int getMaxDoublingSize() {
        return this.maxDoublingSize;
    }

    public int getNewBufferSize(int curSize, int minNewSize) {
        if (curSize <= this.maxDoublingSize) {
            return Math.max(curSize << 1, minNewSize);
        }
        return Math.max(curSize + (curSize >> 2), minNewSize);
    }
}

