/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.util.propertyeditor;

import java.beans.PropertyEditorSupport;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.util.Properties;
import org.jboss.util.NestedRuntimeException;
import org.jboss.util.StringPropertyReplacer;

public class PropertiesEditor
extends PropertyEditorSupport {
    private static final String ENC = "ISO-8859-1";

    public void setAsText(String propsText) {
        try {
            Properties rawProps = new Properties(System.getProperties());
            ByteArrayInputStream bais = new ByteArrayInputStream(propsText.getBytes(ENC));
            rawProps.load(bais);
            Properties props = new Properties();
            for (String string : rawProps.keySet()) {
                String value = rawProps.getProperty(string);
                String value2 = StringPropertyReplacer.replaceProperties(value, rawProps);
                props.setProperty(string, value2);
            }
            rawProps.clear();
            this.setValue(props);
        }
        catch (IOException e) {
            throw new NestedRuntimeException(e);
        }
    }

    public String getAsText() {
        try {
            ByteArrayOutputStream baos = new ByteArrayOutputStream();
            Properties p = (Properties)this.getValue();
            p.store(baos, null);
            return baos.toString(ENC);
        }
        catch (IOException e) {
            throw new NestedRuntimeException(e);
        }
    }
}

