/*
 * Decompiled with CFR 0.152.
 */
package javax.management;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.ObjectStreamField;
import java.io.Serializable;
import java.util.HashSet;
import java.util.Set;
import java.util.Vector;
import javax.management.AttributeChangeNotification;
import javax.management.Notification;
import javax.management.NotificationFilter;

public class AttributeChangeNotificationFilter
implements NotificationFilter,
Serializable {
    private static final long serialVersionUID = -6347317584796410029L;
    private static final ObjectStreamField[] serialPersistentFields = new ObjectStreamField[]{new ObjectStreamField("enabledAttributes", Vector.class)};
    private Set attributes = new HashSet();

    public synchronized boolean isNotificationEnabled(Notification notification) {
        AttributeChangeNotification notif;
        return notification != null && notification instanceof AttributeChangeNotification && this.attributes.contains((notif = (AttributeChangeNotification)notification).getAttributeName());
    }

    public synchronized void enableAttribute(String name) throws IllegalArgumentException {
        if (name == null) {
            throw new IllegalArgumentException("Null attribute name");
        }
        this.attributes.add(name);
    }

    public synchronized void disableAttribute(String name) {
        this.attributes.remove(name);
    }

    public synchronized void disableAllAttributes() {
        this.attributes.clear();
    }

    public synchronized Vector getEnabledAttributes() {
        return new Vector(this.attributes);
    }

    public String toString() {
        StringBuffer buffer = new StringBuffer(100);
        buffer.append(this.getClass().getName()).append(":");
        buffer.append(" enabledAttributes=").append(this.getEnabledAttributes());
        return buffer.toString();
    }

    private void readObject(ObjectInputStream ois) throws IOException, ClassNotFoundException {
        ObjectInputStream.GetField getField = ois.readFields();
        Vector enabled = (Vector)getField.get("enabledAttributes", null);
        this.attributes = new HashSet(enabled);
    }

    private void writeObject(ObjectOutputStream oos) throws IOException {
        ObjectOutputStream.PutField putField = oos.putFields();
        putField.put("enabledAttributes", new Vector(this.attributes));
        oos.writeFields();
    }
}

