/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.webdav;

import java.util.HashMap;
import org.apache.log4j.Logger;

public class DavMethods {
    private static Logger log = Logger.getLogger(DavMethods.class);
    private static HashMap methodMap = new HashMap();
    private static int[] labelMethods;
    public static final int DAV_OPTIONS = 1;
    public static final String METHOD_OPTIONS = "OPTIONS";
    public static final int DAV_GET = 2;
    public static final String METHOD_GET = "GET";
    public static final int DAV_HEAD = 3;
    public static final String METHOD_HEAD = "HEAD";
    public static final int DAV_POST = 4;
    private static final String METHOD_POST = "POST";
    public static final int DAV_DELETE = 5;
    public static final String METHOD_DELETE = "DELETE";
    public static final int DAV_PUT = 6;
    public static final String METHOD_PUT = "PUT";
    public static final int DAV_PROPFIND = 7;
    public static final String METHOD_PROPFIND = "PROPFIND";
    public static final int DAV_PROPPATCH = 8;
    public static final String METHOD_PROPPATCH = "PROPPATCH";
    public static final int DAV_MKCOL = 9;
    public static final String METHOD_MKCOL = "MKCOL";
    public static final int DAV_COPY = 10;
    public static final String METHOD_COPY = "COPY";
    public static final int DAV_MOVE = 11;
    public static final String METHOD_MOVE = "MOVE";
    public static final int DAV_LOCK = 12;
    public static final String METHOD_LOCK = "LOCK";
    public static final int DAV_UNLOCK = 13;
    public static final String METHOD_UNLOCK = "UNLOCK";
    public static final int DAV_ORDERPATCH = 14;
    public static final String METHOD_ORDERPATCH = "ORDERPATCH";
    public static final int DAV_SUBSCRIBE = 15;
    public static final String METHOD_SUBSCRIBE = "SUBSCRIBE";
    public static final int DAV_UNSUBSCRIBE = 16;
    public static final String METHOD_UNSUBSCRIBE = "UNSUBSCRIBE";
    public static final int DAV_POLL = 17;
    public static final String METHOD_POLL = "POLL";
    public static final int DAV_SEARCH = 18;
    public static final String METHOD_SEARCH = "SEARCH";
    public static final int DAV_REPORT = 19;
    public static final String METHOD_REPORT = "REPORT";
    public static final int DAV_VERSION_CONTROL = 20;
    public static final String METHOD_VERSION_CONTROL = "VERSION-CONTROL";
    public static final int DAV_CHECKIN = 21;
    public static final String METHOD_CHECKIN = "CHECKIN";
    public static final int DAV_CHECKOUT = 22;
    public static final String METHOD_CHECKOUT = "CHECKOUT";
    public static final int DAV_UNCHECKOUT = 23;
    public static final String METHOD_UNCHECKOUT = "UNCHECKOUT";
    public static final int DAV_LABEL = 24;
    public static final String METHOD_LABEL = "LABEL";
    public static final int DAV_MERGE = 25;
    public static final String METHOD_MERGE = "MERGE";
    public static final int DAV_UPDATE = 26;
    public static final String METHOD_UPDATE = "UPDATE";
    public static final int DAV_MKWORKSPACE = 27;
    public static final String METHOD_MKWORKSPACE = "MKWORKSPACE";

    public static int getMethodCode(String method) {
        Integer code = (Integer)methodMap.get(method.toUpperCase());
        if (code != null) {
            return code;
        }
        return 0;
    }

    private static void addMethodCode(String method, int code) {
        methodMap.put(method, new Integer(code));
    }

    public static boolean isMethodAffectedByLabel(String method) {
        int code = DavMethods.getMethodCode(method);
        for (int i = 0; i < labelMethods.length; ++i) {
            if (code != labelMethods[i]) continue;
            return true;
        }
        return false;
    }

    static {
        DavMethods.addMethodCode(METHOD_OPTIONS, 1);
        DavMethods.addMethodCode(METHOD_GET, 2);
        DavMethods.addMethodCode(METHOD_HEAD, 3);
        DavMethods.addMethodCode(METHOD_POST, 4);
        DavMethods.addMethodCode(METHOD_PUT, 6);
        DavMethods.addMethodCode(METHOD_DELETE, 5);
        DavMethods.addMethodCode(METHOD_PROPFIND, 7);
        DavMethods.addMethodCode(METHOD_PROPPATCH, 8);
        DavMethods.addMethodCode(METHOD_MKCOL, 9);
        DavMethods.addMethodCode(METHOD_COPY, 10);
        DavMethods.addMethodCode(METHOD_MOVE, 11);
        DavMethods.addMethodCode(METHOD_LOCK, 12);
        DavMethods.addMethodCode(METHOD_UNLOCK, 13);
        DavMethods.addMethodCode(METHOD_ORDERPATCH, 14);
        DavMethods.addMethodCode(METHOD_SUBSCRIBE, 15);
        DavMethods.addMethodCode(METHOD_UNSUBSCRIBE, 16);
        DavMethods.addMethodCode(METHOD_POLL, 17);
        DavMethods.addMethodCode(METHOD_SEARCH, 18);
        DavMethods.addMethodCode(METHOD_REPORT, 19);
        DavMethods.addMethodCode(METHOD_VERSION_CONTROL, 20);
        DavMethods.addMethodCode(METHOD_CHECKIN, 21);
        DavMethods.addMethodCode(METHOD_CHECKOUT, 22);
        DavMethods.addMethodCode(METHOD_UNCHECKOUT, 23);
        DavMethods.addMethodCode(METHOD_LABEL, 24);
        DavMethods.addMethodCode(METHOD_MERGE, 25);
        DavMethods.addMethodCode(METHOD_UPDATE, 26);
        DavMethods.addMethodCode(METHOD_MKWORKSPACE, 27);
        labelMethods = new int[]{2, 3, 1, 7, 24, 10};
    }
}

