/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.webdav;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.UnsupportedEncodingException;
import java.net.URI;
import java.net.URISyntaxException;
import java.security.Principal;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import javax.servlet.RequestDispatcher;
import javax.servlet.ServletInputStream;
import javax.servlet.http.Cookie;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpSession;
import org.apache.jackrabbit.util.Text;
import org.apache.jackrabbit.webdav.DavConstants;
import org.apache.jackrabbit.webdav.DavLocatorFactory;
import org.apache.jackrabbit.webdav.DavResource;
import org.apache.jackrabbit.webdav.DavResourceLocator;
import org.apache.jackrabbit.webdav.DavSession;
import org.apache.jackrabbit.webdav.WebdavRequest;
import org.apache.jackrabbit.webdav.header.CodedUrlHeader;
import org.apache.jackrabbit.webdav.header.DepthHeader;
import org.apache.jackrabbit.webdav.header.IfHeader;
import org.apache.jackrabbit.webdav.lock.LockInfo;
import org.apache.jackrabbit.webdav.lock.Scope;
import org.apache.jackrabbit.webdav.lock.Type;
import org.apache.jackrabbit.webdav.observation.SubscriptionInfo;
import org.apache.jackrabbit.webdav.ordering.OrderPatch;
import org.apache.jackrabbit.webdav.ordering.Position;
import org.apache.jackrabbit.webdav.property.DavPropertyName;
import org.apache.jackrabbit.webdav.property.DavPropertyNameSet;
import org.apache.jackrabbit.webdav.property.DavPropertySet;
import org.apache.jackrabbit.webdav.property.DefaultDavProperty;
import org.apache.jackrabbit.webdav.transaction.TransactionInfo;
import org.apache.jackrabbit.webdav.version.LabelInfo;
import org.apache.jackrabbit.webdav.version.MergeInfo;
import org.apache.jackrabbit.webdav.version.OptionsInfo;
import org.apache.jackrabbit.webdav.version.UpdateInfo;
import org.apache.jackrabbit.webdav.version.report.ReportInfo;
import org.apache.log4j.Logger;
import org.jdom.Document;
import org.jdom.Element;
import org.jdom.JDOMException;
import org.jdom.input.SAXBuilder;

public class WebdavRequestImpl
implements WebdavRequest,
DavConstants {
    private static Logger log = Logger.getLogger(WebdavRequestImpl.class);
    private final HttpServletRequest httpRequest;
    private final DavLocatorFactory factory;
    private final IfHeader ifHeader;
    private final String hrefPrefix;
    private DavSession session;
    private int propfindType = 1;
    private DavPropertyNameSet propfindProps;
    private DavPropertySet proppatchSet;
    private DavPropertyNameSet proppatchRemove;

    public WebdavRequestImpl(HttpServletRequest httpRequest, DavLocatorFactory factory) {
        this.httpRequest = httpRequest;
        this.factory = factory;
        this.ifHeader = new IfHeader(httpRequest);
        String host = this.getHeader("Host");
        String scheme = this.getScheme();
        this.hrefPrefix = scheme + "://" + host + this.getContextPath();
    }

    public void setDavSession(DavSession session) {
        this.session = session;
        if (session != null && session.getRepositorySession() != null) {
            String lt = this.getLockToken();
            if (lt != null) {
                session.addLockToken(lt);
            }
            Iterator it = this.ifHeader.getAllTokens();
            while (it.hasNext()) {
                String ifHeaderToken = (String)it.next();
                session.addLockToken(ifHeaderToken);
            }
        }
    }

    public DavSession getDavSession() {
        return this.session;
    }

    public DavResourceLocator getRequestLocator() {
        String path = this.getPathInfo();
        if (path == null) {
            path = this.getServletPath();
        }
        return this.factory.createResourceLocator(this.hrefPrefix, path);
    }

    public DavResourceLocator getDestinationLocator() {
        String destination = this.httpRequest.getHeader("Destination");
        if (destination != null) {
            block5: {
                try {
                    URI uri = new URI(destination);
                    if (uri.getAuthority().equals(this.httpRequest.getHeader("Host"))) {
                        destination = Text.unescape((String)uri.getPath());
                    }
                }
                catch (URISyntaxException e) {
                    log.debug((Object)("Destination is path is not a valid URI (" + e.getMessage() + "."));
                    int pos = destination.lastIndexOf(":");
                    if (pos <= 0) break block5;
                    destination = destination.substring(destination.indexOf("/", pos));
                    log.debug((Object)("Tried to retrieve resource destination path from invalid URI: " + destination));
                }
            }
            String contextPath = this.httpRequest.getContextPath();
            if (destination.startsWith(contextPath)) {
                destination = destination.substring(contextPath.length());
            }
        }
        return this.factory.createResourceLocator(this.hrefPrefix, destination);
    }

    public boolean isOverwrite() {
        boolean doOverwrite = true;
        String overwriteHeader = this.httpRequest.getHeader("Overwrite");
        if (overwriteHeader != null && !overwriteHeader.equalsIgnoreCase("T")) {
            doOverwrite = false;
        }
        return doOverwrite;
    }

    public int getDepth(int defaultValue) {
        return DepthHeader.parse(this.httpRequest, defaultValue).getDepth();
    }

    public int getDepth() {
        return this.getDepth(Integer.MAX_VALUE);
    }

    public long getTimeout() {
        String timeoutStr = this.httpRequest.getHeader("Timeout");
        long timeout = Long.MIN_VALUE;
        if (timeoutStr != null && timeoutStr.length() > 0) {
            int secondsInd = timeoutStr.indexOf("Second-");
            if (secondsInd >= 0) {
                int i;
                for (i = secondsInd += 7; i < timeoutStr.length() && Character.isDigit(timeoutStr.charAt(i)); ++i) {
                }
                try {
                    timeout = 1000L * Long.parseLong(timeoutStr.substring(secondsInd, i));
                }
                catch (NumberFormatException ignore) {
                    log.error((Object)("Invalid timeout format: " + timeoutStr));
                }
            } else if (timeoutStr.equalsIgnoreCase("Infinite")) {
                timeout = Long.MAX_VALUE;
            }
        }
        return timeout;
    }

    public String getLockToken() {
        return CodedUrlHeader.parse(this.httpRequest, "Lock-Token").getCodedUrl();
    }

    public Document getRequestDocument() {
        Document requestDocument = null;
        try {
            ServletInputStream in = this.httpRequest.getInputStream();
            if (in != null) {
                SAXBuilder builder = new SAXBuilder(false);
                requestDocument = builder.build((InputStream)in);
            }
        }
        catch (IOException e) {
            log.debug((Object)("Unable to build an XML Document from the request body: " + e.getMessage()));
        }
        catch (JDOMException e) {
            log.debug((Object)("Unable to build an XML Document from the request body: " + e.getMessage()));
        }
        return requestDocument;
    }

    public int getPropFindType() {
        if (this.propfindProps == null) {
            this.parsePropFindRequest();
        }
        return this.propfindType;
    }

    public DavPropertyNameSet getPropFindProperties() {
        if (this.propfindProps == null) {
            this.parsePropFindRequest();
        }
        return this.propfindProps;
    }

    private void parsePropFindRequest() {
        this.propfindProps = new DavPropertyNameSet();
        Document requestDocument = this.getRequestDocument();
        if (requestDocument == null) {
            return;
        }
        Element root = requestDocument.getRootElement();
        if (!root.getName().equals("propfind")) {
            log.info((Object)"PropFind-Request has no <profind> tag.");
            return;
        }
        List childList = root.getChildren();
        for (int i = 0; i < childList.size(); ++i) {
            Element child = (Element)childList.get(i);
            String nodeName = child.getName();
            if ("prop".equals(nodeName)) {
                this.propfindType = 0;
                this.propfindProps = new DavPropertyNameSet(child);
                break;
            }
            if ("propname".equals(nodeName)) {
                this.propfindType = 2;
                break;
            }
            if (!"allprop".equals(nodeName)) continue;
            this.propfindType = 1;
            break;
        }
    }

    public DavPropertySet getPropPatchSetProperties() {
        if (this.proppatchSet == null) {
            this.parsePropPatchRequest();
        }
        return this.proppatchSet;
    }

    public DavPropertyNameSet getPropPatchRemoveProperties() {
        if (this.proppatchRemove == null) {
            this.parsePropPatchRequest();
        }
        return this.proppatchRemove;
    }

    private void parsePropPatchRequest() {
        List removeList;
        this.proppatchSet = new DavPropertySet();
        this.proppatchRemove = new DavPropertyNameSet();
        Document requestDocument = this.getRequestDocument();
        if (requestDocument == null) {
            return;
        }
        Element root = requestDocument.getRootElement();
        if (!root.getName().equals("propertyupdate")) {
            log.warn((Object)"PropPatch-Request has no <propertyupdate> tag.");
            return;
        }
        List setList = root.getChildren("set", NAMESPACE);
        if (!setList.isEmpty()) {
            Iterator setIter = setList.iterator();
            while (setIter.hasNext()) {
                Element propElem = ((Element)setIter.next()).getChild("prop", NAMESPACE);
                for (Element propertyElem : propElem.getChildren()) {
                    this.proppatchSet.add(DefaultDavProperty.createFromXml(propertyElem));
                }
            }
        }
        if (!(removeList = root.getChildren("remove", NAMESPACE)).isEmpty()) {
            Iterator removeIter = removeList.iterator();
            while (removeIter.hasNext()) {
                Element propElem = ((Element)removeIter.next()).getChild("prop", NAMESPACE);
                for (Element propertyElem : propElem.getChildren()) {
                    this.proppatchRemove.add(DavPropertyName.createFromXml(propertyElem));
                }
            }
        }
    }

    public LockInfo getLockInfo() {
        LockInfo lockInfo = null;
        boolean isDeep = this.getDepth(Integer.MAX_VALUE) == Integer.MAX_VALUE;
        Document requestDocument = this.getRequestDocument();
        if (requestDocument != null) {
            Element root = requestDocument.getRootElement();
            if (root.getName().equals("lockinfo")) {
                lockInfo = new LockInfo(root, this.getTimeout(), isDeep);
            } else {
                log.debug((Object)"Lock-Request has no <lockinfo> tag.");
            }
        } else {
            lockInfo = new LockInfo(null, this.getTimeout(), isDeep);
        }
        return lockInfo;
    }

    public boolean matchesIfHeader(DavResource resource) {
        if (this.ifHeader == null || resource == null || !resource.hasLock(Type.WRITE, Scope.EXCLUSIVE)) {
            return true;
        }
        boolean isMatching = false;
        String lockToken = resource.getLock(Type.WRITE, Scope.EXCLUSIVE).getToken();
        if (lockToken != null) {
            isMatching = this.matchesIfHeader(resource.getHref(), lockToken, "");
        }
        return isMatching;
    }

    public boolean matchesIfHeader(String href, String token, String eTag) {
        return this.ifHeader.matches(href, token, eTag);
    }

    public String getTransactionId() {
        return CodedUrlHeader.parse(this.httpRequest, "TransactionId").getCodedUrl();
    }

    public TransactionInfo getTransactionInfo() {
        Document requestDocument = this.getRequestDocument();
        if (requestDocument != null) {
            try {
                return new TransactionInfo(requestDocument.getRootElement());
            }
            catch (IllegalArgumentException e) {
                log.error((Object)e.getMessage());
            }
        }
        return null;
    }

    public String getSubscriptionId() {
        return CodedUrlHeader.parse(this.httpRequest, "SubscriptionId").getCodedUrl();
    }

    public SubscriptionInfo getSubscriptionInfo() {
        Element root;
        Document requestDocument = this.getRequestDocument();
        if (requestDocument != null && "subscriptioninfo".equals((root = requestDocument.getRootElement()).getName())) {
            int depth = this.getDepth(0);
            return new SubscriptionInfo(root, this.getTimeout(), depth == Integer.MAX_VALUE);
        }
        return null;
    }

    public String getOrderingType() {
        return this.getHeader("Ordering-Type");
    }

    public Position getPosition() {
        String[] typeNSegment;
        String h = this.getHeader("Position");
        Position pos = null;
        if (h != null && (typeNSegment = h.split("\\s")).length == 2) {
            try {
                pos = new Position(typeNSegment[0], typeNSegment[1]);
            }
            catch (IllegalArgumentException e) {
                log.error((Object)("Cannot parse Position header: " + e.getMessage()));
            }
        }
        return pos;
    }

    public OrderPatch getOrderPatch() {
        OrderPatch op = null;
        Document requestDocument = this.getRequestDocument();
        if (requestDocument != null) {
            Element root = requestDocument.getRootElement();
            if (!"orderpatch".equals(root.getName()) || root.getChild("ordering-type") == null) {
                log.error((Object)"ORDERPATH request body must start with an 'orderpatch' element, which must contain an 'ordering-type' child element.");
                return op;
            }
            try {
                op = new OrderPatch(root);
            }
            catch (IllegalArgumentException e) {
                log.error((Object)e.getMessage());
            }
        } else {
            log.error((Object)"Error while building xml document from ORDERPATH request body.");
        }
        return op;
    }

    public String getLabel() {
        String label = this.getHeader("Label");
        if (label != null) {
            label = Text.unescape((String)label);
        }
        return label;
    }

    public LabelInfo getLabelInfo() {
        LabelInfo lInfo = null;
        Document requestDocument = this.getRequestDocument();
        if (requestDocument != null) {
            Element root = requestDocument.getRootElement();
            int depth = this.getDepth(0);
            try {
                lInfo = new LabelInfo(root, depth);
            }
            catch (IllegalArgumentException e) {
                log.error((Object)e.getMessage());
            }
        }
        return lInfo;
    }

    public MergeInfo getMergeInfo() {
        MergeInfo mInfo = null;
        Document requestDocument = this.getRequestDocument();
        if (requestDocument != null) {
            try {
                mInfo = new MergeInfo(requestDocument.getRootElement());
            }
            catch (IllegalArgumentException e) {
                log.error((Object)e.getMessage());
            }
        }
        return mInfo;
    }

    public UpdateInfo getUpdateInfo() {
        UpdateInfo uInfo = null;
        Document requestDocument = this.getRequestDocument();
        if (requestDocument != null) {
            try {
                uInfo = new UpdateInfo(requestDocument.getRootElement());
            }
            catch (IllegalArgumentException e) {
                log.error((Object)e.getMessage());
            }
        }
        return uInfo;
    }

    public ReportInfo getReportInfo() {
        ReportInfo rInfo = null;
        Document requestDocument = this.getRequestDocument();
        if (requestDocument != null) {
            rInfo = new ReportInfo(requestDocument.getRootElement(), this.getDepth(0));
        }
        return rInfo;
    }

    public OptionsInfo getOptionsInfo() {
        OptionsInfo info = null;
        Document requestDocument = this.getRequestDocument();
        if (requestDocument != null) {
            info = new OptionsInfo(requestDocument.getRootElement());
        }
        return info;
    }

    public String getAuthType() {
        return this.httpRequest.getAuthType();
    }

    public Cookie[] getCookies() {
        return this.httpRequest.getCookies();
    }

    public long getDateHeader(String s) {
        return this.httpRequest.getDateHeader(s);
    }

    public String getHeader(String s) {
        return this.httpRequest.getHeader(s);
    }

    public Enumeration getHeaders(String s) {
        return this.httpRequest.getHeaders(s);
    }

    public Enumeration getHeaderNames() {
        return this.httpRequest.getHeaderNames();
    }

    public int getIntHeader(String s) {
        return this.httpRequest.getIntHeader(s);
    }

    public String getMethod() {
        return this.httpRequest.getMethod();
    }

    public String getPathInfo() {
        return this.httpRequest.getPathInfo();
    }

    public String getPathTranslated() {
        return this.httpRequest.getPathTranslated();
    }

    public String getContextPath() {
        return this.httpRequest.getContextPath();
    }

    public String getQueryString() {
        return this.httpRequest.getQueryString();
    }

    public String getRemoteUser() {
        return this.httpRequest.getRemoteUser();
    }

    public boolean isUserInRole(String s) {
        return this.httpRequest.isUserInRole(s);
    }

    public Principal getUserPrincipal() {
        return this.httpRequest.getUserPrincipal();
    }

    public String getRequestedSessionId() {
        return this.httpRequest.getRequestedSessionId();
    }

    public String getRequestURI() {
        return this.httpRequest.getRequestURI();
    }

    public StringBuffer getRequestURL() {
        return this.httpRequest.getRequestURL();
    }

    public String getServletPath() {
        return this.httpRequest.getServletPath();
    }

    public HttpSession getSession(boolean b) {
        return this.httpRequest.getSession(b);
    }

    public HttpSession getSession() {
        return this.httpRequest.getSession();
    }

    public boolean isRequestedSessionIdValid() {
        return this.httpRequest.isRequestedSessionIdValid();
    }

    public boolean isRequestedSessionIdFromCookie() {
        return this.httpRequest.isRequestedSessionIdFromCookie();
    }

    public boolean isRequestedSessionIdFromURL() {
        return this.httpRequest.isRequestedSessionIdFromURL();
    }

    public boolean isRequestedSessionIdFromUrl() {
        return this.httpRequest.isRequestedSessionIdFromUrl();
    }

    public Object getAttribute(String s) {
        return this.httpRequest.getAttribute(s);
    }

    public Enumeration getAttributeNames() {
        return this.httpRequest.getAttributeNames();
    }

    public String getCharacterEncoding() {
        return this.httpRequest.getCharacterEncoding();
    }

    public void setCharacterEncoding(String s) throws UnsupportedEncodingException {
        this.httpRequest.setCharacterEncoding(s);
    }

    public int getContentLength() {
        return this.httpRequest.getContentLength();
    }

    public String getContentType() {
        return this.httpRequest.getContentType();
    }

    public ServletInputStream getInputStream() throws IOException {
        return this.httpRequest.getInputStream();
    }

    public String getParameter(String s) {
        return this.httpRequest.getParameter(s);
    }

    public Enumeration getParameterNames() {
        return this.httpRequest.getParameterNames();
    }

    public String[] getParameterValues(String s) {
        return this.httpRequest.getParameterValues(s);
    }

    public Map getParameterMap() {
        return this.httpRequest.getParameterMap();
    }

    public String getProtocol() {
        return this.httpRequest.getProtocol();
    }

    public String getScheme() {
        return this.httpRequest.getScheme();
    }

    public String getServerName() {
        return this.httpRequest.getServerName();
    }

    public int getServerPort() {
        return this.httpRequest.getServerPort();
    }

    public BufferedReader getReader() throws IOException {
        return this.httpRequest.getReader();
    }

    public String getRemoteAddr() {
        return this.httpRequest.getRemoteAddr();
    }

    public String getRemoteHost() {
        return this.httpRequest.getRemoteHost();
    }

    public void setAttribute(String s, Object o) {
        this.httpRequest.setAttribute(s, o);
    }

    public void removeAttribute(String s) {
        this.httpRequest.removeAttribute(s);
    }

    public Locale getLocale() {
        return this.httpRequest.getLocale();
    }

    public Enumeration getLocales() {
        return this.httpRequest.getLocales();
    }

    public boolean isSecure() {
        return this.httpRequest.isSecure();
    }

    public RequestDispatcher getRequestDispatcher(String s) {
        return this.httpRequest.getRequestDispatcher(s);
    }

    public String getRealPath(String s) {
        return this.httpRequest.getRealPath(s);
    }
}

