/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.webdav.lock;

import java.util.List;
import org.apache.jackrabbit.webdav.lock.Scope;
import org.apache.jackrabbit.webdav.lock.Type;
import org.jdom.Element;

public class LockInfo {
    private Type type;
    private Scope scope;
    private String owner;
    private boolean isDeep;
    private long timeout;
    private boolean isRefreshLock;

    public LockInfo(Element liElement, long timeout, boolean isDeep) {
        this.timeout = timeout;
        this.isDeep = isDeep;
        if (liElement != null) {
            if (!"lockinfo".equals(liElement.getName())) {
                throw new IllegalArgumentException("Element must have name 'lockinfo'.");
            }
            List childList = liElement.getChildren();
            for (int i = 0; i < childList.size(); ++i) {
                Element child = (Element)childList.get(i);
                String nodeName = child.getName();
                if ("locktype".equals(nodeName)) {
                    Element typeElement = LockInfo.getFirstChildElement(child);
                    this.type = Type.create(typeElement);
                    continue;
                }
                if ("lockscope".equals(nodeName)) {
                    Element scopeElement = LockInfo.getFirstChildElement(child);
                    this.scope = Scope.create(scopeElement);
                    continue;
                }
                if (!"owner".equals(nodeName)) continue;
                this.owner = child.getChildTextTrim("href");
                if (this.owner != null) continue;
                this.owner = child.getTextTrim();
            }
            this.isRefreshLock = false;
        } else {
            this.isRefreshLock = true;
        }
    }

    private static Element getFirstChildElement(Element elem) {
        if (elem.getContentSize() > 0) {
            for (Object content : elem.getContent()) {
                if (!(content instanceof Element)) continue;
                return (Element)content;
            }
        }
        return null;
    }

    public Type getType() {
        return this.type;
    }

    public void setType(Type type) {
        this.type = type;
    }

    public Scope getScope() {
        return this.scope;
    }

    public void setScope(Scope scope) {
        this.scope = scope;
    }

    public String getOwner() {
        return this.owner;
    }

    public boolean isDeep() {
        return this.isDeep;
    }

    public long getTimeout() {
        return this.timeout;
    }

    public boolean isRefreshLock() {
        return this.isRefreshLock;
    }
}

