/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.webdav.lock;

import java.util.HashMap;
import java.util.Map;
import org.apache.jackrabbit.webdav.DavConstants;
import org.jdom.Element;
import org.jdom.Namespace;

public class Scope {
    private static final Map scopes = new HashMap();
    public static final Scope EXCLUSIVE = Scope.create("exclusive", DavConstants.NAMESPACE);
    public static final Scope SHARED = Scope.create("shared", DavConstants.NAMESPACE);
    private final String name;
    private final Namespace namespace;

    private Scope(String name, Namespace namespace) {
        this.name = name;
        this.namespace = namespace;
    }

    public Element toXml() {
        return new Element(this.name, this.namespace);
    }

    public static Scope create(Element lockScope) {
        if (lockScope == null) {
            throw new IllegalArgumentException("'null' is not valid lock scope entry.");
        }
        return Scope.create(lockScope.getName(), lockScope.getNamespace());
    }

    public static Scope create(String name, Namespace namespace) {
        String key = "{" + namespace.getURI() + "}" + name;
        if (scopes.containsKey(key)) {
            return (Scope)scopes.get(key);
        }
        Scope scope = new Scope(name, namespace);
        scopes.put(key, scope);
        return scope;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj instanceof Scope) {
            Scope other = (Scope)obj;
            return this.name.equals(other.name) && this.namespace.equals((Object)other.namespace);
        }
        return false;
    }
}

