/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.webdav.ordering;

import java.util.HashMap;
import org.apache.jackrabbit.webdav.ordering.OrderingConstants;
import org.apache.log4j.Logger;
import org.jdom.Element;

public class Position
implements OrderingConstants {
    private static Logger log = Logger.getLogger(Position.class);
    public static final int TYPE_FIRST = 1;
    public static final int TYPE_LAST = 2;
    public static final int TYPE_BEFORE = 4;
    public static final int TYPE_AFTER = 8;
    private static final HashMap xmlTypeMap = new HashMap(4);
    private int type;
    private String segment;

    public Position(String type) {
        if (!"first".equals(type) && !"last".equals(type)) {
            throw new IllegalArgumentException("If type is other than 'first' or 'last' a segment must be specified");
        }
        this.setType(type);
    }

    public Position(Element position) {
        if (position.getChildren().size() != 1) {
            throw new IllegalArgumentException("The 'position' element must contain exactly a single child indicating the type.");
        }
        Element typeElem = (Element)position.getChildren().get(0);
        String type = typeElem.getName();
        String segmentText = null;
        if (typeElem.getChildren().size() > 0) {
            segmentText = typeElem.getChildText("segment");
        }
        this.init(type, segmentText);
    }

    public Position(String type, String segment) {
        this.init(type, segment);
    }

    private void init(String type, String segment) {
        if (("after".equals(type) || "before".equals(type)) && (segment == null || "".equals(segment))) {
            throw new IllegalArgumentException("If type is other than 'first' or 'last' a segment must be specified");
        }
        this.setType(type);
        this.segment = segment;
    }

    public int getType() {
        return this.type;
    }

    private void setType(String xmlType) {
        this.type = (Integer)xmlTypeMap.get(xmlType);
    }

    public String getSegment() {
        return this.segment;
    }

    static {
        xmlTypeMap.put("first", new Integer(1));
        xmlTypeMap.put("last", new Integer(2));
        xmlTypeMap.put("before", new Integer(4));
        xmlTypeMap.put("after", new Integer(8));
    }
}

