/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.webdav.property;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import org.apache.jackrabbit.webdav.property.DavProperty;
import org.apache.jackrabbit.webdav.property.DavPropertyName;
import org.apache.log4j.Logger;
import org.jdom.Content;
import org.jdom.Element;

public abstract class AbstractDavProperty
implements DavProperty {
    private static Logger log = Logger.getLogger(AbstractDavProperty.class);
    private final DavPropertyName name;
    private final boolean isProtected;

    public AbstractDavProperty(DavPropertyName name, boolean isProtected) {
        this.name = name;
        this.isProtected = isProtected;
    }

    public int hashCode() {
        int hashCode = this.getName().hashCode();
        if (this.getValue() != null) {
            hashCode += this.getValue().hashCode();
        }
        return hashCode % Integer.MAX_VALUE;
    }

    public boolean equals(Object obj) {
        if (obj instanceof DavProperty) {
            DavProperty prop = (DavProperty)obj;
            boolean equalName = this.getName().equals(prop.getName());
            boolean equalValue = this.getValue() == null ? prop.getValue() == null : this.getValue().equals(prop.getValue());
            return equalName && equalValue;
        }
        return false;
    }

    public Element toXml() {
        Element elem = this.getName().toXml();
        Object value = this.getValue();
        if (value != null) {
            if (value instanceof Element) {
                elem.addContent((Content)((Element)value));
            } else if (value instanceof Element[]) {
                elem.addContent(Arrays.asList((Element[])value));
            } else if (value instanceof List) {
                elem.addContent((Collection)((List)value));
            } else {
                elem.setText(value.toString());
            }
        }
        return elem;
    }

    public DavPropertyName getName() {
        return this.name;
    }

    public boolean isProtected() {
        return this.isProtected;
    }
}

