/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.webdav.property;

import org.apache.jackrabbit.webdav.property.AbstractDavProperty;
import org.apache.jackrabbit.webdav.property.DavPropertyName;
import org.jdom.Content;
import org.jdom.Element;

public class ResourceType
extends AbstractDavProperty {
    public static final int DEFAULT_RESOURCE = 0;
    public static final int COLLECTION = 1;
    private int resourceType = 0;

    public ResourceType(int resourceType) {
        super(DavPropertyName.RESOURCETYPE, false);
        if (!this.isValidResourceType(resourceType)) {
            throw new IllegalArgumentException("Invalid resource type '" + resourceType + "'.");
        }
        this.resourceType = resourceType;
    }

    public Element toXml() {
        Element elem = this.getName().toXml();
        if (this.getValue() != null) {
            elem.addContent((Content)((Element)this.getValue()));
        }
        return elem;
    }

    public Object getValue() {
        return this.resourceType == 1 ? new Element("collection", NAMESPACE) : null;
    }

    public int getResourceType() {
        return this.resourceType;
    }

    public boolean isValidResourceType(int resourceType) {
        return resourceType >= 0 && resourceType <= 1;
    }
}

