/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.webdav.search;

import org.apache.jackrabbit.webdav.search.SearchConstants;
import org.apache.log4j.Logger;
import org.jdom.Content;
import org.jdom.Document;
import org.jdom.Element;
import org.jdom.Namespace;

public class SearchInfo
implements SearchConstants {
    private static Logger log = Logger.getLogger(SearchInfo.class);
    private final Element languageElem;

    public SearchInfo(String language, Namespace languageNamespace, String query) {
        this.languageElem = new Element(language, languageNamespace).setText(query);
    }

    public SearchInfo(Document searchDocument) {
        Element searchRequest = searchDocument.getRootElement();
        if (searchRequest == null || !"searchrequest".equals(searchRequest.getName())) {
            throw new IllegalArgumentException("The root element must be 'searchrequest'.");
        }
        if (searchRequest.getChildren().size() != 1) {
            throw new IllegalArgumentException("A single child element is expected with the 'searchrequest'.");
        }
        Element child = (Element)searchRequest.getChildren().get(0);
        this.languageElem = (Element)child.detach();
    }

    public String getLanguageName() {
        return this.languageElem.getName();
    }

    public Namespace getLanguageNameSpace() {
        return this.languageElem.getNamespace();
    }

    public String getQuery() {
        return this.languageElem.getText();
    }

    public Document toXml() {
        Element sRequestElem = new Element("searchrequest", NAMESPACE);
        sRequestElem.addContent((Content)this.languageElem);
        return new Document(sRequestElem);
    }
}

