/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.webdav.version;

import org.apache.jackrabbit.webdav.DavConstants;
import org.apache.jackrabbit.webdav.property.DavPropertyNameSet;
import org.apache.jackrabbit.webdav.version.DeltaVConstants;
import org.apache.log4j.Logger;
import org.jdom.Element;

public class MergeInfo
implements DeltaVConstants {
    private static Logger log = Logger.getLogger(MergeInfo.class);
    private Element mergeElement;

    public MergeInfo(Element mergeElement) {
        if (mergeElement == null || !mergeElement.getName().equals("merge")) {
            throw new IllegalArgumentException("'DAV:merge' element expected");
        }
        this.mergeElement = (Element)mergeElement.detach();
    }

    public String getSourceHref() {
        Element source = this.mergeElement.getChild("source", DavConstants.NAMESPACE);
        if (source != null) {
            return source.getChildText("href", DavConstants.NAMESPACE);
        }
        return null;
    }

    public boolean isNoAutoMerge() {
        return this.mergeElement.getChild("no-auto-merge", NAMESPACE) != null;
    }

    public boolean isNoCheckout() {
        return this.mergeElement.getChild("no-checkout", NAMESPACE) != null;
    }

    public DavPropertyNameSet getPropertyNameSet() {
        Element propElement = this.mergeElement.getChild("prop", DavConstants.NAMESPACE);
        if (propElement != null) {
            return new DavPropertyNameSet(propElement);
        }
        return new DavPropertyNameSet();
    }

    public Element getMergeElement() {
        return this.mergeElement;
    }
}

