/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.webdav.version;

import java.util.Iterator;
import java.util.List;
import org.apache.jackrabbit.webdav.DavConstants;
import org.apache.jackrabbit.webdav.property.DavPropertyNameSet;
import org.apache.jackrabbit.webdav.version.DeltaVConstants;
import org.apache.log4j.Logger;
import org.jdom.Element;

public class UpdateInfo
implements DeltaVConstants {
    private static Logger log = Logger.getLogger(UpdateInfo.class);
    private final Element updateElement;
    private String[] versionHref;
    private String[] labelName;
    private String workspaceHref;

    public UpdateInfo(Element updateElement) {
        if (updateElement == null || !updateElement.getName().equals("update")) {
            throw new IllegalArgumentException("DAV:update element expected");
        }
        List targetList = updateElement.getChildren("version", NAMESPACE);
        if (!targetList.isEmpty()) {
            Iterator it = targetList.iterator();
            this.versionHref = new String[targetList.size()];
            int i = 0;
            while (it.hasNext()) {
                Element versionElem = (Element)it.next();
                this.versionHref[i] = versionElem.getChildText("href", NAMESPACE);
                ++i;
            }
        } else {
            targetList = updateElement.getChildren("label-name", NAMESPACE);
            if (!targetList.isEmpty()) {
                Iterator it = targetList.iterator();
                this.labelName = new String[targetList.size()];
                int i = 0;
                while (it.hasNext()) {
                    Element labelNameElem = (Element)it.next();
                    this.labelName[i] = labelNameElem.getText();
                    ++i;
                }
            } else if (updateElement.getChild("workspace", NAMESPACE) != null) {
                this.workspaceHref = updateElement.getChild("workspace", NAMESPACE).getChildText("href", NAMESPACE);
            } else {
                throw new IllegalArgumentException("DAV:update element must contain either DAV:version, DAV:label-name or DAV:workspace child element.");
            }
        }
        this.updateElement = (Element)updateElement.detach();
    }

    public String[] getVersionHref() {
        return this.versionHref;
    }

    public String[] getLabelName() {
        return this.labelName;
    }

    public String getWorkspaceHref() {
        return this.workspaceHref;
    }

    public DavPropertyNameSet getPropertyNameSet() {
        Element propElement = this.updateElement.getChild("prop", DavConstants.NAMESPACE);
        if (propElement != null) {
            return new DavPropertyNameSet(propElement);
        }
        return new DavPropertyNameSet();
    }

    public Element getUpdateElement() {
        return this.updateElement;
    }
}

