/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.webdav.version.report;

import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import org.apache.jackrabbit.webdav.DavConstants;
import org.apache.jackrabbit.webdav.DavException;
import org.apache.jackrabbit.webdav.DavResource;
import org.apache.jackrabbit.webdav.DavResourceIterator;
import org.apache.jackrabbit.webdav.MultiStatus;
import org.apache.jackrabbit.webdav.property.DavPropertyNameSet;
import org.apache.jackrabbit.webdav.version.DeltaVConstants;
import org.apache.jackrabbit.webdav.version.DeltaVResource;
import org.apache.jackrabbit.webdav.version.VersionControlledResource;
import org.apache.jackrabbit.webdav.version.VersionHistoryResource;
import org.apache.jackrabbit.webdav.version.report.Report;
import org.apache.jackrabbit.webdav.version.report.ReportInfo;
import org.apache.jackrabbit.webdav.version.report.ReportType;
import org.apache.log4j.Logger;
import org.jdom.Document;
import org.jdom.Element;

public class LocateByHistoryReport
implements Report,
DeltaVConstants {
    private static Logger log = Logger.getLogger(LocateByHistoryReport.class);
    private ReportInfo info;
    private HashSet vhHrefSet = new HashSet();
    private DeltaVResource resource;

    public ReportType getType() {
        return ReportType.LOCATE_BY_HISTORY;
    }

    public void setResource(DeltaVResource resource) throws IllegalArgumentException {
        if (!(resource instanceof VersionControlledResource)) {
            throw new IllegalArgumentException("DAV:version-tree report can only be created for version-controlled resources and version resources.");
        }
        this.resource = resource;
    }

    public void setInfo(ReportInfo info) throws IllegalArgumentException {
        if (info == null || !"locate-by-history".equals(info.getReportElement().getName())) {
            throw new IllegalArgumentException("DAV:locate-by-history element expected.");
        }
        Element versionHistorySet = info.getReportElement().getChild("version-history-set", NAMESPACE);
        if (versionHistorySet == null) {
            throw new IllegalArgumentException("The DAV:locate-by-history element must contain a DAV:version-history-set child.");
        }
        List l = versionHistorySet.getChildren("href", DavConstants.NAMESPACE);
        if (l != null && !l.isEmpty()) {
            Iterator it = l.iterator();
            while (it.hasNext()) {
                String href = ((Element)it.next()).getText();
                if (href == null) continue;
                this.vhHrefSet.add(href);
            }
        }
        this.info = info;
    }

    public Document toXml() throws DavException {
        if (this.info == null || this.resource == null) {
            throw new DavException(500, "Error while running DAV:locate-by-history report");
        }
        MultiStatus ms = new MultiStatus();
        this.buildResponse(this.resource, this.info.getPropertyNameSet(), this.info.getDepth(), ms);
        return ms.toXml();
    }

    private void buildResponse(DavResource res, DavPropertyNameSet propNameSet, int depth, MultiStatus ms) throws DavException {
        DavResourceIterator it = res.getMembers();
        while (!this.vhHrefSet.isEmpty() && it.hasNext()) {
            DavResource childRes = it.nextResource();
            if (childRes instanceof VersionControlledResource) {
                try {
                    VersionHistoryResource vhr = ((VersionControlledResource)childRes).getVersionHistory();
                    if (this.vhHrefSet.remove(vhr.getHref())) {
                        if (propNameSet.isEmpty()) {
                            ms.addResourceStatus(childRes, 200, 0);
                        } else {
                            ms.addResourceProperties(childRes, propNameSet, 0);
                        }
                    }
                }
                catch (DavException e) {
                    log.info((Object)e.getMessage());
                }
            }
            if (depth <= 0) continue;
            this.buildResponse(it.nextResource(), propNameSet, depth - 1, ms);
        }
    }
}

