/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.webdav.version.report;

import java.util.HashSet;
import java.util.Iterator;
import org.apache.jackrabbit.webdav.property.AbstractDavProperty;
import org.apache.jackrabbit.webdav.version.DeltaVConstants;
import org.apache.jackrabbit.webdav.version.report.ReportInfo;
import org.apache.jackrabbit.webdav.version.report.ReportType;
import org.apache.log4j.Logger;
import org.jdom.Content;
import org.jdom.Element;

public class SupportedReportSetProperty
extends AbstractDavProperty {
    private static Logger log = Logger.getLogger(SupportedReportSetProperty.class);
    private final HashSet reportTypes = new HashSet();

    public SupportedReportSetProperty() {
        super(DeltaVConstants.SUPPORTED_REPORT_SET, true);
    }

    public SupportedReportSetProperty(ReportType[] reportTypes) {
        super(DeltaVConstants.SUPPORTED_REPORT_SET, true);
        for (int i = 0; i < reportTypes.length; ++i) {
            this.addReportType(reportTypes[i]);
        }
    }

    public void addReportType(ReportType reportType) {
        this.reportTypes.add(reportType);
    }

    public boolean isSupportedReport(ReportInfo reqInfo) {
        for (ReportType rt : this.reportTypes) {
            if (!rt.isRequestedReportType(reqInfo)) continue;
            return true;
        }
        return false;
    }

    public Element toXml() {
        Element elem = this.getName().toXml();
        Iterator it = this.reportTypes.iterator();
        while (it.hasNext()) {
            Element sr = new Element("supported-report", DeltaVConstants.NAMESPACE);
            Element r = new Element("report", DeltaVConstants.NAMESPACE);
            elem.addContent((Content)sr.addContent((Content)r.addContent((Content)((ReportType)it.next()).toXml())));
        }
        return elem;
    }

    public Object getValue() {
        return this.reportTypes;
    }
}

