/*
 * Decompiled with CFR 0.152.
 */
package org.enhydra.jdbc.standard;

import java.sql.CallableStatement;
import java.sql.SQLException;
import org.enhydra.jdbc.core.CoreCallableStatement;
import org.enhydra.jdbc.standard.StandardXAConnectionHandle;

public class StandardXACallableStatement
extends CoreCallableStatement {
    private StandardXAConnectionHandle con;
    private boolean closed;
    private String sql;
    private int resultSetType;
    private int resultSetConcurrency;

    StandardXACallableStatement(StandardXAConnectionHandle con, String sql, int resultSetType, int resultSetConcurrency) throws SQLException {
        this.con = con;
        this.sql = sql;
        this.resultSetType = resultSetType;
        this.resultSetConcurrency = resultSetConcurrency;
        this.log = con.log;
    }

    private CallableStatement newStatement() throws SQLException {
        if (this.resultSetType == 0 && this.resultSetConcurrency == 0) {
            return this.con.con.prepareCall(this.sql);
        }
        return this.con.con.prepareCall(this.sql, this.resultSetType, this.resultSetConcurrency);
    }

    public synchronized void close() throws SQLException {
        super.close();
        this.closed = true;
    }

    public synchronized void preInvoke() throws SQLException {
        if (this.closed) {
            throw new SQLException("Prepare Statement is closed");
        }
        if (this.cs == null) {
            this.cs = this.newStatement();
        }
    }

    public void catchInvoke(SQLException sqlException) throws SQLException {
        throw sqlException;
    }
}

