/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jmeter;

import java.io.File;
import java.io.FilenameFilter;
import java.io.IOException;
import java.lang.reflect.Method;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.LinkedList;
import java.util.StringTokenizer;
import org.apache.jmeter.DynamicClassLoader;

public final class NewDriver {
    private static DynamicClassLoader loader;
    private static String jmDir;

    private NewDriver() {
    }

    public static void addURL(String url) {
        File furl = new File(url);
        try {
            loader.addURL(furl.toURL());
        }
        catch (MalformedURLException e) {
            e.printStackTrace();
        }
    }

    public static void addURL(URL url) {
        loader.addURL(url);
    }

    public static String getJMeterDir() {
        return jmDir;
    }

    public static void main(String[] args) {
        Thread.currentThread().setContextClassLoader(loader);
        if (System.getProperty("log4j.configuration") == null) {
            File conf = new File(jmDir, "bin" + File.separator + "log4j.conf");
            System.setProperty("log4j.configuration", "file:" + conf);
        }
        try {
            Class<?> JMeter2 = loader.loadClass("org.apache.jmeter.JMeter");
            Object instance = JMeter2.newInstance();
            Method startup = JMeter2.getMethod("start", new String[0].getClass());
            startup.invoke(instance, new Object[]{args});
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    static {
        LinkedList<URL> jars = new LinkedList<URL>();
        String cp = System.getProperty("java.class.path");
        StringTokenizer tok = new StringTokenizer(cp, File.pathSeparator);
        if (tok.countTokens() == 1) {
            File jar = new File(tok.nextToken());
            try {
                jmDir = jar.getCanonicalFile().getParentFile().getParent();
            }
            catch (IOException e) {}
        } else {
            File userDir = new File(System.getProperty("user.dir"));
            jmDir = userDir.getAbsoluteFile().getParent();
        }
        boolean usesUNC = System.getProperty("os.name").startsWith("Windows");
        StringBuffer classpath = new StringBuffer();
        File[] libDirs = new File[]{new File(jmDir + File.separator + "lib"), new File(jmDir + File.separator + "lib" + File.separator + "ext"), new File(jmDir + File.separator + "lib" + File.separator + "junit")};
        for (int a = 0; a < libDirs.length; ++a) {
            File[] libJars = libDirs[a].listFiles(new FilenameFilter(){

                public boolean accept(File dir, String name) {
                    return name.endsWith(".jar");
                }
            });
            if (libJars == null) {
                new Throwable("Could not access " + libDirs[a]).printStackTrace();
                continue;
            }
            for (int i = 0; i < libJars.length; ++i) {
                try {
                    String s = libJars[i].getPath();
                    if (usesUNC) {
                        if (s.startsWith("\\\\") && !s.startsWith("\\\\\\")) {
                            s = "\\\\" + s;
                        } else if (s.startsWith("//") && !s.startsWith("///")) {
                            s = "//" + s;
                        }
                    }
                    jars.add(new URL("file", "", s));
                    classpath.append(System.getProperty("path.separator"));
                    classpath.append(s);
                    continue;
                }
                catch (MalformedURLException e) {
                    e.printStackTrace();
                }
            }
        }
        System.setProperty("java.class.path", System.getProperty("java.class.path") + classpath.toString());
        loader = new DynamicClassLoader(jars.toArray(new URL[0]));
    }
}

