/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jmeter.config.gui;

import java.awt.BorderLayout;
import java.awt.Component;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JPasswordField;
import javax.swing.JTextField;
import org.apache.jmeter.config.ConfigTestElement;
import org.apache.jmeter.config.gui.AbstractConfigGui;
import org.apache.jmeter.gui.util.VerticalPanel;
import org.apache.jmeter.testelement.TestElement;
import org.apache.jmeter.testelement.property.StringProperty;
import org.apache.jmeter.util.JMeterUtils;

public class LoginConfigGui
extends AbstractConfigGui {
    private JTextField username = new JTextField(15);
    private JPasswordField password = new JPasswordField(15);
    private boolean displayName = true;

    public LoginConfigGui() {
        this(true);
    }

    public LoginConfigGui(boolean displayName) {
        this.displayName = displayName;
        this.init();
    }

    public String getLabelResource() {
        return "login_config_element";
    }

    public void configure(TestElement element) {
        super.configure(element);
        this.username.setText(element.getPropertyAsString("ConfigTestElement.username"));
        this.password.setText(element.getPropertyAsString("ConfigTestElement.password"));
    }

    public TestElement createTestElement() {
        ConfigTestElement element = new ConfigTestElement();
        this.modifyTestElement(element);
        return element;
    }

    public void modifyTestElement(TestElement element) {
        this.configureTestElement(element);
        element.setProperty(new StringProperty("ConfigTestElement.username", this.username.getText()));
        String passwordString = new String(this.password.getPassword());
        element.setProperty(new StringProperty("ConfigTestElement.password", passwordString));
    }

    private void init() {
        this.setLayout(new BorderLayout(0, 5));
        if (this.displayName) {
            this.setBorder(this.makeBorder());
            this.add((Component)this.makeTitlePanel(), "North");
        }
        VerticalPanel mainPanel = new VerticalPanel();
        mainPanel.add(this.createUsernamePanel());
        mainPanel.add(this.createPasswordPanel());
        this.add((Component)mainPanel, "Center");
    }

    private JPanel createUsernamePanel() {
        JPanel panel = new JPanel(new BorderLayout(5, 0));
        JLabel label = new JLabel(JMeterUtils.getResString("username"));
        label.setLabelFor(this.username);
        panel.add((Component)label, "West");
        panel.add((Component)this.username, "Center");
        return panel;
    }

    private JPanel createPasswordPanel() {
        JPanel panel = new JPanel(new BorderLayout(5, 0));
        JLabel label = new JLabel(JMeterUtils.getResString("password"));
        label.setLabelFor(this.password);
        panel.add((Component)label, "West");
        panel.add((Component)this.password, "Center");
        return panel;
    }
}

