/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jmeter.control;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import org.apache.jmeter.control.Controller;
import org.apache.jmeter.control.NextIsNullException;
import org.apache.jmeter.engine.event.LoopIterationEvent;
import org.apache.jmeter.engine.event.LoopIterationListener;
import org.apache.jmeter.junit.JMeterTestCase;
import org.apache.jmeter.junit.stubs.TestSampler;
import org.apache.jmeter.samplers.Sampler;
import org.apache.jmeter.testelement.AbstractTestElement;
import org.apache.jmeter.testelement.TestElement;
import org.apache.jorphan.logging.LoggingManager;
import org.apache.log.Logger;

public class GenericController
extends AbstractTestElement
implements Controller,
Serializable {
    private static final Logger log = LoggingManager.getLoggerForClass();
    protected transient LinkedList iterationListeners = new LinkedList();
    protected transient List subControllersAndSamplers = new ArrayList();
    protected transient int current;
    private transient int iterCount;
    private transient boolean done;
    private transient boolean first;

    public void initialize() {
        this.resetCurrent();
        this.resetIterCount();
        this.done = false;
        this.first = true;
        for (int i = 0; i < this.subControllersAndSamplers.size(); ++i) {
            TestElement elem = (TestElement)this.subControllersAndSamplers.get(i);
            if (!(elem instanceof Controller)) continue;
            ((Controller)elem).initialize();
        }
    }

    protected void reInitialize() {
        this.resetCurrent();
        this.incrementIterCount();
        this.setFirst(true);
        this.recoverRunningVersion();
    }

    public Sampler next() {
        this.fireIterEvents();
        log.debug("Calling next on: " + this.getClass().getName());
        if (this.isDone()) {
            return null;
        }
        Sampler returnValue = null;
        TestElement currentElement = null;
        try {
            currentElement = this.getCurrentElement();
            this.setCurrentElement(currentElement);
            returnValue = currentElement == null ? this.nextIsNull() : (currentElement instanceof Sampler ? this.nextIsASampler((Sampler)currentElement) : this.nextIsAController((Controller)currentElement));
        }
        catch (NextIsNullException e) {
            returnValue = null;
        }
        return returnValue;
    }

    public boolean isDone() {
        return this.done;
    }

    protected void setDone(boolean done) {
        this.done = done;
    }

    protected boolean isFirst() {
        return this.first;
    }

    public void setFirst(boolean b) {
        this.first = b;
    }

    protected Sampler nextIsAController(Controller controller) throws NextIsNullException {
        Sampler returnValue;
        Sampler sampler = controller.next();
        if (sampler == null) {
            this.currentReturnedNull(controller);
            returnValue = this.next();
        } else {
            returnValue = sampler;
        }
        return returnValue;
    }

    protected Sampler nextIsASampler(Sampler element) throws NextIsNullException {
        this.incrementCurrent();
        return element;
    }

    protected Sampler nextIsNull() throws NextIsNullException {
        this.reInitialize();
        return null;
    }

    protected void currentReturnedNull(Controller c) {
        if (c.isDone()) {
            this.removeCurrentElement();
        } else {
            this.incrementCurrent();
        }
    }

    protected List getSubControllers() {
        return this.subControllersAndSamplers;
    }

    private void addElement(TestElement child) {
        this.subControllersAndSamplers.add(child);
    }

    protected void setCurrentElement(TestElement currentElement) throws NextIsNullException {
    }

    protected TestElement getCurrentElement() throws NextIsNullException {
        if (this.current < this.subControllersAndSamplers.size()) {
            return (TestElement)this.subControllersAndSamplers.get(this.current);
        }
        if (this.subControllersAndSamplers.size() == 0) {
            this.setDone(true);
            throw new NextIsNullException();
        }
        return null;
    }

    protected void removeCurrentElement() {
        this.subControllersAndSamplers.remove(this.current);
    }

    protected void incrementCurrent() {
        ++this.current;
    }

    protected void resetCurrent() {
        this.current = 0;
    }

    public void addTestElement(TestElement child) {
        if (child instanceof Controller || child instanceof Sampler) {
            this.addElement(child);
        }
    }

    public void addIterationListener(LoopIterationListener lis) {
        this.iterationListeners.addFirst(lis);
    }

    protected void fireIterEvents() {
        if (this.isFirst()) {
            this.fireIterationStart();
            this.first = false;
        }
    }

    protected void fireIterationStart() {
        Iterator iter = this.iterationListeners.iterator();
        LoopIterationEvent event = new LoopIterationEvent(this, this.getIterCount());
        while (iter.hasNext()) {
            LoopIterationListener item = (LoopIterationListener)iter.next();
            item.iterationStart(event);
        }
    }

    protected int getIterCount() {
        return this.iterCount;
    }

    protected void incrementIterCount() {
        ++this.iterCount;
    }

    protected void resetIterCount() {
        this.iterCount = 0;
    }

    public static class Test
    extends JMeterTestCase {
        public Test(String name) {
            super(name);
        }

        public void testProcessing() throws Exception {
            testLog.debug("Testing Generic Controller");
            GenericController controller = new GenericController();
            GenericController sub_1 = new GenericController();
            sub_1.addTestElement(new TestSampler("one"));
            sub_1.addTestElement(new TestSampler("two"));
            controller.addTestElement(sub_1);
            controller.addTestElement(new TestSampler("three"));
            GenericController sub_2 = new GenericController();
            GenericController sub_3 = new GenericController();
            sub_2.addTestElement(new TestSampler("four"));
            sub_3.addTestElement(new TestSampler("five"));
            sub_3.addTestElement(new TestSampler("six"));
            sub_2.addTestElement(sub_3);
            sub_2.addTestElement(new TestSampler("seven"));
            controller.addTestElement(sub_2);
            String[] order = new String[]{"one", "two", "three", "four", "five", "six", "seven"};
            int counter = 7;
            controller.initialize();
            for (int i = 0; i < 2; ++i) {
                Test.assertEquals((int)7, (int)counter);
                counter = 0;
                Sampler sampler = null;
                while ((sampler = controller.next()) != null) {
                    Test.assertEquals((String)order[counter++], (String)sampler.getPropertyAsString("TestElement.name"));
                }
            }
        }
    }
}

