/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jmeter.control;

import java.io.Serializable;
import org.apache.jmeter.control.GenericController;
import org.apache.jmeter.control.NextIsNullException;
import org.apache.jmeter.junit.JMeterTestCase;
import org.apache.jmeter.samplers.Sampler;
import org.apache.jmeter.testelement.property.StringProperty;
import org.apache.jorphan.logging.LoggingManager;
import org.apache.log.Logger;
import org.mozilla.javascript.Context;
import org.mozilla.javascript.Scriptable;

public class IfController
extends GenericController
implements Serializable {
    private static Logger logger = LoggingManager.getLoggerForClass();
    private static final String CONDITION = "IfController.condition";

    public IfController() {
    }

    public IfController(String condition) {
        this.setCondition(condition);
    }

    public void setCondition(String condition) {
        this.setProperty(new StringProperty(CONDITION, condition));
    }

    public String getCondition() {
        return this.getPropertyAsString(CONDITION);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static boolean evaluateCondition(String cond) {
        logger.debug("    getCondition() : [" + cond + "]");
        String resultStr = "";
        boolean result = false;
        Context cx = Context.enter();
        try {
            Scriptable scope = cx.initStandardObjects(null);
            Object cxResultObject = cx.evaluateString(scope, cond, "<cmd>", 1, null);
            resultStr = Context.toString((Object)cxResultObject);
            if (resultStr.equals("false")) {
                result = false;
            } else if (resultStr.equals("true")) {
                result = true;
            } else {
                throw new Exception(" BAD CONDITION :: " + cond);
            }
            logger.debug("    >> evaluate Condition -  [ " + cond + "] results is  [" + result + "]");
        }
        catch (Exception e) {
            logger.error(e.getMessage(), (Throwable)e);
        }
        finally {
            Context.exit();
        }
        return result;
    }

    public boolean isDone() {
        return false;
    }

    public Sampler next() {
        boolean result = IfController.evaluateCondition(this.getCondition());
        if (result) {
            return super.next();
        }
        try {
            return this.nextIsNull();
        }
        catch (NextIsNullException e1) {
            return null;
        }
    }

    public static class Test
    extends JMeterTestCase {
        public Test(String name) {
            super(name);
        }

        public void testProcessing() throws Exception {
            GenericController controller = new GenericController();
            controller.addTestElement(new IfController("false==false"));
            controller.addTestElement(new IfController(" \"a\".equals(\"a\")"));
            controller.addTestElement(new IfController("2<100"));
            logger.debug(">>>>>   testProcessing : Starting the iteration  ");
            Sampler sampler = null;
            while ((sampler = controller.next()) != null) {
                logger.debug("    ->>>  Gonna assertTrue :" + sampler.getClass().getName() + " Property is   ---->>>" + sampler.getPropertyAsString("TestElement.name"));
            }
        }
    }
}

