/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jmeter.control;

import java.io.Serializable;
import org.apache.jmeter.control.GenericController;
import org.apache.jmeter.control.NextIsNullException;
import org.apache.jmeter.junit.JMeterTestCase;
import org.apache.jmeter.junit.stubs.TestSampler;
import org.apache.jmeter.samplers.Sampler;
import org.apache.jmeter.testelement.property.BooleanProperty;
import org.apache.jmeter.testelement.property.IntegerProperty;
import org.apache.jmeter.testelement.property.JMeterProperty;
import org.apache.jmeter.testelement.property.StringProperty;

public class LoopController
extends GenericController
implements Serializable {
    private static final String LOOPS = "LoopController.loops";
    private static final String CONTINUE_FOREVER = "LoopController.continue_forever";
    private transient int loopCount = 0;

    public LoopController() {
        this.setContinueForever(true);
    }

    public void setLoops(int loops) {
        this.setProperty(new IntegerProperty(LOOPS, loops));
    }

    public void setLoops(String loopValue) {
        this.setProperty(new StringProperty(LOOPS, loopValue));
    }

    public int getLoops() {
        try {
            JMeterProperty prop = this.getProperty(LOOPS);
            return Integer.parseInt(prop.getStringValue());
        }
        catch (NumberFormatException e) {
            return 0;
        }
    }

    public String getLoopString() {
        return this.getPropertyAsString(LOOPS);
    }

    public void setContinueForever(boolean forever) {
        this.setProperty(new BooleanProperty(CONTINUE_FOREVER, forever));
    }

    public boolean getContinueForever() {
        return this.getPropertyAsBoolean(CONTINUE_FOREVER);
    }

    public boolean isDone() {
        if (this.getLoops() != 0) {
            return super.isDone();
        }
        return true;
    }

    private boolean endOfLoop() {
        return this.getLoops() > -1 && this.loopCount >= this.getLoops();
    }

    protected Sampler nextIsNull() throws NextIsNullException {
        this.reInitialize();
        if (this.endOfLoop()) {
            if (!this.getContinueForever()) {
                this.setDone(true);
            } else {
                this.resetLoopCount();
            }
            return null;
        }
        return this.next();
    }

    protected void incrementLoopCount() {
        ++this.loopCount;
    }

    protected void resetLoopCount() {
        this.loopCount = 0;
    }

    protected int getIterCount() {
        return this.loopCount + 1;
    }

    protected void reInitialize() {
        this.setFirst(true);
        this.resetCurrent();
        this.incrementLoopCount();
        this.recoverRunningVersion();
    }

    public static class Test
    extends JMeterTestCase {
        public Test(String name) {
            super(name);
        }

        public void testProcessing() throws Exception {
            GenericController controller = new GenericController();
            GenericController sub_1 = new GenericController();
            sub_1.addTestElement(new TestSampler("one"));
            sub_1.addTestElement(new TestSampler("two"));
            controller.addTestElement(sub_1);
            controller.addTestElement(new TestSampler("three"));
            LoopController sub_2 = new LoopController();
            sub_2.setLoops(3);
            GenericController sub_3 = new GenericController();
            sub_2.addTestElement(new TestSampler("four"));
            sub_3.addTestElement(new TestSampler("five"));
            sub_3.addTestElement(new TestSampler("six"));
            sub_2.addTestElement(sub_3);
            sub_2.addTestElement(new TestSampler("seven"));
            controller.addTestElement(sub_2);
            String[] order = new String[]{"one", "two", "three", "four", "five", "six", "seven", "four", "five", "six", "seven", "four", "five", "six", "seven"};
            int counter = 15;
            controller.setRunningVersion(true);
            sub_1.setRunningVersion(true);
            sub_2.setRunningVersion(true);
            sub_3.setRunningVersion(true);
            controller.initialize();
            for (int i = 0; i < 2; ++i) {
                Test.assertEquals((int)15, (int)counter);
                counter = 0;
                Sampler sampler = null;
                while ((sampler = controller.next()) != null) {
                    Test.assertEquals((String)order[counter++], (String)sampler.getPropertyAsString("TestElement.name"));
                }
            }
        }

        public void testLoopZeroTimes() throws Exception {
            LoopController loop = new LoopController();
            loop.setLoops(0);
            loop.addTestElement(new TestSampler("never run"));
            loop.initialize();
            Test.assertNull((Object)loop.next());
        }

        public void testInfiniteLoop() throws Exception {
            LoopController loop = new LoopController();
            loop.setLoops(-1);
            loop.addTestElement(new TestSampler("never run"));
            loop.setRunningVersion(true);
            loop.initialize();
            for (int i = 0; i < 42; ++i) {
                Test.assertNotNull((Object)loop.next());
            }
        }
    }
}

