/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jmeter.control;

import java.io.Serializable;
import org.apache.jmeter.control.GenericController;
import org.apache.jmeter.control.LoopController;
import org.apache.jmeter.control.NextIsNullException;
import org.apache.jmeter.junit.JMeterTestCase;
import org.apache.jmeter.junit.stubs.TestSampler;
import org.apache.jmeter.samplers.Sampler;
import org.apache.jmeter.testelement.property.LongProperty;
import org.apache.jmeter.testelement.property.StringProperty;

public class RunTime
extends GenericController
implements Serializable {
    private static final String SECONDS = "RunTime.seconds";
    private volatile long startTime = 0L;
    private int loopCount = 0;

    public void setRuntime(long seconds) {
        this.setProperty(new LongProperty(SECONDS, seconds));
    }

    public void setRuntime(String seconds) {
        this.setProperty(new StringProperty(SECONDS, seconds));
    }

    public long getRuntime() {
        try {
            return Long.parseLong(this.getPropertyAsString(SECONDS));
        }
        catch (NumberFormatException e) {
            return 0L;
        }
    }

    public String getRuntimeString() {
        return this.getPropertyAsString(SECONDS);
    }

    public boolean isDone() {
        if (this.getRuntime() > 0L && this.getSubControllers().size() > 0) {
            return super.isDone();
        }
        return true;
    }

    private boolean endOfLoop() {
        return System.currentTimeMillis() - this.startTime >= 1000L * this.getRuntime();
    }

    public Sampler next() {
        if (this.startTime == 0L) {
            this.startTime = System.currentTimeMillis();
        }
        if (this.endOfLoop()) {
            this.reInitialize();
            this.resetLoopCount();
            return null;
        }
        return super.next();
    }

    protected Sampler nextIsNull() throws NextIsNullException {
        this.reInitialize();
        if (this.endOfLoop()) {
            this.resetLoopCount();
            return null;
        }
        return this.next();
    }

    protected void incrementLoopCount() {
        ++this.loopCount;
    }

    protected void resetLoopCount() {
        this.loopCount = 0;
        this.startTime = 0L;
    }

    protected int getIterCount() {
        return this.loopCount + 1;
    }

    protected void reInitialize() {
        this.setFirst(true);
        this.resetCurrent();
        this.incrementLoopCount();
        this.recoverRunningVersion();
    }

    public static class Test
    extends JMeterTestCase {
        public Test(String name) {
            super(name);
        }

        public void testProcessing() throws Exception {
            RunTime controller = new RunTime();
            controller.setRuntime(10L);
            TestSampler samp1 = new TestSampler("Sample 1", 500L);
            TestSampler samp2 = new TestSampler("Sample 2", 500L);
            LoopController sub1 = new LoopController();
            sub1.setLoops(2);
            sub1.setContinueForever(false);
            sub1.addTestElement(samp1);
            LoopController sub2 = new LoopController();
            sub2.setLoops(40);
            sub2.setContinueForever(false);
            sub2.addTestElement(samp2);
            controller.addTestElement(sub1);
            controller.addTestElement(sub2);
            controller.setRunningVersion(true);
            sub1.setRunningVersion(true);
            sub2.setRunningVersion(true);
            controller.initialize();
            Sampler sampler = null;
            int loops = 0;
            long now = System.currentTimeMillis();
            while ((sampler = controller.next()) != null) {
                ++loops;
                sampler.sample(null);
            }
            long elapsed = System.currentTimeMillis() - now;
            Test.assertTrue((String)"Should be at least 20 loops", (loops >= 20 ? 1 : 0) != 0);
            Test.assertTrue((String)"Should be fewer than 30 loops", (loops < 30 ? 1 : 0) != 0);
            Test.assertTrue((String)"Should take at least 10 seconds", (elapsed >= 10000L ? 1 : 0) != 0);
            Test.assertTrue((String)"Should take less than 12 seconds", (elapsed <= 12000L ? 1 : 0) != 0);
            Test.assertEquals((String)"Sampler 1 should run 2 times", (long)2L, (long)samp1.getSamples());
            Test.assertTrue((String)"Sampler 2 should run >= 18 times", (samp2.getSamples() >= 18L ? 1 : 0) != 0);
        }
    }
}

