/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jmeter.control.gui;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.Box;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import org.apache.jmeter.control.IfController;
import org.apache.jmeter.control.gui.AbstractControllerGui;
import org.apache.jmeter.gui.util.FocusRequester;
import org.apache.jmeter.testelement.TestElement;
import org.apache.jmeter.util.JMeterUtils;

public class IfControllerPanel
extends AbstractControllerGui
implements ActionListener {
    private static final String CONDITION_LABEL = "if_controller_label";
    private JTextField theCondition;
    private boolean displayName = true;
    private static final String CONDITION = "JS_Condition";

    public IfControllerPanel() {
        this(true);
    }

    public IfControllerPanel(boolean displayName) {
        this.displayName = displayName;
        this.init();
    }

    public void configure(TestElement element) {
        super.configure(element);
        if (element instanceof IfController) {
            this.theCondition.setText(((IfController)element).getCondition());
        }
    }

    public TestElement createTestElement() {
        IfController controller = new IfController();
        this.modifyTestElement(controller);
        return controller;
    }

    public void modifyTestElement(TestElement controller) {
        this.configureTestElement(controller);
        if (controller instanceof IfController) {
            if (this.theCondition.getText().length() > 0) {
                ((IfController)controller).setCondition(this.theCondition.getText());
            } else {
                ((IfController)controller).setCondition("");
            }
        }
    }

    public void actionPerformed(ActionEvent event) {
        new FocusRequester(this.theCondition);
    }

    public String getLabelResource() {
        return "if_controller_title";
    }

    private void init() {
        if (this.displayName) {
            this.setLayout(new BorderLayout(0, 5));
            this.setBorder(this.makeBorder());
            this.add((Component)this.makeTitlePanel(), "North");
            JPanel mainPanel = new JPanel(new BorderLayout());
            mainPanel.add((Component)this.createConditionPanel(), "North");
            this.add((Component)mainPanel, "Center");
        } else {
            this.setLayout(new BorderLayout());
            this.add((Component)this.createConditionPanel(), "North");
        }
    }

    private JPanel createConditionPanel() {
        JPanel conditionPanel = new JPanel(new BorderLayout(5, 0));
        JLabel conditionLabel = new JLabel(JMeterUtils.getResString(CONDITION_LABEL));
        conditionPanel.add((Component)conditionLabel, "West");
        this.theCondition = new JTextField("");
        this.theCondition.setName(CONDITION);
        conditionLabel.setLabelFor(this.theCondition);
        conditionPanel.add((Component)this.theCondition, "Center");
        this.theCondition.addActionListener(this);
        conditionPanel.add(Box.createHorizontalStrut(conditionLabel.getPreferredSize().width + this.theCondition.getPreferredSize().width), "North");
        return conditionPanel;
    }
}

