/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jmeter.control.gui;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.Box;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import org.apache.jmeter.control.WhileController;
import org.apache.jmeter.control.gui.AbstractControllerGui;
import org.apache.jmeter.gui.util.FocusRequester;
import org.apache.jmeter.testelement.TestElement;
import org.apache.jmeter.util.JMeterUtils;

public class WhileControllerGui
extends AbstractControllerGui
implements ActionListener {
    private static final String CONDITION_LABEL = "while_controller_label";
    private JTextField theCondition;
    private static final String CONDITION = "While_Condition";

    public WhileControllerGui() {
        this.init();
    }

    public void configure(TestElement element) {
        super.configure(element);
        if (element instanceof WhileController) {
            this.theCondition.setText(((WhileController)element).getCondition());
        }
    }

    public TestElement createTestElement() {
        WhileController controller = new WhileController();
        this.modifyTestElement(controller);
        return controller;
    }

    public void modifyTestElement(TestElement controller) {
        this.configureTestElement(controller);
        if (controller instanceof WhileController) {
            if (this.theCondition.getText().length() > 0) {
                ((WhileController)controller).setCondition(this.theCondition.getText());
            } else {
                ((WhileController)controller).setCondition("");
            }
        }
    }

    public void actionPerformed(ActionEvent event) {
        new FocusRequester(this.theCondition);
    }

    public String getLabelResource() {
        return "while_controller_title";
    }

    private void init() {
        this.setLayout(new BorderLayout(0, 5));
        this.setBorder(this.makeBorder());
        this.add((Component)this.makeTitlePanel(), "North");
        JPanel mainPanel = new JPanel(new BorderLayout());
        mainPanel.add((Component)this.createConditionPanel(), "North");
        this.add((Component)mainPanel, "Center");
    }

    private JPanel createConditionPanel() {
        JPanel conditionPanel = new JPanel(new BorderLayout(5, 0));
        JLabel conditionLabel = new JLabel(JMeterUtils.getResString(CONDITION_LABEL));
        conditionPanel.add((Component)conditionLabel, "West");
        this.theCondition = new JTextField("");
        this.theCondition.setName(CONDITION);
        conditionLabel.setLabelFor(this.theCondition);
        conditionPanel.add((Component)this.theCondition, "Center");
        this.theCondition.addActionListener(this);
        conditionPanel.add(Box.createHorizontalStrut(conditionLabel.getPreferredSize().width + this.theCondition.getPreferredSize().width), "North");
        return conditionPanel;
    }
}

