/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jmeter.engine;

import java.net.MalformedURLException;
import java.rmi.ConnectException;
import java.rmi.Naming;
import java.rmi.NotBoundException;
import java.rmi.RemoteException;
import org.apache.jmeter.engine.ConvertListeners;
import org.apache.jmeter.engine.JMeterEngine;
import org.apache.jmeter.engine.RemoteJMeterEngine;
import org.apache.jmeter.threads.JMeterContextService;
import org.apache.jorphan.collections.HashTree;
import org.apache.jorphan.collections.HashTreeTraverser;
import org.apache.jorphan.collections.SearchByClass;
import org.apache.jorphan.logging.LoggingManager;
import org.apache.log.Logger;

public class ClientJMeterEngine
implements JMeterEngine,
Runnable {
    private static transient Logger log = LoggingManager.getLoggerForClass();
    RemoteJMeterEngine remote;
    HashTree test;
    SearchByClass testListeners;
    ConvertListeners sampleListeners;
    private String host;
    static /* synthetic */ Class class$org$apache$jmeter$testelement$TestListener;

    private static RemoteJMeterEngine getEngine(String h) throws MalformedURLException, RemoteException, NotBoundException {
        return (RemoteJMeterEngine)Naming.lookup("//" + h + "/JMeterEngine");
    }

    public ClientJMeterEngine(String host) throws MalformedURLException, NotBoundException, RemoteException {
        this(ClientJMeterEngine.getEngine(host));
        this.host = host;
    }

    public ClientJMeterEngine(RemoteJMeterEngine remote) {
        this.remote = remote;
    }

    protected HashTree getTestTree() {
        return this.test;
    }

    public void configure(HashTree testTree) {
        this.test = testTree;
    }

    public void setHost(String host) {
        this.host = host;
    }

    public void runTest() {
        log.info("about to run remote test");
        new Thread(this).start();
        log.info("done initiating run command");
    }

    public void stopTest() {
        try {
            this.remote.stopTest();
        }
        catch (Exception ex) {
            log.error("", (Throwable)ex);
        }
    }

    public void reset() {
        try {
            try {
                this.remote.reset();
            }
            catch (ConnectException e) {
                this.remote = ClientJMeterEngine.getEngine(this.host);
                this.remote.reset();
            }
        }
        catch (Exception ex) {
            log.error("", (Throwable)ex);
        }
    }

    public void run() {
        log.info("running clientengine run method");
        this.testListeners = new SearchByClass(class$org$apache$jmeter$testelement$TestListener == null ? (class$org$apache$jmeter$testelement$TestListener = ClientJMeterEngine.class$("org.apache.jmeter.testelement.TestListener")) : class$org$apache$jmeter$testelement$TestListener);
        this.getTestTree().traverse((HashTreeTraverser)this.testListeners);
        this.sampleListeners = new ConvertListeners();
        try {
            this.getTestTree().traverse((HashTreeTraverser)this.sampleListeners);
        }
        catch (IndexOutOfBoundsException e) {
            log.warn("Error replacing sample listeners", (Throwable)e);
        }
        try {
            JMeterContextService.startTest();
            this.remote.setHost(this.host);
            log.info("sent host =" + this.host);
            this.remote.configure(this.test);
            log.info("sent test");
            this.remote.runTest();
            log.info("sent run command");
        }
        catch (Exception ex) {
            log.error("", (Throwable)ex);
        }
    }

    public void exit() {
        try {
            this.remote.exit();
        }
        catch (RemoteException e) {
            log.warn("Could not perform remote exit: " + e.toString());
        }
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

