/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jmeter.engine;

import java.net.InetAddress;
import java.rmi.RemoteException;
import java.rmi.registry.LocateRegistry;
import java.rmi.registry.Registry;
import java.rmi.server.UnicastRemoteObject;
import org.apache.jmeter.engine.JMeterEngine;
import org.apache.jmeter.engine.JMeterEngineException;
import org.apache.jmeter.engine.RemoteJMeterEngine;
import org.apache.jmeter.engine.StandardJMeterEngine;
import org.apache.jmeter.util.JMeterUtils;
import org.apache.jorphan.collections.HashTree;
import org.apache.jorphan.logging.LoggingManager;
import org.apache.log.Logger;

public class RemoteJMeterEngineImpl
extends UnicastRemoteObject
implements RemoteJMeterEngine {
    private static transient Logger log = LoggingManager.getLoggerForClass();
    JMeterEngine backingEngine;
    public static final int DEFAULT_RMI_PORT = JMeterUtils.getPropDefault("server.rmi.port", 1099);

    public RemoteJMeterEngineImpl() throws RemoteException {
        this.init(DEFAULT_RMI_PORT);
    }

    public RemoteJMeterEngineImpl(int port) throws RemoteException {
        this.init(port == 0 ? DEFAULT_RMI_PORT : port);
    }

    private void init(int port) throws RemoteException {
        log.info("Starting backing engine on " + port);
        log.debug("This = " + this);
        try {
            Registry reg = LocateRegistry.getRegistry(port);
            this.backingEngine = new StandardJMeterEngine(InetAddress.getLocalHost().getHostName());
            reg.rebind("JMeterEngine", this);
            log.info("Bound to registry on port " + port);
        }
        catch (Exception ex) {
            log.error("rmiregistry needs to be running to start JMeter in server mode\n\t" + ex.toString());
            throw new RemoteException("Cannot start. See server log file.");
        }
    }

    public void setHost(String host) {
        log.info("received host: " + host);
        this.backingEngine.setHost(host);
    }

    public void configure(HashTree testTree) throws RemoteException {
        log.info("received test tree");
        this.backingEngine.configure(testTree);
    }

    public void runTest() throws RemoteException, JMeterEngineException {
        log.info("running test");
        log.debug("This = " + this);
        this.backingEngine.runTest();
    }

    public void reset() throws RemoteException {
        log.info("Reset");
        this.backingEngine.reset();
    }

    public void stopTest() throws RemoteException {
        log.info("Stopping test");
        this.backingEngine.stopTest();
    }

    public void exit() throws RemoteException {
        log.info("Exitting");
        this.backingEngine.exit();
    }

    public static void main(String[] args) {
        log.info("Starting main");
        try {
            new RemoteJMeterEngineImpl();
            while (true) {
                Thread.sleep(Long.MAX_VALUE);
            }
        }
        catch (Exception ex) {
            log.error("", (Throwable)ex);
            return;
        }
    }
}

