/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jmeter.engine;

import java.io.PrintWriter;
import java.io.Serializable;
import java.io.StringWriter;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import org.apache.jmeter.engine.JMeterEngine;
import org.apache.jmeter.engine.JMeterEngineException;
import org.apache.jmeter.engine.PreCompiler;
import org.apache.jmeter.engine.TreeCloner;
import org.apache.jmeter.engine.TurnElementsOn;
import org.apache.jmeter.testbeans.TestBean;
import org.apache.jmeter.testbeans.TestBeanHelper;
import org.apache.jmeter.testelement.TestElement;
import org.apache.jmeter.testelement.TestListener;
import org.apache.jmeter.testelement.TestPlan;
import org.apache.jmeter.threads.JMeterContextService;
import org.apache.jmeter.threads.JMeterThread;
import org.apache.jmeter.threads.JMeterThreadMonitor;
import org.apache.jmeter.threads.ListenerNotifier;
import org.apache.jmeter.threads.TestCompiler;
import org.apache.jmeter.threads.ThreadGroup;
import org.apache.jorphan.collections.HashTree;
import org.apache.jorphan.collections.HashTreeTraverser;
import org.apache.jorphan.collections.ListedHashTree;
import org.apache.jorphan.collections.SearchByClass;
import org.apache.jorphan.logging.LoggingManager;
import org.apache.log.Logger;

public class StandardJMeterEngine
implements JMeterEngine,
JMeterThreadMonitor,
Runnable,
Serializable {
    private static transient Logger log = LoggingManager.getLoggerForClass();
    private transient Thread runningThread;
    private static long WAIT_TO_DIE = 5000L;
    private transient Map allThreads = new HashMap();
    private boolean running = false;
    private boolean serialized = false;
    private volatile boolean schcdule_run = false;
    private HashTree test;
    private transient SearchByClass testListeners;
    private String host = null;
    private transient ListenerNotifier notifier;
    private static transient Map allThreadNames;
    private static StandardJMeterEngine engine;
    private static Map allThreadsSave;
    private static List testList;
    static /* synthetic */ Class class$org$apache$jmeter$testelement$TestPlan;
    static /* synthetic */ Class class$org$apache$jmeter$testelement$TestListener;
    static /* synthetic */ Class class$org$apache$jmeter$threads$ThreadGroup;

    public static void stopEngineNow() {
        if (engine != null) {
            engine.stopTest(true);
        }
    }

    public static void stopEngine() {
        if (engine != null) {
            engine.stopTest(false);
        }
    }

    public static synchronized void register(TestListener tl) {
        testList.add(tl);
    }

    public static boolean stopThread(String threadName) {
        return StandardJMeterEngine.stopThread(threadName, false);
    }

    public static boolean stopThreadNow(String threadName) {
        return StandardJMeterEngine.stopThread(threadName, true);
    }

    private static boolean stopThread(String threadName, boolean now) {
        JMeterThread thrd;
        if (allThreadNames == null) {
            return false;
        }
        try {
            thrd = (JMeterThread)allThreadNames.get(threadName);
        }
        catch (Exception e) {
            log.warn("stopThread: " + e);
            return false;
        }
        if (thrd != null) {
            Thread t;
            thrd.stop();
            if (now && (t = (Thread)allThreadsSave.get(thrd)) != null) {
                t.interrupt();
            }
            return true;
        }
        return false;
    }

    public StandardJMeterEngine() {
        engine = this;
        allThreadNames = new HashMap();
        allThreadsSave = this.allThreads;
    }

    public StandardJMeterEngine(String host) {
        this();
        this.host = host;
    }

    public void configure(HashTree testTree) {
        this.test = testTree;
    }

    public void setHost(String host) {
        this.host = host;
    }

    protected HashTree getTestTree() {
        return this.test;
    }

    protected void compileTree() {
        PreCompiler compiler = new PreCompiler();
        this.getTestTree().traverse((HashTreeTraverser)compiler);
    }

    public void runTest() throws JMeterEngineException {
        try {
            this.runningThread = new Thread(this);
            this.runningThread.start();
        }
        catch (Exception err) {
            this.stopTest();
            StringWriter string = new StringWriter();
            PrintWriter writer = new PrintWriter(string);
            err.printStackTrace(writer);
            throw new JMeterEngineException(string.toString());
        }
    }

    private void removeThreadGroups(List elements) {
        Iterator iter = elements.iterator();
        while (iter.hasNext()) {
            Object item = iter.next();
            if (item instanceof ThreadGroup) {
                iter.remove();
                continue;
            }
            if (item instanceof TestElement) continue;
            iter.remove();
        }
    }

    protected void notifyTestListenersOfStart() {
        Iterator iter = this.testListeners.getSearchResults().iterator();
        while (iter.hasNext()) {
            TestListener tl = (TestListener)iter.next();
            if (tl instanceof TestBean) {
                TestBeanHelper.prepare((TestElement)((Object)tl));
            }
            if (this.host == null) {
                tl.testStarted();
                continue;
            }
            tl.testStarted(this.host);
        }
    }

    protected void notifyTestListenersOfEnd() {
        log.info("Notifying test listeners of end of test");
        Iterator iter = this.testListeners.getSearchResults().iterator();
        while (iter.hasNext()) {
            TestListener tl = (TestListener)iter.next();
            if (tl instanceof TestBean) {
                TestBeanHelper.prepare((TestElement)((Object)tl));
            }
            if (this.host == null) {
                tl.testEnded();
                continue;
            }
            tl.testEnded(this.host);
        }
        log.info("Test has ended");
    }

    private ListedHashTree cloneTree(ListedHashTree tree) {
        TreeCloner cloner = new TreeCloner(true);
        tree.traverse((HashTreeTraverser)cloner);
        return cloner.getClonedTree();
    }

    public void reset() {
        if (this.running) {
            this.stopTest();
        }
    }

    public synchronized void threadFinished(JMeterThread thread) {
        try {
            this.allThreads.remove(thread);
            log.info("Ending thread " + thread.getThreadNum());
            if (!this.serialized && this.allThreads.size() == 0 && !this.schcdule_run) {
                log.info("Stopping test");
                this.stopTest();
            }
        }
        catch (Throwable e) {
            log.fatalError("Call to threadFinished should never throw an exception - this can deadlock JMeter", e);
        }
    }

    public synchronized void stopTest() {
        Thread stopThread = new Thread(new StopTest());
        stopThread.start();
    }

    public synchronized void stopTest(boolean b) {
        Thread stopThread = new Thread(new StopTest(b));
        stopThread.start();
    }

    public void run() {
        log.info("Running the test!");
        this.running = true;
        testList = new ArrayList();
        SearchByClass testPlan = new SearchByClass(class$org$apache$jmeter$testelement$TestPlan == null ? (class$org$apache$jmeter$testelement$TestPlan = StandardJMeterEngine.class$("org.apache.jmeter.testelement.TestPlan")) : class$org$apache$jmeter$testelement$TestPlan);
        this.getTestTree().traverse((HashTreeTraverser)testPlan);
        Object[] plan = testPlan.getSearchResults().toArray();
        if (plan.length == 0) {
            System.err.println("Could not find the TestPlan!");
            log.error("Could not find the TestPlan!");
            System.exit(1);
        }
        if (((TestPlan)plan[0]).isSerialized()) {
            this.serialized = true;
        }
        JMeterContextService.startTest();
        this.compileTree();
        this.testListeners = new SearchByClass(class$org$apache$jmeter$testelement$TestListener == null ? (class$org$apache$jmeter$testelement$TestListener = StandardJMeterEngine.class$("org.apache.jmeter.testelement.TestListener")) : class$org$apache$jmeter$testelement$TestListener);
        this.getTestTree().traverse((HashTreeTraverser)this.testListeners);
        Collection col = this.testListeners.getSearchResults();
        col.addAll(testList);
        testList = null;
        this.notifyTestListenersOfStart();
        this.getTestTree().traverse((HashTreeTraverser)new TurnElementsOn());
        LinkedList testLevelElements = new LinkedList(this.getTestTree().list(this.getTestTree().getArray()[0]));
        this.removeThreadGroups(testLevelElements);
        SearchByClass searcher = new SearchByClass(class$org$apache$jmeter$threads$ThreadGroup == null ? (class$org$apache$jmeter$threads$ThreadGroup = StandardJMeterEngine.class$("org.apache.jmeter.threads.ThreadGroup")) : class$org$apache$jmeter$threads$ThreadGroup);
        this.getTestTree().traverse((HashTreeTraverser)searcher);
        TestCompiler.initialize();
        Iterator iter = searcher.getSearchResults().iterator();
        System.gc();
        this.notifier = new ListenerNotifier();
        this.schcdule_run = true;
        JMeterContextService.getContext().setSamplingStarted(true);
        int groupCount = 0;
        while (iter.hasNext()) {
            ++groupCount;
            ThreadGroup group = (ThreadGroup)iter.next();
            int numThreads = group.getNumThreads();
            boolean onErrorStopTest = group.getOnErrorStopTest();
            boolean onErrorStopThread = group.getOnErrorStopThread();
            String groupName = group.getName();
            int rampUp = group.getRampUp();
            float perThreadDelay = (float)(rampUp * 1000) / (float)numThreads;
            JMeterThread[] threads = new JMeterThread[numThreads];
            log.info("Starting " + numThreads + " threads for group " + groupName + ". Ramp up = " + rampUp + ".");
            if (onErrorStopTest) {
                log.info("Test will stop on error");
            } else if (onErrorStopThread) {
                log.info("Thread will stop on error");
            } else {
                log.info("Continue on error");
            }
            ListedHashTree threadGroupTree = (ListedHashTree)searcher.getSubTree((Object)group);
            threadGroupTree.add((Object)group, testLevelElements);
            for (int i = 0; this.running && i < threads.length; ++i) {
                threads[i] = new JMeterThread((HashTree)this.cloneTree(threadGroupTree), this, this.notifier);
                threads[i].setThreadNum(i);
                threads[i].setThreadGroup(group);
                threads[i].setInitialContext(JMeterContextService.getContext());
                threads[i].setInitialDelay((int)(perThreadDelay * (float)i));
                threads[i].setThreadName(groupName + " " + groupCount + "-" + (i + 1));
                this.scheduleThread(threads[i], group);
                threads[i].setEngine(this);
                threads[i].setOnErrorStopTest(onErrorStopTest);
                threads[i].setOnErrorStopThread(onErrorStopThread);
                Thread newThread = new Thread(threads[i]);
                newThread.setName(threads[i].getThreadName());
                this.allThreads.put(threads[i], newThread);
                if (this.serialized && !iter.hasNext() && i == threads.length - 1) {
                    this.serialized = false;
                }
                newThread.start();
            }
            this.schcdule_run = false;
            if (!this.serialized) continue;
            while (this.running && this.allThreads.size() > 0) {
                try {
                    Thread.sleep(1000L);
                }
                catch (InterruptedException e) {}
            }
        }
    }

    private void scheduleThread(JMeterThread thread, ThreadGroup group) {
        if (group.getScheduler()) {
            long now = System.currentTimeMillis();
            if (group.getDelay() > 0L) {
                thread.setStartTime(group.getDelay() * 1000L + now);
            } else {
                long start = group.getStartTime();
                if (start < now) {
                    start = now;
                }
                thread.setStartTime(start);
            }
            if (group.getDuration() > 0L) {
                thread.setEndTime(group.getDuration() * 1000L + thread.getStartTime());
            } else {
                thread.setEndTime(group.getEndTime());
            }
            thread.setScheduled(true);
        }
    }

    public synchronized void pauseTest(int milis) {
        Iterator iter = new HashSet(this.allThreads.keySet()).iterator();
        while (iter.hasNext()) {
            Thread t = (Thread)this.allThreads.get(iter.next());
            if (t == null || !t.isAlive()) continue;
            try {
                Thread.sleep(milis);
            }
            catch (InterruptedException e) {}
        }
    }

    private boolean verifyThreadsStopped() {
        boolean stoppedAll = true;
        Iterator iter = new HashSet(this.allThreads.keySet()).iterator();
        while (iter.hasNext()) {
            Thread t = (Thread)this.allThreads.get(iter.next());
            if (t == null || !t.isAlive()) continue;
            try {
                t.join(WAIT_TO_DIE);
            }
            catch (InterruptedException e) {
                // empty catch block
            }
            if (!t.isAlive()) continue;
            stoppedAll = false;
            log.info("Thread won't die: " + t.getName());
        }
        return stoppedAll;
    }

    private void tellThreadsToStop() {
        Iterator iter = new HashSet(this.allThreads.keySet()).iterator();
        while (iter.hasNext()) {
            JMeterThread item = (JMeterThread)iter.next();
            item.stop();
            Thread t = (Thread)this.allThreads.get(item);
            if (t != null) {
                t.interrupt();
                continue;
            }
            log.warn("Lost thread: " + item.getThreadName());
            this.allThreads.remove(item);
        }
    }

    public void askThreadsToStop() {
        engine.stopTest(false);
    }

    private void stopAllThreads() {
        Iterator iter = new HashSet(this.allThreads.keySet()).iterator();
        while (iter.hasNext()) {
            JMeterThread item = (JMeterThread)iter.next();
            item.stop();
        }
    }

    public void exit() {
        Thread t = new Thread(){

            public void run() {
                try {
                    Thread.sleep(1000L);
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
                log.info("Bye");
                System.exit(0);
            }
        };
        log.info("Starting Closedown");
        t.start();
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    static {
        testList = null;
    }

    private class StopTest
    implements Runnable {
        boolean now;

        private StopTest() {
            this.now = true;
        }

        private StopTest(boolean b) {
            this.now = b;
        }

        public void run() {
            if (StandardJMeterEngine.this.running) {
                StandardJMeterEngine.this.running = false;
                if (this.now) {
                    StandardJMeterEngine.this.tellThreadsToStop();
                } else {
                    StandardJMeterEngine.this.stopAllThreads();
                }
                try {
                    Thread.sleep(10 * StandardJMeterEngine.this.allThreads.size());
                }
                catch (InterruptedException e) {
                    // empty catch block
                }
                boolean stopped = StandardJMeterEngine.this.verifyThreadsStopped();
                if (stopped || this.now) {
                    StandardJMeterEngine.this.notifyTestListenersOfEnd();
                }
            }
        }
    }
}

