/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jmeter.engine.util;

import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import org.apache.jmeter.engine.util.FunctionParser;
import org.apache.jmeter.engine.util.SimpleVariable;
import org.apache.jmeter.functions.Function;
import org.apache.jmeter.functions.InvalidVariableException;
import org.apache.jmeter.samplers.SampleResult;
import org.apache.jmeter.samplers.Sampler;
import org.apache.jmeter.threads.JMeterContext;
import org.apache.jmeter.threads.JMeterContextService;
import org.apache.jmeter.util.JMeterUtils;
import org.apache.jorphan.logging.LoggingManager;
import org.apache.jorphan.reflect.ClassFinder;
import org.apache.log.Logger;

public class CompoundVariable
implements Function {
    private static transient Logger log = LoggingManager.getLoggerForClass();
    private String rawParameters;
    static FunctionParser functionParser = new FunctionParser();
    static Map functions = new HashMap();
    private boolean hasFunction = false;
    private boolean isDynamic = true;
    private String permanentResults = "";
    LinkedList compiledComponents = new LinkedList();
    static /* synthetic */ Class class$org$apache$jmeter$functions$Function;

    public CompoundVariable() {
    }

    public CompoundVariable(String parameters) {
        this();
        try {
            this.setParameters(parameters);
        }
        catch (InvalidVariableException invalidVariableException) {
            // empty catch block
        }
    }

    public String execute() {
        if (this.isDynamic) {
            JMeterContext context = JMeterContextService.getContext();
            SampleResult previousResult = context.getPreviousResult();
            Sampler currentSampler = context.getCurrentSampler();
            return this.execute(previousResult, currentSampler);
        }
        return this.permanentResults;
    }

    public String getRawParameters() {
        return this.rawParameters;
    }

    public String execute(SampleResult previousResult, Sampler currentSampler) {
        if (this.compiledComponents == null || this.compiledComponents.size() == 0) {
            return "";
        }
        boolean testDynamic = false;
        StringBuffer results = new StringBuffer();
        Iterator iter = this.compiledComponents.iterator();
        while (iter.hasNext()) {
            Object item = iter.next();
            if (item instanceof Function) {
                testDynamic = true;
                try {
                    results.append(((Function)item).execute(previousResult, currentSampler));
                }
                catch (InvalidVariableException e) {}
                continue;
            }
            if (item instanceof SimpleVariable) {
                testDynamic = true;
                results.append(((SimpleVariable)item).toString());
                continue;
            }
            results.append(item);
        }
        if (!testDynamic) {
            this.isDynamic = false;
            this.permanentResults = results.toString();
        }
        return results.toString();
    }

    public CompoundVariable getFunction() {
        CompoundVariable func = new CompoundVariable();
        func.compiledComponents = (LinkedList)this.compiledComponents.clone();
        func.rawParameters = this.rawParameters;
        return func;
    }

    public List getArgumentDesc() {
        return new LinkedList();
    }

    public void clear() {
        this.hasFunction = false;
        this.compiledComponents.clear();
    }

    public void setParameters(String parameters) throws InvalidVariableException {
        this.rawParameters = parameters;
        if (parameters == null || parameters.length() == 0) {
            return;
        }
        this.compiledComponents = functionParser.compileString(parameters);
        if (this.compiledComponents.size() > 1 || !(this.compiledComponents.get(0) instanceof String)) {
            this.hasFunction = true;
        }
    }

    public void setParameters(Collection parameters) throws InvalidVariableException {
    }

    static Object getNamedFunction(String functionName) throws InvalidVariableException {
        if (functions.containsKey(functionName)) {
            try {
                return (Function)((Class)functions.get(functionName)).newInstance();
            }
            catch (Exception e) {
                log.error("", (Throwable)e);
                throw new InvalidVariableException();
            }
        }
        return new SimpleVariable(functionName);
    }

    public boolean hasFunction() {
        return this.hasFunction;
    }

    public String getReferenceKey() {
        return "";
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    static {
        try {
            List classes = ClassFinder.findClassesThatExtend((String[])JMeterUtils.getSearchPaths(), (Class[])new Class[]{class$org$apache$jmeter$functions$Function == null ? (class$org$apache$jmeter$functions$Function = CompoundVariable.class$("org.apache.jmeter.functions.Function")) : class$org$apache$jmeter$functions$Function}, (boolean)true);
            Iterator iter = classes.iterator();
            while (iter.hasNext()) {
                Function tempFunc = (Function)Class.forName((String)iter.next()).newInstance();
                functions.put(tempFunc.getReferenceKey(), tempFunc.getClass());
            }
        }
        catch (Exception err) {
            log.error("", (Throwable)err);
        }
    }
}

