/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jmeter.gui;

import java.awt.Component;
import java.awt.Container;
import java.awt.Font;
import javax.swing.BorderFactory;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.border.Border;
import org.apache.jmeter.gui.JMeterGUIComponent;
import org.apache.jmeter.gui.NamePanel;
import org.apache.jmeter.gui.tree.JMeterTreeNode;
import org.apache.jmeter.gui.util.VerticalPanel;
import org.apache.jmeter.testelement.TestElement;
import org.apache.jmeter.testelement.property.BooleanProperty;
import org.apache.jmeter.testelement.property.NullProperty;
import org.apache.jmeter.testelement.property.StringProperty;
import org.apache.jmeter.util.JMeterUtils;
import org.apache.jmeter.visualizers.Printable;
import org.apache.jorphan.logging.LoggingManager;
import org.apache.log.Logger;

public abstract class AbstractJMeterGuiComponent
extends JPanel
implements JMeterGUIComponent,
Printable {
    private static Logger log = LoggingManager.getLoggerForClass();
    private boolean enabled = true;
    private JMeterTreeNode node;
    private NamePanel namePanel = new NamePanel();

    public AbstractJMeterGuiComponent() {
        this.setName(this.getStaticLabel());
    }

    public void setName(String name) {
        this.namePanel.setName(name);
    }

    public boolean isEnabled() {
        return this.enabled;
    }

    public void setEnabled(boolean e) {
        log.debug("Setting enabled: " + e);
        this.enabled = e;
    }

    public String getName() {
        if (this.getNamePanel() != null) {
            return this.getNamePanel().getName();
        }
        return "";
    }

    protected NamePanel getNamePanel() {
        return this.namePanel;
    }

    protected Component createTitleLabel() {
        JLabel titleLabel = new JLabel(this.getStaticLabel());
        Font curFont = titleLabel.getFont();
        titleLabel.setFont(curFont.deriveFont((float)curFont.getSize() + 4.0f));
        return titleLabel;
    }

    public void configure(TestElement element) {
        this.setName(element.getPropertyAsString("TestElement.name"));
        this.enabled = element.getProperty("TestElement.enabled") instanceof NullProperty ? true : element.getPropertyAsBoolean("TestElement.enabled");
    }

    public void clear() {
        this.setName(this.getStaticLabel());
        this.enabled = true;
    }

    protected void configureTestElement(TestElement mc) {
        mc.setProperty(new StringProperty("TestElement.name", this.getName()));
        mc.setProperty(new StringProperty("TestElement.gui_class", this.getClass().getName()));
        mc.setProperty(new StringProperty("TestElement.test_class", mc.getClass().getName()));
        log.debug("setting element to enabled: " + this.enabled);
        mc.setProperty(new BooleanProperty("TestElement.enabled", this.enabled));
    }

    public void setNode(JMeterTreeNode node) {
        this.node = node;
        this.getNamePanel().setNode(node);
    }

    protected JMeterTreeNode getNode() {
        return this.node;
    }

    protected Container makeTitlePanel() {
        VerticalPanel titlePanel = new VerticalPanel();
        titlePanel.add(this.createTitleLabel());
        titlePanel.add(this.getNamePanel());
        return titlePanel;
    }

    protected Border makeBorder() {
        return BorderFactory.createEmptyBorder(10, 10, 5, 10);
    }

    protected JScrollPane makeScrollPane(Component comp) {
        JScrollPane pane = new JScrollPane(comp);
        pane.setPreferredSize(pane.getMinimumSize());
        return pane;
    }

    protected JScrollPane makeScrollPane(Component comp, int verticalPolicy, int horizontalPolicy) {
        JScrollPane pane = new JScrollPane(comp, verticalPolicy, horizontalPolicy);
        pane.setPreferredSize(pane.getMinimumSize());
        return pane;
    }

    public String getStaticLabel() {
        return JMeterUtils.getResString(this.getLabelResource());
    }

    public String getDocAnchor() {
        return this.getStaticLabel().replace(' ', '_');
    }

    public JComponent getPrintableComponent() {
        return this;
    }
}

