/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jmeter.gui;

import java.awt.Component;
import java.awt.event.MouseEvent;
import java.beans.Introspector;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import javax.swing.JComponent;
import javax.swing.JOptionPane;
import javax.swing.JPopupMenu;
import org.apache.jmeter.engine.util.ValueReplacer;
import org.apache.jmeter.exceptions.IllegalUserActionException;
import org.apache.jmeter.gui.JMeterGUIComponent;
import org.apache.jmeter.gui.MainFrame;
import org.apache.jmeter.gui.UnsharedComponent;
import org.apache.jmeter.gui.tree.JMeterTreeListener;
import org.apache.jmeter.gui.tree.JMeterTreeModel;
import org.apache.jmeter.gui.tree.JMeterTreeNode;
import org.apache.jmeter.services.FileServer;
import org.apache.jmeter.testbeans.gui.TestBeanGUI;
import org.apache.jmeter.testelement.TestElement;
import org.apache.jmeter.testelement.TestPlan;
import org.apache.jmeter.util.JMeterUtils;
import org.apache.jmeter.util.LocaleChangeEvent;
import org.apache.jmeter.util.LocaleChangeListener;
import org.apache.jmeter.visualizers.gui.AbstractVisualizer;
import org.apache.jorphan.collections.HashTree;
import org.apache.jorphan.logging.LoggingManager;
import org.apache.log.Logger;

public final class GuiPackage
implements LocaleChangeListener {
    private static transient Logger log = LoggingManager.getLoggerForClass();
    private static GuiPackage guiPack;
    private boolean dirty = false;
    private Map nodesToGui = new HashMap();
    private Map guis = new HashMap();
    private Map testBeanGUIs = new HashMap();
    private JMeterTreeNode currentNode = null;
    private boolean currentNodeUpdated = false;
    private JMeterTreeModel treeModel;
    private JMeterTreeListener treeListener;
    private MainFrame mainFrame;
    private String testPlanFile;
    static /* synthetic */ Class class$org$apache$jmeter$testbeans$TestBean;
    static /* synthetic */ Class class$org$apache$jmeter$testbeans$gui$TestBeanGUI;

    private GuiPackage() {
        JMeterUtils.addLocaleChangeListener(this);
    }

    public static GuiPackage getInstance() {
        return guiPack;
    }

    public static GuiPackage getInstance(JMeterTreeListener listener, JMeterTreeModel treeModel) {
        if (guiPack == null) {
            guiPack = new GuiPackage();
            guiPack.setTreeListener(listener);
            guiPack.setTreeModel(treeModel);
        }
        return guiPack;
    }

    public JMeterGUIComponent getGui(TestElement node) {
        String testClassName = node.getPropertyAsString("TestElement.test_class");
        String guiClassName = node.getPropertyAsString("TestElement.gui_class");
        try {
            Class<?> testClass = testClassName.equals("") ? node.getClass() : Class.forName(testClassName);
            Class<?> guiClass = null;
            if (!guiClassName.equals("")) {
                guiClass = Class.forName(guiClassName);
            }
            return this.getGui(node, guiClass, testClass);
        }
        catch (ClassNotFoundException e) {
            log.error("Could not get GUI for " + node, (Throwable)e);
            return null;
        }
    }

    public JMeterGUIComponent getGui(TestElement node, Class guiClass, Class testClass) {
        try {
            JMeterGUIComponent comp = (JMeterGUIComponent)this.nodesToGui.get(node);
            if (comp == null) {
                comp = this.getGuiFromCache(guiClass, testClass);
                this.nodesToGui.put(node, comp);
            }
            log.debug("Gui retrieved = " + comp);
            return comp;
        }
        catch (Exception e) {
            log.error("Problem retrieving gui", (Throwable)e);
            return null;
        }
    }

    public void removeNode(TestElement node) {
        this.nodesToGui.remove(node);
    }

    public JMeterGUIComponent getCurrentGui() {
        try {
            this.updateCurrentNode();
            TestElement curNode = this.treeListener.getCurrentNode().getTestElement();
            JMeterGUIComponent comp = this.getGui(curNode);
            if (!(comp instanceof AbstractVisualizer)) {
                comp.clear();
            }
            log.debug("Updating gui to new node");
            comp.configure(curNode);
            this.currentNodeUpdated = false;
            return comp;
        }
        catch (Exception e) {
            log.error("Problem retrieving gui", (Throwable)e);
            return null;
        }
    }

    public JMeterTreeNode getNodeOf(TestElement userObject) {
        return this.treeModel.getNodeOf(userObject);
    }

    public TestElement createTestElement(Class guiClass, Class testClass) {
        try {
            JMeterGUIComponent comp = this.getGuiFromCache(guiClass, testClass);
            comp.clear();
            TestElement node = comp.createTestElement();
            this.nodesToGui.put(node, comp);
            return node;
        }
        catch (Exception e) {
            log.error("Problem retrieving gui", (Throwable)e);
            return null;
        }
    }

    public TestElement createTestElement(String objClass) {
        try {
            Class<?> c = Class.forName(objClass);
            JMeterGUIComponent comp = (class$org$apache$jmeter$testbeans$TestBean == null ? (class$org$apache$jmeter$testbeans$TestBean = GuiPackage.class$("org.apache.jmeter.testbeans.TestBean")) : class$org$apache$jmeter$testbeans$TestBean).isAssignableFrom(c) ? this.getGuiFromCache(class$org$apache$jmeter$testbeans$gui$TestBeanGUI == null ? (class$org$apache$jmeter$testbeans$gui$TestBeanGUI = GuiPackage.class$("org.apache.jmeter.testbeans.gui.TestBeanGUI")) : class$org$apache$jmeter$testbeans$gui$TestBeanGUI, c) : this.getGuiFromCache(c, null);
            comp.clear();
            TestElement node = comp.createTestElement();
            this.nodesToGui.put(node, comp);
            return node;
        }
        catch (NoClassDefFoundError e) {
            log.error("Problem retrieving gui for " + objClass, (Throwable)e);
            String msg = "Cannot find class: " + e.getMessage();
            JOptionPane.showMessageDialog(null, msg, "Missing jar? See log file.", 0);
            throw new RuntimeException(e.toString());
        }
        catch (ClassNotFoundException e) {
            log.error("Problem retrieving gui for " + objClass, (Throwable)e);
            throw new RuntimeException(e.toString());
        }
        catch (InstantiationException e) {
            log.error("Problem retrieving gui for " + objClass, (Throwable)e);
            throw new RuntimeException(e.toString());
        }
        catch (IllegalAccessException e) {
            log.error("Problem retrieving gui for " + objClass, (Throwable)e);
            throw new RuntimeException(e.toString());
        }
    }

    private JMeterGUIComponent getGuiFromCache(Class guiClass, Class testClass) throws InstantiationException, IllegalAccessException, ClassNotFoundException {
        JMeterGUIComponent comp;
        if (guiClass == (class$org$apache$jmeter$testbeans$gui$TestBeanGUI == null ? (class$org$apache$jmeter$testbeans$gui$TestBeanGUI = GuiPackage.class$("org.apache.jmeter.testbeans.gui.TestBeanGUI")) : class$org$apache$jmeter$testbeans$gui$TestBeanGUI)) {
            comp = (TestBeanGUI)this.testBeanGUIs.get(testClass);
            if (comp == null) {
                comp = new TestBeanGUI(testClass);
                this.testBeanGUIs.put(testClass, comp);
            }
        } else {
            comp = (JMeterGUIComponent)this.guis.get(guiClass);
            if (comp == null && !((comp = (JMeterGUIComponent)guiClass.newInstance()) instanceof UnsharedComponent)) {
                this.guis.put(guiClass, comp);
            }
        }
        return comp;
    }

    public void updateCurrentGui() {
        this.updateCurrentNode();
        this.currentNode = this.treeListener.getCurrentNode();
        TestElement element = this.currentNode.getTestElement();
        JMeterGUIComponent comp = this.getGui(element);
        comp.configure(element);
        this.currentNodeUpdated = false;
    }

    public void updateCurrentNode() {
        try {
            if (this.currentNode != null && !this.currentNodeUpdated) {
                log.debug("Updating current node " + this.currentNode.getName());
                JMeterGUIComponent comp = this.getGui(this.currentNode.getTestElement());
                TestElement el = this.currentNode.getTestElement();
                comp.modifyTestElement(el);
            }
            if (this.currentNode != this.treeListener.getCurrentNode()) {
                this.currentNodeUpdated = true;
            }
            this.currentNode = this.treeListener.getCurrentNode();
        }
        catch (Exception e) {
            log.error("Problem retrieving gui", (Throwable)e);
        }
    }

    public JMeterTreeNode getCurrentNode() {
        return this.treeListener.getCurrentNode();
    }

    public TestElement getCurrentElement() {
        return this.getCurrentNode().getTestElement();
    }

    public void setDirty(boolean dirty) {
        this.dirty = dirty;
    }

    public boolean isDirty() {
        return this.dirty;
    }

    public HashTree addSubTree(HashTree subTree) throws IllegalUserActionException {
        return this.treeModel.addSubTree(subTree, this.treeListener.getCurrentNode());
    }

    public HashTree getCurrentSubTree() {
        return this.treeModel.getCurrentSubTree(this.treeListener.getCurrentNode());
    }

    public JMeterTreeModel getTreeModel() {
        return this.treeModel;
    }

    public void setTreeModel(JMeterTreeModel newTreeModel) {
        this.treeModel = newTreeModel;
    }

    public ValueReplacer getReplacer() {
        return new ValueReplacer((TestPlan)((JMeterTreeNode)this.getTreeModel().getTestPlan().getArray()[0]).getTestElement());
    }

    public void setMainFrame(MainFrame newMainFrame) {
        this.mainFrame = newMainFrame;
    }

    public MainFrame getMainFrame() {
        return this.mainFrame;
    }

    public void setTreeListener(JMeterTreeListener newTreeListener) {
        this.treeListener = newTreeListener;
    }

    public JMeterTreeListener getTreeListener() {
        return this.treeListener;
    }

    public void displayPopUp(MouseEvent e, JPopupMenu popup) {
        this.displayPopUp((Component)e.getSource(), e, popup);
    }

    public void displayPopUp(Component invoker, MouseEvent e, JPopupMenu popup) {
        if (popup != null) {
            log.debug("Showing pop up for " + invoker + " at x,y = " + e.getX() + "," + e.getY());
            popup.pack();
            popup.show(invoker, e.getX(), e.getY());
            popup.setVisible(true);
            popup.requestFocus();
        }
    }

    public void localeChanged(LocaleChangeEvent event) {
        this.updateCurrentNode();
        this.guis = new HashMap();
        this.nodesToGui = new HashMap();
        this.testBeanGUIs = new HashMap();
        Introspector.flushCaches();
        MainFrame mf = this.getMainFrame();
        if (mf == null) {
            log.warn("Mainframe is null");
        } else {
            mf.setMainPanel((JComponent)((Object)this.getCurrentGui()));
            mf.setEditMenu(this.getTreeListener().getCurrentNode().createPopupMenu());
        }
    }

    public void setTestPlanFile(String f) {
        this.testPlanFile = f;
        GuiPackage.getInstance().getMainFrame().setTitle(JMeterUtils.getExtendedFrameTitle(this.testPlanFile));
        try {
            FileServer.getFileServer().setBasedir(this.testPlanFile);
        }
        catch (IOException e1) {
            log.error("Failure setting file server's base dir", (Throwable)e1);
        }
    }

    public String getTestPlanFile() {
        return this.testPlanFile;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

