/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jmeter.gui.action;

import java.awt.event.ActionEvent;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.Set;
import javax.swing.JOptionPane;
import org.apache.jmeter.control.ReplaceableController;
import org.apache.jmeter.gui.GuiPackage;
import org.apache.jmeter.gui.action.ActionRouter;
import org.apache.jmeter.gui.action.Command;
import org.apache.jmeter.gui.tree.JMeterTreeNode;
import org.apache.jmeter.testelement.TestElement;
import org.apache.jmeter.util.JMeterUtils;
import org.apache.jorphan.collections.HashTree;
import org.apache.jorphan.logging.LoggingManager;
import org.apache.log.Logger;

public abstract class AbstractAction
implements Command {
    private static final Logger log = LoggingManager.getLoggerForClass();

    public void doAction(ActionEvent e) {
    }

    public abstract Set getActionNames();

    protected void convertSubTree(HashTree tree) {
        Iterator iter = new LinkedList(tree.list()).iterator();
        while (iter.hasNext()) {
            Object o = iter.next();
            if (o instanceof TestElement) continue;
            JMeterTreeNode item = (JMeterTreeNode)o;
            if (item.isEnabled()) {
                if (item.getUserObject() instanceof ReplaceableController) {
                    ReplaceableController rc = (ReplaceableController)((Object)item.getTestElement());
                    HashTree subTree = tree.getTree((Object)item);
                    if (subTree == null) continue;
                    HashTree replacementTree = rc.getReplacementSubTree();
                    this.convertSubTree(replacementTree);
                    tree.replace((Object)item, (Object)rc);
                    tree.set((Object)rc, replacementTree);
                    continue;
                }
                this.convertSubTree(tree.getTree((Object)item));
                TestElement testElement = item.getTestElement();
                tree.replace((Object)item, (Object)testElement);
                continue;
            }
            tree.remove((Object)item);
        }
    }

    protected void popupShouldSave(ActionEvent e) {
        log.debug("popupShouldSave");
        if (GuiPackage.getInstance().getTestPlanFile() == null && JOptionPane.showConfirmDialog(GuiPackage.getInstance().getMainFrame(), JMeterUtils.getResString("should_save"), JMeterUtils.getResString("warning"), 0, 3) == 0) {
            ActionRouter.getInstance().doActionNow(new ActionEvent(e.getSource(), e.getID(), "save"));
        }
    }
}

