/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jmeter.gui.action;

import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.lang.reflect.Modifier;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.swing.SwingUtilities;
import org.apache.jmeter.exceptions.IllegalUserActionException;
import org.apache.jmeter.gui.GuiPackage;
import org.apache.jmeter.gui.action.Command;
import org.apache.jmeter.util.JMeterUtils;
import org.apache.jorphan.logging.LoggingManager;
import org.apache.jorphan.reflect.ClassFinder;
import org.apache.log.Logger;

public final class ActionRouter
implements ActionListener {
    private Map commands = new HashMap();
    private static ActionRouter router;
    private static transient Logger log;
    private Map preActionListeners = new HashMap();
    private Map postActionListeners = new HashMap();

    private ActionRouter() {
    }

    public void actionPerformed(final ActionEvent e) {
        SwingUtilities.invokeLater(new Runnable(){

            public void run() {
                ActionRouter.this.performAction(e);
            }
        });
    }

    private void performAction(ActionEvent e) {
        try {
            GuiPackage.getInstance().updateCurrentNode();
            Set commandObjects = (Set)this.commands.get(e.getActionCommand());
            Iterator iter = commandObjects.iterator();
            while (iter.hasNext()) {
                try {
                    Command c = (Command)iter.next();
                    this.preActionPerformed(c.getClass(), e);
                    c.doAction(e);
                    this.postActionPerformed(c.getClass(), e);
                }
                catch (IllegalUserActionException err) {
                    JMeterUtils.reportErrorToUser(err.toString());
                }
                catch (Exception err) {
                    log.error("", (Throwable)err);
                }
            }
        }
        catch (NullPointerException er) {
            log.error("performAction(" + e.getActionCommand() + ") " + e.toString() + " caused", (Throwable)er);
            JMeterUtils.reportErrorToUser("Sorry, this feature (" + e.getActionCommand() + ") not yet implemented");
        }
    }

    public void doActionNow(ActionEvent e) {
        this.performAction(e);
    }

    public Set getAction(String actionName) {
        HashSet set = new HashSet();
        Set commandObjects = (Set)this.commands.get(actionName);
        Iterator iter = commandObjects.iterator();
        while (iter.hasNext()) {
            try {
                set.add(iter.next());
            }
            catch (Exception err) {
                log.error("", (Throwable)err);
            }
        }
        return set;
    }

    public Command getAction(String actionName, Class actionClass) {
        Set commandObjects = (Set)this.commands.get(actionName);
        Iterator iter = commandObjects.iterator();
        while (iter.hasNext()) {
            try {
                Command com = (Command)iter.next();
                if (!com.getClass().equals(actionClass)) continue;
                return com;
            }
            catch (Exception err) {
                log.error("", (Throwable)err);
            }
        }
        return null;
    }

    public Command getAction(String actionName, String className) {
        Set commandObjects = (Set)this.commands.get(actionName);
        Iterator iter = commandObjects.iterator();
        while (iter.hasNext()) {
            try {
                Command com = (Command)iter.next();
                if (!com.getClass().getName().equals(className)) continue;
                return com;
            }
            catch (Exception err) {
                log.error("", (Throwable)err);
            }
        }
        return null;
    }

    public void addPreActionListener(Class action, ActionListener listener) {
        if (action != null) {
            HashSet<ActionListener> set = (HashSet<ActionListener>)this.preActionListeners.get(action.getName());
            if (set == null) {
                set = new HashSet<ActionListener>();
            }
            set.add(listener);
            this.preActionListeners.put(action.getName(), set);
        }
    }

    public void removePreActionListener(Class action, ActionListener listener) {
        HashSet set;
        if (action != null && (set = (HashSet)this.preActionListeners.get(action.getName())) != null) {
            set.remove(listener);
            this.preActionListeners.put(action.getName(), set);
        }
    }

    public void addPostActionListener(Class action, ActionListener listener) {
        if (action != null) {
            HashSet<ActionListener> set = (HashSet<ActionListener>)this.postActionListeners.get(action.getName());
            if (set == null) {
                set = new HashSet<ActionListener>();
            }
            set.add(listener);
            this.postActionListeners.put(action.getName(), set);
        }
    }

    public void removePostActionListener(Class action, ActionListener listener) {
        HashSet set;
        if (action != null && (set = (HashSet)this.postActionListeners.get(action.getName())) != null) {
            set.remove(listener);
            this.postActionListeners.put(action.getName(), set);
        }
    }

    protected void preActionPerformed(Class action, ActionEvent e) {
        HashSet listenerSet;
        if (action != null && (listenerSet = (HashSet)this.preActionListeners.get(action.getName())) != null && listenerSet.size() > 0) {
            Object[] listeners = listenerSet.toArray();
            for (int i = 0; i < listeners.length; ++i) {
                ((ActionListener)listeners[i]).actionPerformed(e);
            }
        }
    }

    protected void postActionPerformed(Class action, ActionEvent e) {
        HashSet listenerSet;
        if (action != null && (listenerSet = (HashSet)this.postActionListeners.get(action.getName())) != null && listenerSet.size() > 0) {
            Object[] listeners = listenerSet.toArray();
            for (int i = 0; i < listeners.length; ++i) {
                ((ActionListener)listeners[i]).actionPerformed(e);
            }
        }
    }

    private void populateCommandMap() {
        try {
            List listClasses = ClassFinder.findClassesThatExtend((String[])JMeterUtils.getSearchPaths(), (Class[])new Class[]{Class.forName("org.apache.jmeter.gui.action.Command")});
            this.commands = new HashMap(listClasses.size());
            if (listClasses.size() == 0) {
                log.warn("!!!!!Uh-oh, didn't find any action handlers!!!!!");
            }
            Iterator iterClasses = listClasses.iterator();
            while (iterClasses.hasNext()) {
                String strClassName = (String)iterClasses.next();
                Class<?> commandClass = Class.forName(strClassName);
                if (Modifier.isAbstract(commandClass.getModifiers())) continue;
                Command command = (Command)commandClass.newInstance();
                Iterator iter = command.getActionNames().iterator();
                while (iter.hasNext()) {
                    String commandName = (String)iter.next();
                    HashSet<Command> commandObjects = (HashSet<Command>)this.commands.get(commandName);
                    if (commandObjects == null) {
                        commandObjects = new HashSet<Command>();
                        this.commands.put(commandName, commandObjects);
                    }
                    commandObjects.add(command);
                }
            }
        }
        catch (Exception e) {
            if ("java.awt.HeadlessException".equals(e.getClass().getName())) {
                log.warn(e.toString());
            }
            log.error("exception finding action handlers", (Throwable)e);
        }
    }

    public static ActionRouter getInstance() {
        if (router == null) {
            router = new ActionRouter();
            router.populateCommandMap();
        }
        return router;
    }

    static {
        log = LoggingManager.getLoggerForClass();
    }
}

