/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jmeter.gui.action;

import java.awt.Component;
import java.awt.event.ActionEvent;
import java.util.HashSet;
import java.util.Set;
import org.apache.jmeter.gui.GuiPackage;
import org.apache.jmeter.gui.action.Command;
import org.apache.jmeter.gui.tree.JMeterTreeNode;
import org.apache.jmeter.testelement.TestElement;
import org.apache.jorphan.logging.LoggingManager;
import org.apache.log.Logger;

public class AddParent
implements Command {
    private static transient Logger log = LoggingManager.getLoggerForClass();
    private static Set commands = new HashSet();

    public void doAction(ActionEvent e) {
        String name = ((Component)e.getSource()).getName();
        try {
            TestElement controller = GuiPackage.getInstance().createTestElement(name);
            this.addParentToTree(controller);
        }
        catch (Exception err) {
            log.error("", (Throwable)err);
        }
    }

    public Set getActionNames() {
        return commands;
    }

    protected void addParentToTree(TestElement newParent) {
        GuiPackage guiPackage = GuiPackage.getInstance();
        JMeterTreeNode newNode = new JMeterTreeNode(newParent, guiPackage.getTreeModel());
        JMeterTreeNode currentNode = guiPackage.getTreeListener().getCurrentNode();
        JMeterTreeNode parentNode = (JMeterTreeNode)currentNode.getParent();
        int index = parentNode.getIndex(currentNode);
        guiPackage.getTreeModel().insertNodeInto(newNode, parentNode, index);
        JMeterTreeNode[] nodes = guiPackage.getTreeListener().getSelectedNodes();
        for (int i = 0; i < nodes.length; ++i) {
            this.moveNode(guiPackage, nodes[i], newNode);
        }
    }

    private void moveNode(GuiPackage guiPackage, JMeterTreeNode node, JMeterTreeNode newParentNode) {
        guiPackage.getTreeModel().removeNodeFromParent(node);
        guiPackage.getTreeModel().insertNodeInto(node, newParentNode, newParentNode.getChildCount());
    }

    static {
        commands.add("Add Parent");
    }
}

