/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jmeter.gui.action;

import java.awt.event.ActionEvent;
import java.io.FileOutputStream;
import java.io.FileWriter;
import java.io.Writer;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.Set;
import javax.swing.JFileChooser;
import junit.framework.TestCase;
import org.apache.jmeter.config.Arguments;
import org.apache.jmeter.exceptions.IllegalUserActionException;
import org.apache.jmeter.gui.GuiPackage;
import org.apache.jmeter.gui.action.ActionRouter;
import org.apache.jmeter.gui.action.Command;
import org.apache.jmeter.gui.tree.JMeterTreeNode;
import org.apache.jmeter.gui.util.FileDialoger;
import org.apache.jmeter.save.OldSaveService;
import org.apache.jmeter.save.SaveService;
import org.apache.jmeter.testelement.TestElement;
import org.apache.jorphan.collections.HashTree;
import org.apache.jorphan.collections.ListedHashTree;
import org.apache.jorphan.logging.LoggingManager;
import org.apache.log.Logger;

public class Save
implements Command {
    private static transient Logger log = LoggingManager.getLoggerForClass();
    public static final String SAVE_ALL_AS = "save_all_as";
    public static final String SAVE_AS = "save_as";
    public static final String SAVE = "save";
    private static Set commands = new HashSet();

    public Set getActionNames() {
        return commands;
    }

    public void doAction(ActionEvent e) throws IllegalUserActionException {
        HashTree subTree = null;
        if (!commands.contains(e.getActionCommand())) {
            throw new IllegalUserActionException("Invalid user command:" + e.getActionCommand());
        }
        subTree = e.getActionCommand().equals(SAVE_AS) ? GuiPackage.getInstance().getCurrentSubTree() : GuiPackage.getInstance().getTreeModel().getTestPlan();
        String updateFile = GuiPackage.getInstance().getTestPlanFile();
        if (!SAVE.equals(e.getActionCommand()) || updateFile == null) {
            JFileChooser chooser = FileDialoger.promptToSaveFile(GuiPackage.getInstance().getTreeListener().getCurrentNode().getName() + ".jmx");
            if (chooser == null) {
                return;
            }
            updateFile = chooser.getSelectedFile().getAbsolutePath();
            if (!e.getActionCommand().equals(SAVE_AS)) {
                GuiPackage.getInstance().setTestPlanFile(updateFile);
            }
        }
        ActionRouter.getInstance().doActionNow(new ActionEvent(subTree, e.getID(), "sub_tree_saved"));
        try {
            this.convertSubTree(subTree);
        }
        catch (Exception err) {
            // empty catch block
        }
        FileWriter writer = null;
        FileOutputStream ostream = null;
        try {
            if (SaveService.isSaveTestPlanFormat20()) {
                ostream = new FileOutputStream(updateFile);
                OldSaveService.saveSubTree(subTree, ostream);
            } else {
                writer = new FileWriter(updateFile);
                SaveService.saveTree(subTree, writer);
            }
            this.closeWriter(writer);
            this.closeStream(ostream);
        }
        catch (Throwable ex) {
            try {
                GuiPackage.getInstance().setTestPlanFile(null);
                log.error("", ex);
                throw new IllegalUserActionException("Couldn't save test plan to file: " + updateFile);
            }
            catch (Throwable throwable) {
                this.closeWriter(writer);
                this.closeStream(ostream);
                throw throwable;
            }
        }
    }

    private void convertSubTree(HashTree tree) {
        Iterator iter = new LinkedList(tree.list()).iterator();
        while (iter.hasNext()) {
            JMeterTreeNode item = (JMeterTreeNode)iter.next();
            this.convertSubTree(tree.getTree((Object)item));
            TestElement testElement = item.getTestElement();
            tree.replace((Object)item, (Object)testElement);
        }
    }

    private void closeWriter(Writer writer) {
        if (writer != null) {
            try {
                writer.close();
            }
            catch (Exception ex) {
                log.error("", (Throwable)ex);
            }
        }
    }

    private void closeStream(FileOutputStream fos) {
        if (fos != null) {
            try {
                fos.close();
            }
            catch (Exception ex) {
                log.error("", (Throwable)ex);
            }
        }
    }

    static {
        commands.add(SAVE_AS);
        commands.add(SAVE_ALL_AS);
        commands.add(SAVE);
    }

    public static class Test
    extends TestCase {
        Save save;

        public Test(String name) {
            super(name);
        }

        public void setUp() {
            this.save = new Save();
        }

        public void testTreeConversion() throws Exception {
            ListedHashTree tree = new ListedHashTree();
            JMeterTreeNode root = new JMeterTreeNode(new Arguments(), null);
            tree.add((Object)root, (Object)root);
            tree.getTree((Object)root).add((Object)root, (Object)root);
            this.save.convertSubTree((HashTree)tree);
            Test.assertEquals((String)tree.getArray()[0].getClass().getName(), (String)root.getTestElement().getClass().getName());
            tree = tree.getTree(tree.getArray()[0]);
            Test.assertEquals((String)tree.getArray()[0].getClass().getName(), (String)root.getTestElement().getClass().getName());
            Test.assertEquals((String)tree.getTree(tree.getArray()[0]).getArray()[0].getClass().getName(), (String)root.getTestElement().getClass().getName());
        }
    }
}

