/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jmeter.gui.util;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JFileChooser;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.table.TableModel;
import org.apache.jmeter.gui.GuiPackage;
import org.apache.jmeter.gui.JMeterFileFilter;
import org.apache.jmeter.gui.util.HorizontalPanel;
import org.apache.jmeter.util.JMeterUtils;
import org.apache.jorphan.gui.ObjectTableModel;
import org.apache.jorphan.reflect.Functor;

public class FileListPanel
extends JPanel
implements ActionListener {
    protected JTable files = null;
    protected transient ObjectTableModel tableModel = null;
    JButton browse = new JButton(JMeterUtils.getResString("browse"));
    JButton clear = new JButton(JMeterUtils.getResString("clear"));
    private JButton delete = new JButton(JMeterUtils.getResString("delete"));
    List listeners = new LinkedList();
    String title;
    String filetype;
    static /* synthetic */ Class class$java$lang$String;

    public FileListPanel() {
        this.title = "";
        this.init();
    }

    public FileListPanel(String title) {
        this.title = title;
        this.init();
    }

    public FileListPanel(String title, String filetype) {
        this(title);
        this.filetype = filetype;
        this.init();
    }

    public FileListPanel(ChangeListener l, String title) {
        this.title = title;
        this.init();
        this.listeners.add(l);
    }

    public void addChangeListener(ChangeListener l) {
        this.listeners.add(l);
    }

    private void init() {
        this.setLayout(new BorderLayout(0, 5));
        this.setBorder(BorderFactory.createEmptyBorder(5, 0, 5, 5));
        JLabel jtitle = new JLabel(this.title);
        HorizontalPanel buttons = new HorizontalPanel();
        buttons.add(jtitle);
        buttons.add(this.browse);
        buttons.add(this.delete);
        buttons.add(this.clear);
        this.add((Component)buttons, "North");
        this.initializeTableModel();
        this.files = new JTable((TableModel)this.tableModel);
        this.files.setSelectionMode(2);
        this.files.revalidate();
        JScrollPane scrollpane = new JScrollPane(this.files);
        scrollpane.setPreferredSize(new Dimension(400, 140));
        this.add((Component)scrollpane, "Center");
        this.browse.setActionCommand("browse");
        this.browse.addActionListener(this);
        this.clear.addActionListener(this);
        this.delete.addActionListener(this);
        this.setPreferredSize(new Dimension(400, 230));
    }

    public void enableFile(boolean enable) {
        this.browse.setEnabled(enable);
        this.files.setEnabled(false);
    }

    public void addFilename(String f) {
        this.tableModel.addRow((Object)f);
    }

    public void clearFiles() {
        this.tableModel.clearData();
    }

    public void setFiles(String[] files) {
        this.clearFiles();
        for (int idx = 0; idx < files.length; ++idx) {
            this.addFilename(files[idx]);
        }
    }

    public String[] getFiles() {
        String[] files = new String[this.tableModel.getRowCount()];
        for (int idx = 0; idx < files.length; ++idx) {
            files[idx] = (String)this.tableModel.getValueAt(idx, 0);
        }
        return files;
    }

    protected void deleteFile() {
        int rowSelected = this.files.getSelectedRow();
        if (rowSelected >= 0) {
            this.tableModel.removeRow(rowSelected);
            this.tableModel.fireTableDataChanged();
        }
    }

    private void fireFileChanged() {
        Iterator iter = this.listeners.iterator();
        while (iter.hasNext()) {
            ((ChangeListener)iter.next()).stateChanged(new ChangeEvent(this));
        }
    }

    protected void initializeTableModel() {
        this.tableModel = new ObjectTableModel(new String[]{"Library"}, new Functor[]{}, new Functor[]{}, new Class[]{class$java$lang$String == null ? (class$java$lang$String = FileListPanel.class$("java.lang.String")) : class$java$lang$String});
    }

    public void actionPerformed(ActionEvent e) {
        if (e.getSource() == this.clear) {
            this.clearFiles();
        } else if (e.getActionCommand().equals("browse")) {
            JFileChooser chooser = new JFileChooser();
            String start = JMeterUtils.getPropDefault("user.dir", "");
            chooser.setCurrentDirectory(new File(start));
            chooser.setFileFilter(new JMeterFileFilter(new String[]{this.filetype}));
            chooser.setFileSelectionMode(2);
            chooser.setMultiSelectionEnabled(true);
            chooser.showOpenDialog(GuiPackage.getInstance().getMainFrame());
            File[] cfiles = chooser.getSelectedFiles();
            if (chooser != null && cfiles != null) {
                for (int idx = 0; idx < cfiles.length; ++idx) {
                    this.addFilename(cfiles[idx].getPath());
                }
                this.fireFileChanged();
            }
        } else if (e.getSource() == this.delete) {
            this.deleteFile();
        } else {
            this.fireFileChanged();
        }
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

