/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jmeter.junit;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.io.StringReader;
import java.io.StringWriter;
import java.rmi.RemoteException;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.swing.JComponent;
import junit.framework.Test;
import junit.framework.TestSuite;
import org.apache.jmeter.functions.Function;
import org.apache.jmeter.gui.GuiPackage;
import org.apache.jmeter.gui.JMeterGUIComponent;
import org.apache.jmeter.gui.MainFrame;
import org.apache.jmeter.gui.UnsharedComponent;
import org.apache.jmeter.gui.action.ActionRouter;
import org.apache.jmeter.gui.tree.JMeterTreeListener;
import org.apache.jmeter.gui.tree.JMeterTreeModel;
import org.apache.jmeter.gui.tree.JMeterTreeNode;
import org.apache.jmeter.junit.JMeterTestCase;
import org.apache.jmeter.save.SaveService;
import org.apache.jmeter.testbeans.gui.TestBeanGUI;
import org.apache.jmeter.testelement.TestElement;
import org.apache.jmeter.testelement.property.JMeterProperty;
import org.apache.jmeter.testelement.property.PropertyIterator;
import org.apache.jmeter.util.JMeterUtils;
import org.apache.jorphan.logging.LoggingManager;
import org.apache.jorphan.reflect.ClassFinder;
import org.apache.jorphan.util.JOrphanUtils;
import org.apache.log.Logger;
import org.jdom.Document;
import org.jdom.Element;
import org.jdom.input.SAXBuilder;

public class JMeterTest
extends JMeterTestCase {
    private static Logger log = LoggingManager.getLoggerForClass();
    private static Map guiTitles;
    private static Map guiTags;
    private static Map funcTitles;
    private TestElement testItem;
    private Serializable serObj;
    private JMeterGUIComponent guiItem;
    private Function funcItem;
    private static boolean classPathShown;
    static /* synthetic */ Class class$org$apache$jmeter$gui$JMeterGUIComponent;
    static /* synthetic */ Class class$org$apache$jmeter$functions$Function;
    static /* synthetic */ Class class$org$apache$jmeter$engine$util$CompoundVariable;
    static /* synthetic */ Class class$org$apache$jmeter$testbeans$TestBean;
    static /* synthetic */ Class class$java$io$Serializable;
    static /* synthetic */ Class class$org$apache$jmeter$testelement$TestElement;
    static /* synthetic */ Class class$java$lang$Object;

    public JMeterTest(String name) {
        super(name);
    }

    public JMeterTest(String testName, TestElement te) {
        super(testName);
        this.testItem = te;
    }

    public JMeterTest(String testName, Serializable ser) {
        super(testName);
        this.serObj = ser;
    }

    public JMeterTest(String testName, JMeterGUIComponent gc) {
        super(testName);
        this.guiItem = gc;
    }

    public JMeterTest(String testName, Function fi) {
        super(testName);
        this.funcItem = fi;
    }

    public static Test suite() throws Exception {
        JMeterTreeModel treeModel = new JMeterTreeModel();
        JMeterTreeListener treeLis = new JMeterTreeListener(treeModel);
        treeLis.setActionHandler(ActionRouter.getInstance());
        GuiPackage.getInstance(treeLis, treeModel);
        try {
            MainFrame main = new MainFrame(ActionRouter.getInstance(), treeModel, treeLis);
        }
        catch (RuntimeException e) {
            System.out.println("Cannot create MainFrame: " + e);
        }
        TestSuite suite = new TestSuite();
        suite.addTest((Test)new JMeterTest("createTitleSet"));
        suite.addTest((Test)new JMeterTest("createTagSet"));
        suite.addTest(JMeterTest.suiteGUIComponents());
        suite.addTest(JMeterTest.suiteSerializableElements());
        suite.addTest(JMeterTest.suiteTestElements());
        suite.addTest(JMeterTest.suiteBeanComponents());
        suite.addTest((Test)new JMeterTest("createFunctionSet"));
        suite.addTest(JMeterTest.suiteFunctions());
        suite.addTest((Test)new JMeterTest("checkGuiSet"));
        suite.addTest((Test)new JMeterTest("checkFunctionSet"));
        return suite;
    }

    public void createTitleSet() throws Exception {
        guiTitles = new HashMap(90);
        String compref = "../xdocs/usermanual/component_reference.xml";
        SAXBuilder bldr = new SAXBuilder();
        Document doc = bldr.build(compref);
        Element root = doc.getRootElement();
        Element body = root.getChild("body");
        List sections = body.getChildren("section");
        for (int i = 0; i < sections.size(); ++i) {
            List components = ((Element)sections.get(i)).getChildren("component");
            for (int j = 0; j < components.size(); ++j) {
                Element comp = (Element)components.get(j);
                String nm = comp.getAttributeValue("name");
                if (nm.equals("SSL Manager")) continue;
                guiTitles.put(nm.replace(' ', '_'), Boolean.FALSE);
            }
        }
        guiTitles.put("Example Sampler", Boolean.FALSE);
    }

    public void createTagSet() throws Exception {
        guiTags = new HashMap(90);
        String compref = "../xdocs/usermanual/component_reference.xml";
        SAXBuilder bldr = new SAXBuilder();
        Document doc = bldr.build(compref);
        Element root = doc.getRootElement();
        Element body = root.getChild("body");
        List sections = body.getChildren("section");
        for (int i = 0; i < sections.size(); ++i) {
            List components = ((Element)sections.get(i)).getChildren("component");
            for (int j = 0; j < components.size(); ++j) {
                Element comp = (Element)components.get(j);
                guiTags.put(comp.getAttributeValue("tag"), Boolean.FALSE);
            }
        }
    }

    public void createFunctionSet() throws Exception {
        funcTitles = new HashMap(20);
        String compref = "../xdocs/usermanual/functions.xml";
        SAXBuilder bldr = new SAXBuilder();
        Document doc = bldr.build(compref);
        Element root = doc.getRootElement();
        Element body = root.getChild("body");
        Element section = body.getChild("section");
        List sections = section.getChildren("subsection");
        for (int i = 0; i < sections.size(); ++i) {
            List components = ((Element)sections.get(i)).getChildren("component");
            for (int j = 0; j < components.size(); ++j) {
                Element comp = (Element)components.get(j);
                funcTitles.put(comp.getAttributeValue("name"), Boolean.FALSE);
            }
        }
    }

    private int scanprintMap(Map m, String t) {
        Set s = m.keySet();
        int unseen = 0;
        if (s.size() == 0) {
            return 0;
        }
        Iterator i = s.iterator();
        while (i.hasNext()) {
            Object key = i.next();
            if (m.get(key).equals(Boolean.TRUE)) continue;
            if (unseen == 0) {
                System.out.println("\nNames remaining in " + t + " Map:");
            }
            ++unseen;
            System.out.println(key);
        }
        return unseen;
    }

    public void checkGuiSet() throws Exception {
        guiTitles.remove("Example Sampler");
        JMeterTest.assertEquals((String)"Should not have any names left over", (int)0, (int)this.scanprintMap(guiTitles, "GUI"));
    }

    public void checkFunctionSet() throws Exception {
        JMeterTest.assertEquals((String)"Should not have any names left over", (int)0, (int)this.scanprintMap(funcTitles, "Function"));
    }

    private static Test suiteGUIComponents() throws Exception {
        TestSuite suite = new TestSuite("GuiComponents");
        Iterator iter = JMeterTest.getObjects(class$org$apache$jmeter$gui$JMeterGUIComponent == null ? (class$org$apache$jmeter$gui$JMeterGUIComponent = JMeterTest.class$("org.apache.jmeter.gui.JMeterGUIComponent")) : class$org$apache$jmeter$gui$JMeterGUIComponent).iterator();
        while (iter.hasNext()) {
            JMeterGUIComponent item = (JMeterGUIComponent)iter.next();
            if (item instanceof JMeterTreeNode) {
                System.out.println("INFO: JMeterGUIComponent: skipping all tests  " + item.getClass().getName());
                continue;
            }
            TestSuite ts = new TestSuite(item.getClass().getName());
            ts.addTest((Test)new JMeterTest("GUIComponents1", item));
            if (item instanceof TestBeanGUI) {
                System.out.println("INFO: JMeterGUIComponent: skipping some tests " + item.getClass().getName());
            } else {
                ts.addTest((Test)new JMeterTest("GUIComponents2", item));
                ts.addTest((Test)new JMeterTest("runGUITitle", item));
            }
            suite.addTest((Test)ts);
        }
        return suite;
    }

    private static Test suiteFunctions() throws Exception {
        TestSuite suite = new TestSuite("Functions");
        Iterator iter = JMeterTest.getObjects(class$org$apache$jmeter$functions$Function == null ? (class$org$apache$jmeter$functions$Function = JMeterTest.class$("org.apache.jmeter.functions.Function")) : class$org$apache$jmeter$functions$Function).iterator();
        while (iter.hasNext()) {
            Object item = iter.next();
            if (item.getClass().equals(class$org$apache$jmeter$engine$util$CompoundVariable == null ? JMeterTest.class$("org.apache.jmeter.engine.util.CompoundVariable") : class$org$apache$jmeter$engine$util$CompoundVariable)) continue;
            TestSuite ts = new TestSuite(item.getClass().getName());
            ts.addTest((Test)new JMeterTest("runFunction", (Function)item));
            ts.addTest((Test)new JMeterTest("runFunction2", (Function)item));
            suite.addTest((Test)ts);
        }
        return suite;
    }

    private static Test suiteBeanComponents() throws Exception {
        TestSuite suite = new TestSuite("BeanComponents");
        Iterator iter = JMeterTest.getObjects(class$org$apache$jmeter$testbeans$TestBean == null ? (class$org$apache$jmeter$testbeans$TestBean = JMeterTest.class$("org.apache.jmeter.testbeans.TestBean")) : class$org$apache$jmeter$testbeans$TestBean).iterator();
        while (iter.hasNext()) {
            Class<?> c = iter.next().getClass();
            try {
                TestBeanGUI item = new TestBeanGUI(c);
                TestSuite ts = new TestSuite(item.getClass().getName());
                ts.addTest((Test)new JMeterTest("GUIComponents2", item));
                ts.addTest((Test)new JMeterTest("runGUITitle", item));
                suite.addTest((Test)ts);
            }
            catch (IllegalArgumentException e) {
                System.out.println("Cannot create test for " + c.getName() + " " + e);
                e.printStackTrace(System.out);
            }
        }
        return suite;
    }

    public void runGUITitle() throws Exception {
        if (guiTitles.size() > 0) {
            String title = this.guiItem.getDocAnchor();
            boolean ct = guiTitles.containsKey(title);
            if (ct) {
                guiTitles.put(title, Boolean.TRUE);
            }
            if (title != null && title.length() > 0 && title.toUpperCase().indexOf("(ALPHA") == -1 && title.toUpperCase().indexOf("(BETA") == -1 && !title.equals("Example1") && !title.equals("Example2")) {
                String s = "component_reference.xml needs '" + title + "' anchor for " + this.guiItem.getClass().getName();
                if (!ct) {
                    log.warn(s);
                }
                JMeterTest.assertTrue((String)s, (boolean)ct);
            }
        }
    }

    public void runFunction() throws Exception {
        if (funcTitles.size() > 0) {
            String title = this.funcItem.getReferenceKey();
            boolean ct = funcTitles.containsKey(title);
            if (ct) {
                funcTitles.put(title, Boolean.TRUE);
            }
            if (title.indexOf("(ALPHA") == -1 && title.indexOf("(EXPERIMENTAL") == -1) {
                String s = "function.xml needs '" + title + "' entry for " + this.funcItem.getClass().getName();
                if (!ct) {
                    log.warn(s);
                }
                JMeterTest.assertTrue((String)s, (boolean)ct);
            }
        }
    }

    public void runFunction2() throws Exception {
        Iterator i = this.funcItem.getArgumentDesc().iterator();
        while (i.hasNext()) {
            Object o = i.next();
            JMeterTest.assertTrue((String)"Description must be a String", (boolean)(o instanceof String));
            JMeterTest.assertFalse((String)"Description must not start with [refkey", (boolean)((String)o).startsWith("[refkey"));
        }
    }

    public void GUIComponents1() throws Exception {
        String name = this.guiItem.getClass().getName();
        JMeterTest.assertEquals((String)("Name should be same as static label for " + name), (String)this.guiItem.getStaticLabel(), (String)this.guiItem.getName());
        if (!name.endsWith("TestBeanGUI")) {
            try {
                String label = this.guiItem.getLabelResource();
                JMeterTest.assertTrue((label.length() > 0 ? 1 : 0) != 0);
                if (!label.equals("unused")) {
                    JMeterTest.assertFalse((String)("'" + label + "' should be in resource file for " + name), (boolean)JMeterUtils.getResString(label).startsWith("[res_key="));
                }
            }
            catch (UnsupportedOperationException uoe) {
                log.warn("Class has not yet implemented getLabelResource " + name);
            }
        }
    }

    public void GUIComponents2() throws Exception {
        String name = this.guiItem.getClass().getName();
        TestElement el = this.guiItem.createTestElement();
        JMeterTest.assertNotNull((String)(name + ".createTestElement should be non-null "), (Object)el);
        JMeterTest.assertEquals((String)("GUI-CLASS: Failed on " + name), (String)name, (String)el.getPropertyAsString("TestElement.gui_class"));
        JMeterTest.assertEquals((String)("NAME: Failed on " + name), (String)this.guiItem.getName(), (String)el.getPropertyAsString("TestElement.name"));
        JMeterTest.assertEquals((String)("TEST-CLASS: Failed on " + name), (String)el.getClass().getName(), (String)el.getPropertyAsString("TestElement.test_class"));
        TestElement el2 = this.guiItem.createTestElement();
        el.setProperty("TestElement.name", "hey, new name!:");
        el.setProperty("NOT", "Shouldn't be here");
        if (!(this.guiItem instanceof UnsharedComponent)) {
            JMeterTest.assertEquals((String)("SHARED: Failed on " + name), (String)"", (String)el2.getPropertyAsString("NOT"));
        }
        log.debug("Saving element: " + el.getClass());
        StringWriter writer = new StringWriter();
        SaveService.saveElement(el, writer);
        el = (TestElement)SaveService.loadElement(new StringReader(writer.toString()));
        log.debug("Successfully saved");
        this.guiItem.configure(el);
        JMeterTest.assertEquals((String)("CONFIGURE-TEST: Failed on " + name), (String)el.getPropertyAsString("TestElement.name"), (String)this.guiItem.getName());
        this.guiItem.modifyTestElement(el2);
        JMeterTest.assertEquals((String)("Modify Test: Failed on " + name), (String)"hey, new name!:", (String)el2.getPropertyAsString("TestElement.name"));
    }

    private static Test suiteSerializableElements() throws Exception {
        TestSuite suite = new TestSuite("SerializableElements");
        Iterator iter = JMeterTest.getObjects(class$java$io$Serializable == null ? (class$java$io$Serializable = JMeterTest.class$("java.io.Serializable")) : class$java$io$Serializable).iterator();
        while (iter.hasNext()) {
            Serializable serObj = (Serializable)iter.next();
            if (serObj.getClass().getName().endsWith("_Stub")) continue;
            TestSuite ts = new TestSuite(serObj.getClass().getName());
            ts.addTest((Test)new JMeterTest("runSerialTest", serObj));
            suite.addTest((Test)ts);
        }
        return suite;
    }

    public void runSerialTest() throws Exception {
        if (!(this.serObj instanceof JComponent)) {
            try {
                ByteArrayOutputStream bytes = new ByteArrayOutputStream();
                ObjectOutputStream out = new ObjectOutputStream(bytes);
                out.writeObject(this.serObj);
                out.close();
                ObjectInputStream in = new ObjectInputStream(new ByteArrayInputStream(bytes.toByteArray()));
                Object readObject = in.readObject();
                in.close();
                JMeterTest.assertEquals((String)("deserializing class: " + this.serObj.getClass().getName()), this.serObj.getClass(), readObject.getClass());
            }
            catch (Throwable e) {
                JMeterTest.fail((String)("serialization of " + this.serObj.getClass().getName() + " failed: " + e));
            }
        }
    }

    private static Test suiteTestElements() throws Exception {
        TestSuite suite = new TestSuite("TestElements");
        Iterator iter = JMeterTest.getObjects(class$org$apache$jmeter$testelement$TestElement == null ? (class$org$apache$jmeter$testelement$TestElement = JMeterTest.class$("org.apache.jmeter.testelement.TestElement")) : class$org$apache$jmeter$testelement$TestElement).iterator();
        while (iter.hasNext()) {
            TestElement item = (TestElement)iter.next();
            TestSuite ts = new TestSuite(item.getClass().getName());
            ts.addTest((Test)new JMeterTest("runTestElement", item));
            suite.addTest((Test)ts);
        }
        return suite;
    }

    public void runTestElement() throws Exception {
        JMeterTest.checkElementCloning(this.testItem);
        JMeterTest.assertTrue((String)(this.testItem.getClass().getName() + " must implement Serializable"), (boolean)(this.testItem instanceof Serializable));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static Collection getObjects(Class extendsClass) throws Exception {
        String exName = extendsClass.getName();
        String myThis = "";
        Iterator classes = ClassFinder.findClassesThatExtend((String[])JMeterUtils.getSearchPaths(), (Class[])new Class[]{extendsClass}).iterator();
        LinkedList objects = new LinkedList();
        String n = "";
        boolean caughtError = true;
        Exception caught = null;
        try {
            while (classes.hasNext()) {
                n = (String)classes.next();
                if (n.endsWith("RemoteJMeterEngineImpl")) continue;
                Class<?> c = null;
                try {
                    c = Class.forName(n);
                    try {
                        objects.add(c.newInstance());
                    }
                    catch (InstantiationException e) {
                        caught = e;
                        try {
                            objects.add(c.getConstructor(class$java$lang$Object == null ? JMeterTest.class$("java.lang.Object") : class$java$lang$Object).newInstance(myThis));
                        }
                        catch (NoSuchMethodException f) {
                            System.out.println("WARN: " + exName + ": NoSuchMethodException  " + n);
                        }
                    }
                }
                catch (NoClassDefFoundError e) {
                    System.out.println("WARN: " + exName + ": NoClassDefFoundError " + n);
                }
                catch (IllegalAccessException e) {
                    caught = e;
                    System.out.println("WARN: " + exName + ": IllegalAccessException " + n);
                }
                catch (Exception e) {
                    caught = e;
                    if (!(e instanceof RemoteException) && !e.getClass().getName().equals("java.awt.HeadlessException")) {
                        throw new Exception("Error creating " + n + " " + e.toString());
                    }
                    System.out.println("WARN: Error creating " + n + " " + e.toString());
                }
            }
            caughtError = false;
            Object var12_18 = null;
            if (caughtError) {
                System.out.println("Last class=" + n);
                System.out.println("objects.size=" + objects.size());
                System.out.println("Last error=" + caught);
            }
        }
        catch (Throwable throwable) {
            Object var12_19 = null;
            if (caughtError) {
                System.out.println("Last class=" + n);
                System.out.println("objects.size=" + objects.size());
                System.out.println("Last error=" + caught);
            }
            throw throwable;
        }
        if (objects.size() == 0) {
            System.out.println("No classes found that extend " + exName + ". Check the following:");
            System.out.println("Search paths are:");
            String[] ss = JMeterUtils.getSearchPaths();
            for (int i = 0; i < ss.length; ++i) {
                System.out.println(ss[i]);
            }
            if (!classPathShown) {
                System.out.println("Class path is:");
                String cp = System.getProperty("java.class.path");
                String[] cpe = JOrphanUtils.split((String)cp, (String)File.pathSeparator);
                for (int i = 0; i < cpe.length; ++i) {
                    System.out.println(cpe[i]);
                }
                classPathShown = true;
            }
        }
        return objects;
    }

    private static void cloneTesting(TestElement item, TestElement clonedItem) {
        JMeterTest.assertTrue((item != clonedItem ? 1 : 0) != 0);
        JMeterTest.assertEquals((String)("CLONE-SAME-CLASS: testing " + item.getClass().getName()), (String)item.getClass().getName(), (String)clonedItem.getClass().getName());
    }

    private static void checkElementCloning(TestElement item) {
        TestElement clonedItem = (TestElement)item.clone();
        JMeterTest.cloneTesting(item, clonedItem);
        PropertyIterator iter2 = item.propertyIterator();
        while (iter2.hasNext()) {
            JMeterProperty item2 = iter2.next();
            JMeterTest.assertEquals((String)item2.getStringValue(), (String)clonedItem.getProperty(item2.getName()).getStringValue());
            JMeterTest.assertTrue((item2 != clonedItem.getProperty(item2.getName()) ? 1 : 0) != 0);
        }
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    static {
        classPathShown = false;
    }
}

