/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jmeter.junit;

import java.io.File;
import java.util.MissingResourceException;
import junit.framework.TestCase;
import org.apache.jmeter.util.JMeterUtils;
import org.apache.jorphan.logging.LoggingManager;
import org.apache.log.Logger;

public abstract class JMeterTestCase
extends TestCase {
    private static final String filePrefix;
    protected static final Logger testLog;

    public JMeterTestCase() {
    }

    public JMeterTestCase(String name) {
        super(name);
    }

    private static void logprop(String prop) {
        System.out.println(prop + "=" + System.getProperty(prop));
    }

    protected static File findTestFile(String file) {
        File f = new File(file);
        if (filePrefix.length() > 0 && !f.isAbsolute()) {
            f = new File(filePrefix + file);
        }
        return f;
    }

    static {
        if (JMeterUtils.getJMeterProperties() == null) {
            String file = "jmetertest.properties";
            File f = new File(file);
            if (!f.canRead()) {
                System.out.println("Can't find " + file + " - trying bin directory");
                file = "bin/" + file;
                System.setProperty("user.dir", System.getProperty("user.dir") + File.separatorChar + "bin");
                System.out.println("Setting user.dir=" + System.getProperty("user.dir"));
                filePrefix = "bin/";
            } else {
                filePrefix = "";
            }
            JMeterUtils jmu = new JMeterUtils();
            try {
                jmu.initializeProperties(file);
            }
            catch (MissingResourceException e) {
                System.out.println("** Can't find resources - continuing anyway **");
            }
            JMeterTestCase.logprop("java.version");
            JMeterTestCase.logprop("java.vendor");
            JMeterTestCase.logprop("java.home");
            JMeterTestCase.logprop("user.home");
            JMeterTestCase.logprop("user.dir");
            JMeterTestCase.logprop("java.class.version");
            JMeterTestCase.logprop("os.name");
            JMeterTestCase.logprop("os.version");
            JMeterTestCase.logprop("os.arch");
            JMeterTestCase.logprop("java.class.path");
        } else {
            filePrefix = "";
        }
        testLog = LoggingManager.getLoggerForClass();
    }
}

