/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jmeter.reporters;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.BufferedReader;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.io.RandomAccessFile;
import java.io.Serializable;
import java.io.Writer;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import org.apache.avalon.framework.configuration.Configuration;
import org.apache.avalon.framework.configuration.ConfigurationException;
import org.apache.avalon.framework.configuration.DefaultConfigurationBuilder;
import org.apache.avalon.framework.configuration.DefaultConfigurationSerializer;
import org.apache.jmeter.engine.event.LoopIterationEvent;
import org.apache.jmeter.engine.util.NoThreadClone;
import org.apache.jmeter.reporters.AbstractListenerElement;
import org.apache.jmeter.samplers.Clearable;
import org.apache.jmeter.samplers.Remoteable;
import org.apache.jmeter.samplers.SampleEvent;
import org.apache.jmeter.samplers.SampleListener;
import org.apache.jmeter.samplers.SampleResult;
import org.apache.jmeter.samplers.SampleSaveConfiguration;
import org.apache.jmeter.save.OldSaveService;
import org.apache.jmeter.save.SaveService;
import org.apache.jmeter.save.TestResultWrapper;
import org.apache.jmeter.testelement.TestElement;
import org.apache.jmeter.testelement.TestListener;
import org.apache.jmeter.testelement.property.BooleanProperty;
import org.apache.jmeter.testelement.property.ObjectProperty;
import org.apache.jorphan.logging.LoggingManager;
import org.apache.log.Logger;
import org.xml.sax.SAXException;

public class ResultCollector
extends AbstractListenerElement
implements SampleListener,
Clearable,
Serializable,
TestListener,
Remoteable,
NoThreadClone {
    static final long serialVersionUID = 2L;
    private static final String TESTRESULTS_START = "<testResults>";
    private static final String TESTRESULTS_START_V1_1 = "<testResults version=\"1.1\">";
    private static final String TESTRESULTS_END = "</testResults>";
    private static final String XML_HEADER = "<?xml version=\"1.0\" encoding=\"UTF-8\"?>";
    private static final int MIN_XML_FILE_LEN = "<?xml version=\"1.0\" encoding=\"UTF-8\"?>".length() + "<testResults>".length() + "</testResults>".length();
    private static transient Logger log = LoggingManager.getLoggerForClass();
    public static final String FILENAME = "filename";
    public static final String SAVE_CONFIG = "saveConfig";
    public static final String ERROR_LOGGING = "ResultCollector.error_logging";
    private transient DefaultConfigurationSerializer serializer;
    private volatile transient PrintWriter out;
    private boolean inTest = false;
    private static Map files = new HashMap();
    private Set hosts = new HashSet();
    protected boolean isStats = false;

    public ResultCollector() {
        this.setErrorLogging(false);
        this.setProperty(new ObjectProperty(SAVE_CONFIG, new SampleSaveConfiguration()));
    }

    private void setFilenameProperty(String f) {
        this.setProperty(FILENAME, f);
    }

    public String getFilename() {
        return this.getPropertyAsString(FILENAME);
    }

    public boolean isErrorLogging() {
        return this.getPropertyAsBoolean(ERROR_LOGGING);
    }

    public void setErrorLogging(boolean errorLogging) {
        this.setProperty(new BooleanProperty(ERROR_LOGGING, errorLogging));
    }

    public void setFilename(String f) {
        if (this.inTest) {
            return;
        }
        this.setFilenameProperty(f);
    }

    public void testEnded(String host) {
        this.hosts.remove(host);
        if (this.hosts.size() == 0) {
            this.finalizeFileOutput();
            this.inTest = false;
        }
    }

    public void testStarted(String host) {
        this.hosts.add(host);
        try {
            this.initializeFileOutput();
            if (this.getVisualizer() != null) {
                this.isStats = this.getVisualizer().isStats();
            }
        }
        catch (Exception e) {
            log.error("", (Throwable)e);
        }
        this.inTest = true;
    }

    public void testEnded() {
        this.testEnded("local");
    }

    public void testStarted() {
        this.testStarted("local");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void loadExistingFile() throws IOException {
        boolean parsedOK;
        block11: {
            parsedOK = false;
            if (!new File(this.getFilename()).exists()) return;
            this.clearVisualizer();
            BufferedReader dataReader = null;
            try {
                try {
                    this.readSamples(SaveService.loadTestResults(new BufferedInputStream(new FileInputStream(this.getFilename()))));
                    parsedOK = true;
                }
                catch (Exception e) {
                    log.warn("File load failure, trying old data format.");
                    try {
                        Configuration savedSamples = this.getConfiguration(this.getFilename());
                        Configuration[] samples = savedSamples.getChildren();
                        for (int i = 0; i < samples.length; ++i) {
                            SampleResult result = OldSaveService.getSampleResult(samples[i]);
                            this.sendToVisualizer(result);
                        }
                    }
                    catch (Exception e1) {
                        String line;
                        log.warn("Error parsing XML results " + e);
                        log.info("Assuming CSV format instead");
                        dataReader = new BufferedReader(new FileReader(this.getFilename()));
                        while ((line = dataReader.readLine()) != null) {
                            this.sendToVisualizer(OldSaveService.makeResultFromDelimitedString(line));
                        }
                        parsedOK = true;
                    }
                    Object var9_4 = null;
                    if (dataReader != null) {
                        dataReader.close();
                    }
                    if (parsedOK) return;
                    SampleResult sr = new SampleResult();
                    sr.setSampleLabel("Error loading results file - see log file");
                    this.sendToVisualizer(sr);
                    return;
                }
                Object var9_3 = null;
                if (dataReader == null) break block11;
            }
            catch (Throwable throwable) {
                Object var9_5 = null;
                if (dataReader != null) {
                    dataReader.close();
                }
                if (parsedOK) throw throwable;
                SampleResult sr = new SampleResult();
                sr.setSampleLabel("Error loading results file - see log file");
                this.sendToVisualizer(sr);
                throw throwable;
            }
            dataReader.close();
        }
        if (parsedOK) return;
        SampleResult sr = new SampleResult();
        sr.setSampleLabel("Error loading results file - see log file");
        this.sendToVisualizer(sr);
    }

    private static void writeFileStart(PrintWriter writer, SampleSaveConfiguration saveConfig) {
        if (saveConfig.saveAsXml()) {
            writer.println(XML_HEADER);
            writer.println(TESTRESULTS_START_V1_1);
        } else if (saveConfig.saveFieldNames()) {
            writer.println(OldSaveService.printableFieldNamesToString(saveConfig));
        }
    }

    private static void writeFileEnd(PrintWriter pw, SampleSaveConfiguration saveConfig) {
        if (saveConfig.saveAsXml()) {
            pw.print("\n");
            pw.print(TESTRESULTS_END);
            pw.print("\n");
        }
    }

    private static synchronized PrintWriter getFileWriter(String filename, SampleSaveConfiguration saveConfig) throws IOException {
        if (filename == null || filename.length() == 0) {
            return null;
        }
        PrintWriter writer = (PrintWriter)files.get(filename);
        boolean trimmed = true;
        if (writer == null) {
            trimmed = saveConfig.saveAsXml() ? ResultCollector.trimLastLine(filename) : new File(filename).exists();
            File pdir = new File(filename).getParentFile();
            if (pdir != null) {
                pdir.mkdirs();
            }
            writer = new PrintWriter((Writer)new OutputStreamWriter((OutputStream)new BufferedOutputStream(new FileOutputStream(filename, trimmed)), "UTF-8"), true);
            files.put(filename, writer);
        }
        if (!trimmed) {
            ResultCollector.writeFileStart(writer, saveConfig);
        }
        return writer;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    private static boolean trimLastLine(String filename) {
        block26: {
            int end;
            long pos;
            RandomAccessFile raf;
            block24: {
                String line;
                long len;
                block22: {
                    raf = null;
                    raf = new RandomAccessFile(filename, "rw");
                    len = raf.length();
                    if (len >= (long)MIN_XML_FILE_LEN) break block22;
                    boolean bl = false;
                    Object var10_7 = null;
                    try {
                        if (raf != null) {
                            raf.close();
                        }
                    }
                    catch (IOException e1) {
                        log.info("Could not close " + filename + " " + e1.getLocalizedMessage());
                    }
                    return bl;
                }
                raf.seek(len - (long)TESTRESULTS_END.length() - 10L);
                pos = raf.getFilePointer();
                end = 0;
                while ((line = raf.readLine()) != null && (end = line.indexOf(TESTRESULTS_END)) < 0) {
                    pos = raf.getFilePointer();
                }
                if (line != null) break block24;
                log.warn("Unexpected EOF trying to find XML end marker in " + filename);
                raf.close();
                boolean bl = false;
                Object var10_8 = null;
                try {
                    if (raf != null) {
                        raf.close();
                    }
                }
                catch (IOException e1) {
                    log.info("Could not close " + filename + " " + e1.getLocalizedMessage());
                }
                return bl;
            }
            raf.setLength(pos + (long)end);
            raf.close();
            raf = null;
            Object var10_9 = null;
            try {
                if (raf != null) {
                    raf.close();
                }
                break block26;
            }
            catch (IOException e1) {
                log.info("Could not close " + filename + " " + e1.getLocalizedMessage());
            }
            break block26;
            {
                catch (FileNotFoundException e) {
                    boolean bl = false;
                    Object var10_10 = null;
                    try {
                        if (raf != null) {
                            raf.close();
                        }
                    }
                    catch (IOException e1) {
                        log.info("Could not close " + filename + " " + e1.getLocalizedMessage());
                    }
                    return bl;
                }
                catch (IOException e) {
                    boolean bl;
                    try {
                        log.warn("Error trying to find XML terminator " + e.toString());
                        bl = false;
                        Object var10_11 = null;
                    }
                    catch (Throwable throwable) {
                        Object var10_12 = null;
                        try {
                            if (raf != null) {
                                raf.close();
                            }
                        }
                        catch (IOException e1) {
                            log.info("Could not close " + filename + " " + e1.getLocalizedMessage());
                        }
                        throw throwable;
                    }
                    try {
                        if (raf != null) {
                            raf.close();
                        }
                    }
                    catch (IOException e1) {
                        log.info("Could not close " + filename + " " + e1.getLocalizedMessage());
                    }
                    return bl;
                }
            }
        }
        return true;
    }

    private void readSamples(TestResultWrapper testResults) throws Exception {
        Collection samples = testResults.getSampleResults();
        Iterator iter = samples.iterator();
        while (iter.hasNext()) {
            SampleResult result = (SampleResult)iter.next();
            this.sendToVisualizer(result);
        }
    }

    private Configuration getConfiguration(String filename) throws SAXException, IOException, ConfigurationException {
        DefaultConfigurationBuilder builder = new DefaultConfigurationBuilder();
        return builder.buildFromFile(filename);
    }

    public void clearVisualizer() {
        if (this.getVisualizer() != null && this.getVisualizer() instanceof Clearable) {
            ((Clearable)((Object)this.getVisualizer())).clear();
        }
        this.finalizeFileOutput();
    }

    public void sampleStarted(SampleEvent e) {
    }

    public void sampleStopped(SampleEvent e) {
    }

    public void sampleOccurred(SampleEvent e) {
        SampleResult result = e.getResult();
        if (!this.isErrorLogging() || !result.isSuccessful()) {
            this.sendToVisualizer(result);
            SampleSaveConfiguration config = this.getSaveConfig();
            result.setSaveConfig(config);
            try {
                if (!config.saveAsXml()) {
                    if (this.out != null) {
                        String savee = OldSaveService.resultToDelimitedString(result);
                        this.out.println(savee);
                    }
                } else {
                    this.recordResult(result);
                }
            }
            catch (Exception err) {
                log.error("", (Throwable)err);
            }
        }
    }

    protected void sendToVisualizer(SampleResult r) {
        if (this.getVisualizer() != null) {
            this.getVisualizer().add(r);
        }
    }

    private void recordResult(SampleResult result) throws Exception {
        if (this.out != null && !this.isResultMarked(result) && !this.isStats) {
            if (SaveService.isSaveTestLogFormat20()) {
                if (this.serializer == null) {
                    this.serializer = new DefaultConfigurationSerializer();
                }
                this.out.write(this.getSerializedSampleResult(result));
            } else {
                SaveService.saveSampleResult(result, this.out);
            }
        }
    }

    private String getSerializedSampleResult(SampleResult result) throws SAXException, IOException, ConfigurationException {
        ByteArrayOutputStream tempOut = new ByteArrayOutputStream();
        this.serializer.serialize((OutputStream)tempOut, OldSaveService.getConfiguration(result, this.getSaveConfig()));
        String serVer = tempOut.toString();
        int index = serVer.indexOf(System.getProperty("line.separator"));
        if (index > -1) {
            return serVer.substring(index);
        }
        return serVer;
    }

    public void recordStats(TestElement e) throws Exception {
        if (this.out == null) {
            this.initializeFileOutput();
        }
        if (this.out != null) {
            SaveService.saveTestElement(e, this.out);
        }
    }

    private synchronized boolean isResultMarked(SampleResult res) {
        String filename = this.getFilename();
        boolean marked = res.isMarked(filename);
        if (!marked) {
            res.setMarked(filename);
        }
        return marked;
    }

    private void initializeFileOutput() throws IOException {
        String filename = this.getFilename();
        if (this.out == null && filename != null && this.out == null) {
            try {
                this.out = ResultCollector.getFileWriter(filename, this.getSaveConfig());
            }
            catch (FileNotFoundException e) {
                this.out = null;
            }
        }
    }

    private synchronized void finalizeFileOutput() {
        if (this.out != null) {
            ResultCollector.writeFileEnd(this.out, this.getSaveConfig());
            this.out.close();
            files.remove(this.getFilename());
            this.out = null;
        }
    }

    public void testIterationStart(LoopIterationEvent event) {
    }

    public SampleSaveConfiguration getSaveConfig() {
        try {
            return (SampleSaveConfiguration)this.getProperty(SAVE_CONFIG).getObjectValue();
        }
        catch (ClassCastException e) {
            this.setSaveConfig(new SampleSaveConfiguration());
            return this.getSaveConfig();
        }
    }

    public void setSaveConfig(SampleSaveConfiguration saveConfig) {
        this.getProperty(SAVE_CONFIG).setObjectValue(saveConfig);
    }
}

