/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jmeter.reporters;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.Serializable;
import org.apache.jmeter.samplers.Clearable;
import org.apache.jmeter.samplers.SampleEvent;
import org.apache.jmeter.samplers.SampleListener;
import org.apache.jmeter.samplers.SampleResult;
import org.apache.jmeter.testelement.AbstractTestElement;
import org.apache.jorphan.logging.LoggingManager;
import org.apache.log.Logger;

public class ResultSaver
extends AbstractTestElement
implements Serializable,
SampleListener,
Clearable {
    private static final Logger log = LoggingManager.getLoggerForClass();
    private static long sequenceNumber = 0L;
    public static final String FILENAME = "FileSaver.filename";
    public static final String ERRORS_ONLY = "FileSaver.errorsonly";

    private static synchronized long nextNumber() {
        return ++sequenceNumber;
    }

    public ResultSaver() {
    }

    public ResultSaver(String name) {
        this();
        this.setName(name);
    }

    public void clear() {
        super.clear();
        sequenceNumber = 0L;
    }

    public void sampleOccurred(SampleEvent e) {
        SampleResult s = e.getResult();
        this.saveSample(s);
        SampleResult[] sr = s.getSubResults();
        for (int i = 0; i < sr.length; ++i) {
            this.saveSample(sr[i]);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    private void saveSample(SampleResult s) {
        block15: {
            if (s.isSuccessful() && this.getErrorsOnly()) {
                return;
            }
            ResultSaver.nextNumber();
            String fileName = this.makeFileName(s.getContentType());
            log.debug("Saving " + s.getSampleLabel() + " in " + fileName);
            File out = new File(fileName);
            FileOutputStream pw = null;
            pw = new FileOutputStream(out);
            pw.write(s.getResponseData());
            Object var7_5 = null;
            try {
                if (pw != null) {
                    pw.close();
                }
                break block15;
            }
            catch (IOException e) {}
            break block15;
            {
                catch (FileNotFoundException e1) {
                    log.error("Error creating sample file for " + s.getSampleLabel(), (Throwable)e1);
                    Object var7_6 = null;
                    try {
                        if (pw != null) {
                            pw.close();
                        }
                        break block15;
                    }
                    catch (IOException e) {}
                    break block15;
                }
                catch (IOException e1) {
                    log.error("Error saving sample " + s.getSampleLabel(), (Throwable)e1);
                    Object var7_7 = null;
                    try {
                        if (pw != null) {
                            pw.close();
                        }
                        break block15;
                    }
                    catch (IOException e) {}
                }
            }
            catch (Throwable throwable) {
                Object var7_8 = null;
                try {
                    if (pw != null) {
                        pw.close();
                    }
                }
                catch (IOException e) {
                    // empty catch block
                }
                throw throwable;
            }
        }
    }

    private String makeFileName(String contentType) {
        int i;
        String suffix = "unknown";
        if (contentType != null && (i = contentType.indexOf("/")) != -1) {
            int j = contentType.indexOf(";");
            suffix = j != -1 ? contentType.substring(i + 1, j) : contentType.substring(i + 1);
        }
        return this.getFilename() + sequenceNumber + "." + suffix;
    }

    public void sampleStarted(SampleEvent e) {
    }

    public void sampleStopped(SampleEvent e) {
    }

    private String getFilename() {
        return this.getPropertyAsString(FILENAME);
    }

    private boolean getErrorsOnly() {
        return this.getPropertyAsBoolean(ERRORS_ONLY);
    }
}

